/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.sts.token.provider;

import java.util.ArrayList;
import org.apache.cxf.sts.request.TokenRequirements;
import org.apache.cxf.sts.token.provider.AttributeStatementProvider;
import org.apache.cxf.sts.token.provider.TokenProviderParameters;
import org.apache.wss4j.common.saml.bean.AttributeBean;
import org.apache.wss4j.common.saml.bean.AttributeStatementBean;

public class DefaultAttributeStatementProvider
implements AttributeStatementProvider {
    @Override
    public AttributeStatementBean getStatement(TokenProviderParameters providerParameters) {
        AttributeStatementBean attrBean = new AttributeStatementBean();
        ArrayList<AttributeBean> attributeList = new ArrayList<AttributeBean>();
        TokenRequirements tokenRequirements = providerParameters.getTokenRequirements();
        String tokenType = tokenRequirements.getTokenType();
        AttributeBean attributeBean = this.createDefaultAttribute(tokenType);
        attributeList.add(attributeBean);
        attrBean.setSamlAttributes(attributeList);
        return attrBean;
    }

    private AttributeBean createDefaultAttribute(String tokenType) {
        AttributeBean attributeBean = new AttributeBean();
        if ("http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.1#SAMLV1.1".equals(tokenType) || "urn:oasis:names:tc:SAML:1.0:assertion".equals(tokenType)) {
            attributeBean.setSimpleName("token-requestor");
            attributeBean.setQualifiedName("http://cxf.apache.org/sts");
        } else {
            attributeBean.setQualifiedName("token-requestor");
            attributeBean.setNameFormat("http://cxf.apache.org/sts");
        }
        attributeBean.addAttributeValue((Object)"authenticated");
        return attributeBean;
    }
}

