/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.tools.common;

import java.util.LinkedList;
import java.util.List;
import java.util.logging.Logger;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.tools.common.ToolException;

public class ToolErrorListener {
    private static final Logger LOG = LogUtils.getL7dLogger(ToolErrorListener.class);
    List<ErrorInfo> errors = new LinkedList<ErrorInfo>();

    public void addError(String file, int line, int column, String message) {
        this.addError(file, line, column, message, null);
    }

    public void addError(String file, int line, int column, String message, Throwable t) {
        this.errors.add(new ErrorInfo(file, line, column, message, t));
    }

    public void addWarning(String file, int line, int column, String message) {
        this.addWarning(file, line, column, message, null);
    }

    public void addWarning(String file, int line, int column, String message, Throwable t) {
        if (file != null) {
            message = file + " [" + line + "," + column + "]: " + (String)message;
        }
        LOG.warning((String)message);
    }

    public int getErrorCount() {
        return this.errors.size();
    }

    private StringBuilder createMessage(StringBuilder b, ErrorInfo e) {
        if (e.file != null) {
            b.append(e.file).append(" [").append(e.line).append(',').append(e.col).append("]: ").append(e.message);
        } else if (e.message == null && e.cause != null) {
            b.append(e.cause.getLocalizedMessage());
        } else {
            b.append(e.message);
        }
        return b;
    }

    public void throwToolException() {
        StringBuilder b = new StringBuilder();
        for (ErrorInfo e : this.errors) {
            this.createMessage(b, e).append('\n');
        }
        throw new ToolException(b.toString(), this.errors);
    }

    static class ErrorInfo {
        String file;
        int line;
        int col;
        Throwable cause;
        String message;

        ErrorInfo(String f, int l, int c, String m, Throwable t) {
            this.file = f;
            this.line = l;
            this.col = c;
            this.message = m;
            this.cause = t;
        }
    }
}

