/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.changes;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.commons.compress.AbstractTest;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.ArchiveInputStream;
import org.apache.commons.compress.archivers.ArchiveOutputStream;
import org.apache.commons.compress.archivers.ar.ArArchiveEntry;
import org.apache.commons.compress.archivers.cpio.CpioArchiveEntry;
import org.apache.commons.compress.archivers.jar.JarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipFile;
import org.apache.commons.compress.changes.Change;
import org.apache.commons.compress.changes.ChangeSet;
import org.apache.commons.compress.changes.ChangeSetPerformer;
import org.apache.commons.compress.changes.ChangeSetResults;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;

public final class ChangeSetRawTypesTest
extends AbstractTest {
    private void archiveListDelete(String prefix) {
        this.archiveList.removeIf(entry -> entry.equals(prefix));
    }

    private void archiveListDeleteDir(String prefix) {
        this.archiveList.removeIf(entry -> entry.startsWith(prefix + "/"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ParameterizedTest
    @MethodSource(value={"org.apache.commons.compress.changes.TestFixtures#getOutputArchiveNames"})
    public void testAddAlreadyExistingWithReplaceFalse(String archiverName) throws Exception {
        Path inputPath = this.createArchive(archiverName);
        Path result = Files.createTempFile("test", "." + archiverName, new FileAttribute[0]);
        try (InputStream inputStream = Files.newInputStream(inputPath, new OpenOption[0]);
             ArchiveInputStream archiveInputStream = this.factory.createArchiveInputStream(archiverName, inputStream);
             OutputStream newOutputStream = Files.newOutputStream(result, new OpenOption[0]);
             ArchiveOutputStream archiveOutputStream = this.factory.createArchiveOutputStream(archiverName, newOutputStream);
             InputStream csInputStream = Files.newInputStream(ChangeSetRawTypesTest.getPath("test.txt"), new OpenOption[0]);){
            this.setLongFileMode(archiveOutputStream);
            ChangeSet changeSet = new ChangeSet();
            ZipArchiveEntry entry = new ZipArchiveEntry("testdata/test1.xml");
            changeSet.add((ArchiveEntry)entry, csInputStream, false);
            ChangeSetResults results = new ChangeSetPerformer(changeSet).perform(archiveInputStream, archiveOutputStream);
            Assertions.assertTrue((boolean)results.getAddedFromStream().contains("testdata/test1.xml"));
            Assertions.assertTrue((boolean)results.getAddedFromChangeSet().isEmpty());
            Assertions.assertTrue((boolean)results.getDeleted().isEmpty());
        }
        finally {
            this.checkArchiveContent(result, (List<String>)this.archiveList);
            ChangeSetRawTypesTest.forceDelete(inputPath);
            ChangeSetRawTypesTest.forceDelete(result);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ParameterizedTest
    @MethodSource(value={"org.apache.commons.compress.changes.TestFixtures#getZipOutputArchiveNames"})
    public void testAddAlreadyExistingWithReplaceTrue(String archiverName) throws Exception {
        Path inputPath = this.createArchive(archiverName);
        Path result = Files.createTempFile("test", "." + archiverName, new FileAttribute[0]);
        try (InputStream inputStream = Files.newInputStream(inputPath, new OpenOption[0]);
             ArchiveInputStream archiveInputStream = this.factory.createArchiveInputStream(archiverName, inputStream);
             OutputStream newOutputStream = Files.newOutputStream(result, new OpenOption[0]);
             ArchiveOutputStream archiveOutputStream = this.factory.createArchiveOutputStream(archiverName, newOutputStream);
             InputStream csInputStream = Files.newInputStream(ChangeSetRawTypesTest.getPath("test.txt"), new OpenOption[0]);){
            this.setLongFileMode(archiveOutputStream);
            ChangeSet changeSet = new ChangeSet();
            ZipArchiveEntry entry = new ZipArchiveEntry("testdata/test1.xml");
            changeSet.add((ArchiveEntry)entry, csInputStream, true);
            ChangeSetResults results = new ChangeSetPerformer(changeSet).perform(archiveInputStream, archiveOutputStream);
            Assertions.assertTrue((boolean)results.getAddedFromChangeSet().contains("testdata/test1.xml"));
        }
        finally {
            this.checkArchiveContent(result, (List<String>)this.archiveList);
            ChangeSetRawTypesTest.forceDelete(result);
        }
    }

    @Test
    public void testAddChangeTwice() throws Exception {
        try (InputStream inputStream = ChangeSetRawTypesTest.newInputStream("test.txt");
             InputStream inputStream2 = ChangeSetRawTypesTest.newInputStream("test2.xml");){
            ZipArchiveEntry e = new ZipArchiveEntry("test.txt");
            ZipArchiveEntry e2 = new ZipArchiveEntry("test.txt");
            ChangeSet changeSet = new ChangeSet();
            changeSet.add((ArchiveEntry)e, inputStream);
            changeSet.add((ArchiveEntry)e2, inputStream2);
            Set changeSet2 = changeSet.getChanges();
            Assertions.assertEquals((int)1, (int)changeSet2.size());
            Change change = (Change)changeSet2.iterator().next();
            InputStream csInputStream = change.getInputStream();
            Assertions.assertEquals((Object)inputStream2, (Object)csInputStream);
        }
    }

    @Test
    public void testAddChangeTwiceWithoutReplace() throws Exception {
        try (InputStream inputStream = ChangeSetRawTypesTest.newInputStream("test.txt");
             InputStream inputStream2 = ChangeSetRawTypesTest.newInputStream("test2.xml");){
            ZipArchiveEntry e = new ZipArchiveEntry("test.txt");
            ZipArchiveEntry e2 = new ZipArchiveEntry("test.txt");
            ChangeSet changeSet = new ChangeSet();
            changeSet.add((ArchiveEntry)e, inputStream, true);
            changeSet.add((ArchiveEntry)e2, inputStream2, false);
            Set changes = changeSet.getChanges();
            Assertions.assertEquals((int)1, (int)changes.size());
            Change c = (Change)changes.iterator().next();
            InputStream csInputStream = c.getInputStream();
            Assertions.assertEquals((Object)inputStream, (Object)csInputStream);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAddDeleteAdd() throws Exception {
        String archiverName = "cpio";
        Path inputPath = this.createArchive("cpio");
        Path result = Files.createTempFile("test", ".cpio", new FileAttribute[0]);
        try (InputStream inputStream = Files.newInputStream(inputPath, new OpenOption[0]);
             ArchiveInputStream archiveInputStream = this.factory.createArchiveInputStream("cpio", inputStream);
             OutputStream newOutputStream = Files.newOutputStream(result, new OpenOption[0]);
             ArchiveOutputStream archiveOutputStream = this.factory.createArchiveOutputStream("cpio", newOutputStream);
             InputStream csInputStream = Files.newInputStream(ChangeSetRawTypesTest.getPath("test.txt"), new OpenOption[0]);){
            this.setLongFileMode(archiveOutputStream);
            ChangeSet changeSet = new ChangeSet();
            CpioArchiveEntry entry = new CpioArchiveEntry("blub/test.txt");
            changeSet.add((ArchiveEntry)entry, csInputStream);
            this.archiveList.add("blub/test.txt");
            changeSet.deleteDir("blub");
            this.archiveListDeleteDir("blub");
            new ChangeSetPerformer(changeSet).perform(archiveInputStream, archiveOutputStream);
        }
        finally {
            this.checkArchiveContent(result, (List<String>)this.archiveList);
            ChangeSetRawTypesTest.forceDelete(result);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ParameterizedTest
    @MethodSource(value={"org.apache.commons.compress.changes.TestFixtures#getOutputArchiveNames"})
    public void testAddDeleteToOneFileArchive(String archiverName) throws Exception {
        Path inputPath = this.createSingleEntryArchive(archiverName);
        Path result = Files.createTempFile("test", "." + archiverName, new FileAttribute[0]);
        ChangeSet changeSet = new ChangeSet();
        File file = ChangeSetRawTypesTest.getFile("test.txt");
        try (InputStream inputStream = Files.newInputStream(inputPath, new OpenOption[0]);
             ArchiveInputStream archiveInputStream = this.factory.createArchiveInputStream(archiverName, inputStream);
             OutputStream newOutputStream = Files.newOutputStream(result, new OpenOption[0]);
             ArchiveOutputStream archiveOutputStream = this.factory.createArchiveOutputStream(archiverName, newOutputStream);
             InputStream csInputStream = Files.newInputStream(file.toPath(), new OpenOption[0]);){
            this.setLongFileMode(archiveOutputStream);
            ArchiveEntry entry = archiveOutputStream.createArchiveEntry(file, "bla/test.txt");
            changeSet.add(entry, csInputStream);
            this.archiveList.add("bla/test.txt");
            changeSet.delete("test1.xml");
            this.archiveListDelete("test1.xml");
            new ChangeSetPerformer(changeSet).perform(archiveInputStream, archiveOutputStream);
        }
        finally {
            this.checkArchiveContent(result, (List<String>)this.archiveList);
            ChangeSetRawTypesTest.forceDelete(result);
        }
    }

    @Test
    public void testAddMoveDelete() throws Exception {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ParameterizedTest
    @MethodSource(value={"org.apache.commons.compress.changes.TestFixtures#getEmptyOutputArchiveNames"})
    public void testAddToEmptyArchive(String archiverName) throws Exception {
        Path inputPath = this.createEmptyArchive(archiverName);
        Path result = Files.createTempFile("test", "." + archiverName, new FileAttribute[0]);
        ChangeSet changeSet = new ChangeSet();
        try (InputStream inputStream = Files.newInputStream(inputPath, new OpenOption[0]);
             ArchiveInputStream archiveInputStream = this.factory.createArchiveInputStream(archiverName, inputStream);
             OutputStream newOutputStream = Files.newOutputStream(result, new OpenOption[0]);
             ArchiveOutputStream archiveOutputStream = this.factory.createArchiveOutputStream(archiverName, newOutputStream);
             InputStream csInputStream = Files.newInputStream(ChangeSetRawTypesTest.getPath("test.txt"), new OpenOption[0]);){
            this.setLongFileMode(archiveOutputStream);
            ZipArchiveEntry entry = new ZipArchiveEntry("bla/test.txt");
            changeSet.add((ArchiveEntry)entry, csInputStream);
            this.archiveList.add("bla/test.txt");
            new ChangeSetPerformer(changeSet).perform(archiveInputStream, archiveOutputStream);
        }
        finally {
            this.checkArchiveContent(result, (List<String>)this.archiveList);
            ChangeSetRawTypesTest.forceDelete(result);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ParameterizedTest
    @MethodSource(value={"org.apache.commons.compress.changes.TestFixtures#getOutputArchiveNames"})
    public void testChangeSetResults(String archiverName) throws Exception {
        Path inputPath = this.createArchive(archiverName);
        Path result = Files.createTempFile("test", "." + archiverName, new FileAttribute[0]);
        File file1 = ChangeSetRawTypesTest.getFile("test.txt");
        try (InputStream inputStream = Files.newInputStream(inputPath, new OpenOption[0]);
             ArchiveInputStream archiveInputStream = this.factory.createArchiveInputStream(archiverName, inputStream);
             OutputStream newOutputStream = Files.newOutputStream(result, new OpenOption[0]);
             ArchiveOutputStream archiveOutputStream = this.factory.createArchiveOutputStream(archiverName, newOutputStream);
             InputStream csInputStream = Files.newInputStream(file1.toPath(), new OpenOption[0]);){
            this.setLongFileMode(archiveOutputStream);
            ChangeSet changeSet = new ChangeSet();
            changeSet.deleteDir("bla");
            this.archiveListDeleteDir("bla");
            ArchiveEntry entry = archiveOutputStream.createArchiveEntry(file1, "bla/test.txt");
            changeSet.add(entry, csInputStream);
            this.archiveList.add("bla/test.txt");
            ChangeSetResults results = new ChangeSetPerformer(changeSet).perform(archiveInputStream, archiveOutputStream);
            inputStream.close();
            Assertions.assertEquals((int)1, (int)results.getAddedFromChangeSet().size());
            Assertions.assertEquals((Object)"bla/test.txt", results.getAddedFromChangeSet().iterator().next());
            Assertions.assertEquals((int)3, (int)results.getDeleted().size());
            Assertions.assertTrue((boolean)results.getDeleted().contains("bla/test4.xml"));
            Assertions.assertTrue((boolean)results.getDeleted().contains("bla/test5.xml"));
            Assertions.assertTrue((boolean)results.getDeleted().contains("bla/blubber/test6.xml"));
            Assertions.assertTrue((boolean)results.getAddedFromStream().contains("testdata/test1.xml"));
            Assertions.assertTrue((boolean)results.getAddedFromStream().contains("testdata/test2.xml"));
            Assertions.assertTrue((boolean)results.getAddedFromStream().contains("test/test3.xml"));
            Assertions.assertTrue((boolean)results.getAddedFromStream().contains("test.txt"));
            Assertions.assertTrue((boolean)results.getAddedFromStream().contains("something/bla"));
            Assertions.assertTrue((boolean)results.getAddedFromStream().contains("test with spaces.txt"));
            Assertions.assertEquals((int)6, (int)results.getAddedFromStream().size());
        }
        finally {
            this.checkArchiveContent(result, (List<String>)this.archiveList);
            ChangeSetRawTypesTest.forceDelete(result);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDeleteAddDelete() throws Exception {
        String archiverName = "cpio";
        Path inputPath = this.createArchive("cpio");
        Path result = Files.createTempFile("test", ".cpio", new FileAttribute[0]);
        try (InputStream inputStream = Files.newInputStream(inputPath, new OpenOption[0]);
             ArchiveInputStream archiveInputStream = this.factory.createArchiveInputStream("cpio", inputStream);
             OutputStream newOutputStream = Files.newOutputStream(result, new OpenOption[0]);
             ArchiveOutputStream archiveOutputStream = this.factory.createArchiveOutputStream("cpio", newOutputStream);
             InputStream csInputStream = Files.newInputStream(ChangeSetRawTypesTest.getPath("test.txt"), new OpenOption[0]);){
            this.setLongFileMode(archiveOutputStream);
            ChangeSet changeSet = new ChangeSet();
            changeSet.deleteDir("bla");
            CpioArchiveEntry entry = new CpioArchiveEntry("bla/test.txt");
            changeSet.add((ArchiveEntry)entry, csInputStream);
            this.archiveList.add("bla/test.txt");
            changeSet.deleteDir("bla");
            this.archiveListDeleteDir("bla");
            new ChangeSetPerformer(changeSet).perform(archiveInputStream, archiveOutputStream);
        }
        finally {
            this.checkArchiveContent(result, (List<String>)this.archiveList);
            ChangeSetRawTypesTest.forceDelete(result);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ParameterizedTest
    @MethodSource(value={"org.apache.commons.compress.changes.TestFixtures#getOutputArchiveNames"})
    public void testDeleteAddToOneFileArchive(String archiverName) throws Exception {
        Path inputPath = this.createSingleEntryArchive(archiverName);
        Path result = Files.createTempFile("test", "." + archiverName, new FileAttribute[0]);
        ChangeSet changeSet = new ChangeSet();
        File file = ChangeSetRawTypesTest.getFile("test.txt");
        try (InputStream inputStream = Files.newInputStream(inputPath, new OpenOption[0]);
             ArchiveInputStream archiveInputStream = this.factory.createArchiveInputStream(archiverName, inputStream);
             OutputStream newOutputStream = Files.newOutputStream(result, new OpenOption[0]);
             ArchiveOutputStream archiveOutputStream = this.factory.createArchiveOutputStream(archiverName, newOutputStream);
             InputStream csInputStream = Files.newInputStream(file.toPath(), new OpenOption[0]);){
            this.setLongFileMode(archiveOutputStream);
            changeSet.delete("test1.xml");
            this.archiveListDelete("test1.xml");
            ArchiveEntry entry = archiveOutputStream.createArchiveEntry(file, "bla/test.txt");
            changeSet.add(entry, csInputStream);
            this.archiveList.add("bla/test.txt");
            new ChangeSetPerformer(changeSet).perform(archiveInputStream, archiveOutputStream);
        }
        finally {
            this.checkArchiveContent(result, (List<String>)this.archiveList);
            ChangeSetRawTypesTest.forceDelete(result);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ParameterizedTest
    @MethodSource(value={"org.apache.commons.compress.changes.TestFixtures#getOutputArchiveNames"})
    public void testDeleteDir(String archiverName) throws Exception {
        Path inputPath = this.createArchive(archiverName);
        Path result = Files.createTempFile("test", "." + archiverName, new FileAttribute[0]);
        try (InputStream inputStream = Files.newInputStream(inputPath, new OpenOption[0]);
             ArchiveInputStream archiveInputStream = this.factory.createArchiveInputStream(archiverName, inputStream);
             OutputStream newOutputStream = Files.newOutputStream(result, new OpenOption[0]);
             ArchiveOutputStream archiveOutputStream = this.factory.createArchiveOutputStream(archiverName, newOutputStream);){
            this.setLongFileMode(archiveOutputStream);
            ChangeSet changeSet = new ChangeSet();
            changeSet.deleteDir("bla");
            this.archiveListDeleteDir("bla");
            new ChangeSetPerformer(changeSet).perform(archiveInputStream, archiveOutputStream);
        }
        finally {
            this.checkArchiveContent(result, (List<String>)this.archiveList);
            ChangeSetRawTypesTest.forceDelete(result);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ParameterizedTest
    @MethodSource(value={"org.apache.commons.compress.changes.TestFixtures#getOutputArchiveNames"})
    public void testDeleteDir2(String archiverName) throws Exception {
        Path inputPath = this.createArchive(archiverName);
        Path result = Files.createTempFile("test", "." + archiverName, new FileAttribute[0]);
        try (InputStream inputStream = Files.newInputStream(inputPath, new OpenOption[0]);
             ArchiveInputStream archiveInputStream = this.factory.createArchiveInputStream(archiverName, inputStream);
             OutputStream newOutputStream = Files.newOutputStream(result, new OpenOption[0]);
             ArchiveOutputStream archiveOutputStream = this.factory.createArchiveOutputStream(archiverName, newOutputStream);){
            this.setLongFileMode(archiveOutputStream);
            ChangeSet changeSet = new ChangeSet();
            changeSet.deleteDir("la");
            this.archiveListDeleteDir("la");
            new ChangeSetPerformer(changeSet).perform(archiveInputStream, archiveOutputStream);
        }
        finally {
            this.checkArchiveContent(result, (List<String>)this.archiveList);
            ChangeSetRawTypesTest.forceDelete(result);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ParameterizedTest
    @MethodSource(value={"org.apache.commons.compress.changes.TestFixtures#getOutputArchiveNames"})
    public void testDeleteDir3(String archiverName) throws Exception {
        Path inputPath = this.createArchive(archiverName);
        Path result = Files.createTempFile("test", "." + archiverName, new FileAttribute[0]);
        try (InputStream inputStream = Files.newInputStream(inputPath, new OpenOption[0]);
             ArchiveInputStream archiveInputStream = this.factory.createArchiveInputStream(archiverName, inputStream);
             OutputStream newOutputStream = Files.newOutputStream(result, new OpenOption[0]);
             ArchiveOutputStream archiveOutputStream = this.factory.createArchiveOutputStream(archiverName, newOutputStream);){
            this.setLongFileMode(archiveOutputStream);
            ChangeSet changeSet = new ChangeSet();
            changeSet.deleteDir("test.txt");
            this.archiveListDeleteDir("test.txt");
            new ChangeSetPerformer(changeSet).perform(archiveInputStream, archiveOutputStream);
        }
        finally {
            this.checkArchiveContent(result, (List<String>)this.archiveList);
            ChangeSetRawTypesTest.forceDelete(result);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ParameterizedTest
    @MethodSource(value={"org.apache.commons.compress.changes.TestFixtures#getOutputArchiveNames"})
    public void testDeleteFile(String archiverName) throws Exception {
        Path inputPath = this.createArchive(archiverName);
        Path result = Files.createTempFile("test", "." + archiverName, new FileAttribute[0]);
        try (InputStream inputStream = Files.newInputStream(inputPath, new OpenOption[0]);
             ArchiveInputStream archiveInputStream = this.factory.createArchiveInputStream(archiverName, inputStream);
             OutputStream newOutputStream = Files.newOutputStream(result, new OpenOption[0]);
             ArchiveOutputStream archiveOutputStream = this.factory.createArchiveOutputStream(archiverName, newOutputStream);){
            this.setLongFileMode(archiveOutputStream);
            ChangeSet changeSet = new ChangeSet();
            changeSet.delete("bla/test5.xml");
            this.archiveListDelete("bla/test5.xml");
            new ChangeSetPerformer(changeSet).perform(archiveInputStream, archiveOutputStream);
        }
        finally {
            this.checkArchiveContent(result, (List<String>)this.archiveList);
            ChangeSetRawTypesTest.forceDelete(result);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ParameterizedTest
    @MethodSource(value={"org.apache.commons.compress.changes.TestFixtures#getOutputArchiveNames"})
    public void testDeleteFile2(String archiverName) throws Exception {
        Path inputPath = this.createArchive(archiverName);
        Path result = Files.createTempFile("test", "." + archiverName, new FileAttribute[0]);
        try (InputStream inputStream = Files.newInputStream(inputPath, new OpenOption[0]);
             ArchiveInputStream archiveInputStream = this.factory.createArchiveInputStream(archiverName, inputStream);
             OutputStream newOutputStream = Files.newOutputStream(result, new OpenOption[0]);
             ArchiveOutputStream archiveOutputStream = this.factory.createArchiveOutputStream(archiverName, newOutputStream);){
            this.setLongFileMode(archiveOutputStream);
            ChangeSet changeSet = new ChangeSet();
            changeSet.delete("bla");
            new ChangeSetPerformer(changeSet).perform(archiveInputStream, archiveOutputStream);
        }
        finally {
            this.checkArchiveContent(result, (List<String>)this.archiveList);
            ChangeSetRawTypesTest.forceDelete(result);
        }
    }

    @Test
    public void testDeleteFromAndAddToAr() throws Exception {
        ChangeSet changeSet = new ChangeSet();
        changeSet.delete("test2.xml");
        File file1 = ChangeSetRawTypesTest.getFile("test.txt");
        ArArchiveEntry entry = new ArArchiveEntry("test.txt", file1.length());
        Path result = this.getTempDirFile().toPath().resolve("bla.ar");
        String archiverName = "ar";
        try (InputStream inputStream = Files.newInputStream(ChangeSetRawTypesTest.getPath("bla.ar"), new OpenOption[0]);
             ArchiveInputStream archiveInputStream = this.factory.createArchiveInputStream("ar", inputStream);
             OutputStream newOutputStream = Files.newOutputStream(result, new OpenOption[0]);
             ArchiveOutputStream archiveOutputStream = this.factory.createArchiveOutputStream("ar", newOutputStream);
             InputStream csInputStream = Files.newInputStream(file1.toPath(), new OpenOption[0]);){
            changeSet.add((ArchiveEntry)entry, csInputStream);
            this.setLongFileMode(archiveOutputStream);
            new ChangeSetPerformer(changeSet).perform(archiveInputStream, archiveOutputStream);
        }
        ArrayList<String> expected = new ArrayList<String>();
        expected.add("test1.xml");
        expected.add("test.txt");
        this.checkArchiveContent(result, expected);
    }

    @Test
    public void testDeleteFromAndAddToJar() throws Exception {
        ChangeSet changeSet = new ChangeSet();
        changeSet.delete("test2.xml");
        changeSet.deleteDir("META-INF");
        changeSet.delete(".classpath");
        changeSet.delete(".project");
        File input = ChangeSetRawTypesTest.getFile("bla.jar");
        Path result = this.getTempDirFile().toPath().resolve("bla.jar");
        String archiverName = "jar";
        try (InputStream inputStream = Files.newInputStream(input.toPath(), new OpenOption[0]);
             ArchiveInputStream archiveInputStream = this.factory.createArchiveInputStream("jar", inputStream);
             OutputStream newOutputStream = Files.newOutputStream(result, new OpenOption[0]);
             ArchiveOutputStream archiveOutputStream = this.factory.createArchiveOutputStream("jar", newOutputStream);
             InputStream csInputStream = Files.newInputStream(ChangeSetRawTypesTest.getPath("test.txt"), new OpenOption[0]);){
            changeSet.add((ArchiveEntry)new JarArchiveEntry("testdata/test.txt"), csInputStream);
            this.setLongFileMode(archiveOutputStream);
            new ChangeSetPerformer(changeSet).perform(archiveInputStream, archiveOutputStream);
        }
        ArrayList<String> expected = new ArrayList<String>();
        expected.add("test1.xml");
        expected.add("testdata/test.txt");
        this.checkArchiveContent(result, expected);
    }

    @Test
    public void testDeleteFromAndAddToTar() throws Exception {
        ChangeSet changeSet = new ChangeSet();
        changeSet.delete("test2.xml");
        File file1 = ChangeSetRawTypesTest.getFile("test.txt");
        TarArchiveEntry entry = new TarArchiveEntry("testdata/test.txt");
        entry.setModTime(0L);
        entry.setSize(file1.length());
        entry.setUserId(0);
        entry.setGroupId(0);
        entry.setUserName("avalon");
        entry.setGroupName("excalibur");
        entry.setMode(32768);
        File result = this.newTempFile("bla.tar");
        String archiverName = "tar";
        try (InputStream inputStream = Files.newInputStream(ChangeSetRawTypesTest.getPath("bla.tar"), new OpenOption[0]);
             ArchiveInputStream archiveInputStream = this.factory.createArchiveInputStream("tar", inputStream);
             OutputStream newOutputStream = Files.newOutputStream(result.toPath(), new OpenOption[0]);
             ArchiveOutputStream archiveOutputStream = this.factory.createArchiveOutputStream("tar", newOutputStream);
             InputStream csInputStream = Files.newInputStream(file1.toPath(), new OpenOption[0]);){
            changeSet.add((ArchiveEntry)entry, csInputStream);
            this.setLongFileMode(archiveOutputStream);
            new ChangeSetPerformer(changeSet).perform(archiveInputStream, archiveOutputStream);
        }
        ArrayList<String> expected = new ArrayList<String>();
        expected.add("test1.xml");
        expected.add("testdata/test.txt");
        try (InputStream inputStream = Files.newInputStream(result.toPath(), new OpenOption[0]);
             ArchiveInputStream archiveInputStream = this.factory.createArchiveInputStream("tar", inputStream);){
            this.checkArchiveContent(archiveInputStream, expected);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDeleteFromAndAddToZip() throws Exception {
        String archiverName = "zip";
        Path input = this.createArchive("zip");
        Path result = Files.createTempFile("test", ".zip", new FileAttribute[0]);
        try (InputStream inputStream = Files.newInputStream(input, new OpenOption[0]);
             ArchiveInputStream archiveInputStream = this.factory.createArchiveInputStream("zip", inputStream);
             OutputStream newOutputStream = Files.newOutputStream(result, new OpenOption[0]);
             ArchiveOutputStream archiveOutputStream = this.factory.createArchiveOutputStream("zip", newOutputStream);
             InputStream csInputStream = Files.newInputStream(ChangeSetRawTypesTest.getPath("test.txt"), new OpenOption[0]);){
            this.setLongFileMode(archiveOutputStream);
            ChangeSet changeSet = new ChangeSet();
            ZipArchiveEntry entry = new ZipArchiveEntry("blub/test.txt");
            changeSet.add((ArchiveEntry)entry, csInputStream);
            this.archiveList.add("blub/test.txt");
            changeSet.delete("testdata/test1.xml");
            this.archiveListDelete("testdata/test1.xml");
            new ChangeSetPerformer(changeSet).perform(archiveInputStream, archiveOutputStream);
        }
        finally {
            this.checkArchiveContent(result, (List<String>)this.archiveList);
            ChangeSetRawTypesTest.forceDelete(result);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDeleteFromAndAddToZipUsingZipFilePerform() throws Exception {
        String archiverName = "zip";
        Path input = this.createArchive("zip");
        Path result = Files.createTempFile("test", ".zip", new FileAttribute[0]);
        try (ZipFile archiveInputStream = ((ZipFile.Builder)ZipFile.builder().setPath(input)).get();
             OutputStream newOutputStream = Files.newOutputStream(result, new OpenOption[0]);
             ArchiveOutputStream archiveOutputStream = this.factory.createArchiveOutputStream("zip", newOutputStream);
             InputStream csInputStream = Files.newInputStream(ChangeSetRawTypesTest.getPath("test.txt"), new OpenOption[0]);){
            this.setLongFileMode(archiveOutputStream);
            ChangeSet changeSet = new ChangeSet();
            ZipArchiveEntry entry = new ZipArchiveEntry("blub/test.txt");
            changeSet.add((ArchiveEntry)entry, csInputStream);
            this.archiveList.add("blub/test.txt");
            changeSet.delete("testdata/test1.xml");
            this.archiveListDelete("testdata/test1.xml");
            new ChangeSetPerformer(changeSet).perform(archiveInputStream, archiveOutputStream);
        }
        finally {
            this.checkArchiveContent(result, (List<String>)this.archiveList);
            ChangeSetRawTypesTest.forceDelete(result);
        }
    }

    @Test
    public void testDeleteFromAr() throws Exception {
        ChangeSet changeSet = new ChangeSet();
        changeSet.delete("test2.xml");
        File input = ChangeSetRawTypesTest.getFile("bla.ar");
        File result = this.newTempFile("bla.ar");
        String archiverName = "ar";
        try (InputStream inputStream = Files.newInputStream(input.toPath(), new OpenOption[0]);
             ArchiveInputStream archiveInputStream = this.factory.createArchiveInputStream("ar", inputStream);
             OutputStream newOutputStream = Files.newOutputStream(result.toPath(), new OpenOption[0]);
             ArchiveOutputStream archiveOutputStream = this.factory.createArchiveOutputStream("ar", newOutputStream);){
            this.setLongFileMode(archiveOutputStream);
            new ChangeSetPerformer(changeSet).perform(archiveInputStream, archiveOutputStream);
        }
        ArrayList<String> expected = new ArrayList<String>();
        expected.add("test1.xml");
        this.checkArchiveContent(result, expected);
    }

    @ParameterizedTest
    @MethodSource(value={"org.apache.commons.compress.changes.TestFixtures#getZipOutputArchiveNames"})
    public void testDeleteFromJar(String archiverName) throws Exception {
        ChangeSet changeSet = new ChangeSet();
        changeSet.delete("test2.xml");
        changeSet.deleteDir("META-INF");
        changeSet.delete(".classpath");
        changeSet.delete(".project");
        File input = ChangeSetRawTypesTest.getFile("bla.jar");
        File result = this.newTempFile("bla.jar");
        try (InputStream inputStream = Files.newInputStream(input.toPath(), new OpenOption[0]);
             ArchiveInputStream archiveInputStream = this.factory.createArchiveInputStream(archiverName, inputStream);
             OutputStream newOutputStream = Files.newOutputStream(result.toPath(), new OpenOption[0]);
             ArchiveOutputStream archiveOutputStream = this.factory.createArchiveOutputStream(archiverName, newOutputStream);){
            this.setLongFileMode(archiveOutputStream);
            new ChangeSetPerformer(changeSet).perform(archiveInputStream, archiveOutputStream);
        }
        ArrayList<String> expected = new ArrayList<String>();
        expected.add("test1.xml");
        this.checkArchiveContent(result, expected);
    }

    @Test
    public void testDeleteFromTar() throws Exception {
        ChangeSet changeSet = new ChangeSet();
        changeSet.delete("test2.xml");
        File result = this.newTempFile("bla.tar");
        String archiverName = "tar";
        try (InputStream inputStream = Files.newInputStream(ChangeSetRawTypesTest.getFile("bla.tar").toPath(), new OpenOption[0]);
             ArchiveInputStream archiveInputStream = this.factory.createArchiveInputStream("tar", inputStream);
             OutputStream newOutputStream = Files.newOutputStream(result.toPath(), new OpenOption[0]);
             ArchiveOutputStream archiveOutputStream = this.factory.createArchiveOutputStream("tar", newOutputStream);){
            this.setLongFileMode(archiveOutputStream);
            new ChangeSetPerformer(changeSet).perform(archiveInputStream, archiveOutputStream);
        }
        ArrayList<String> expected = new ArrayList<String>();
        expected.add("test1.xml");
        this.checkArchiveContent(result, expected);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ParameterizedTest
    @MethodSource(value={"org.apache.commons.compress.changes.TestFixtures#getZipOutputArchiveNames"})
    public void testDeleteFromZip(String archiverName) throws Exception {
        ChangeSet changeSet = new ChangeSet();
        changeSet.delete("test2.xml");
        File inputFile = ChangeSetRawTypesTest.getFile("bla.zip");
        Path result = Files.createTempFile("test", ".zip", new FileAttribute[0]);
        try (InputStream inputStream = Files.newInputStream(inputFile.toPath(), new OpenOption[0]);
             ArchiveInputStream archiveInputStream = this.factory.createArchiveInputStream(archiverName, inputStream);
             OutputStream newOutputStream = Files.newOutputStream(result, new OpenOption[0]);
             ArchiveOutputStream archiveOutputStream = this.factory.createArchiveOutputStream(archiverName, newOutputStream);){
            this.setLongFileMode(archiveOutputStream);
            new ChangeSetPerformer(changeSet).perform(archiveInputStream, archiveOutputStream);
        }
        finally {
            ArrayList<String> expected = new ArrayList<String>();
            expected.add("test1.xml");
            this.checkArchiveContent(result, expected);
            ChangeSetRawTypesTest.forceDelete(result);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ParameterizedTest
    @MethodSource(value={"org.apache.commons.compress.changes.TestFixtures#getOutputArchiveNames"})
    public void testDeletePlusAdd(String archiverName) throws Exception {
        Path inputPath = this.createArchive(archiverName);
        Path result = Files.createTempFile("test", "." + archiverName, new FileAttribute[0]);
        File file1 = ChangeSetRawTypesTest.getFile("test.txt");
        try (InputStream inputStream = Files.newInputStream(inputPath, new OpenOption[0]);
             ArchiveInputStream archiveInputStream = this.factory.createArchiveInputStream(archiverName, inputStream);
             OutputStream newOutputStream = Files.newOutputStream(result, new OpenOption[0]);
             ArchiveOutputStream archiveOutputStream = this.factory.createArchiveOutputStream(archiverName, newOutputStream);
             InputStream csInputStream = Files.newInputStream(file1.toPath(), new OpenOption[0]);){
            this.setLongFileMode(archiveOutputStream);
            ChangeSet changeSet = new ChangeSet();
            changeSet.deleteDir("bla");
            this.archiveListDeleteDir("bla");
            ArchiveEntry entry = archiveOutputStream.createArchiveEntry(file1, "bla/test.txt");
            changeSet.add(entry, csInputStream);
            this.archiveList.add("bla/test.txt");
            new ChangeSetPerformer(changeSet).perform(archiveInputStream, archiveOutputStream);
        }
        finally {
            this.checkArchiveContent(result, (List<String>)this.archiveList);
            ChangeSetRawTypesTest.forceDelete(result);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ParameterizedTest
    @MethodSource(value={"org.apache.commons.compress.changes.TestFixtures#getOutputArchiveNames"})
    public void testDeletePlusAddSame(String archiverName) throws Exception {
        Path inputPath = this.createArchive(archiverName);
        File testTxt = ChangeSetRawTypesTest.getFile("test.txt");
        Path result = Files.createTempFile("test", "." + archiverName, new FileAttribute[0]);
        try {
            try (InputStream inputStream = Files.newInputStream(inputPath, new OpenOption[0]);
                 ArchiveInputStream archiveInputStream = this.factory.createArchiveInputStream(archiverName, inputStream);
                 OutputStream newOutputStream = Files.newOutputStream(result, new OpenOption[0]);
                 ArchiveOutputStream archiveOutputStream = this.factory.createArchiveOutputStream(archiverName, newOutputStream);
                 InputStream csInputStream = Files.newInputStream(testTxt.toPath(), new OpenOption[0]);){
                this.setLongFileMode(archiveOutputStream);
                ChangeSet changes = new ChangeSet();
                changes.delete("test/test3.xml");
                this.archiveListDelete("test/test3.xml");
                ArchiveEntry entry = archiveOutputStream.createArchiveEntry(testTxt, "test/test3.xml");
                changes.add(entry, csInputStream);
                this.archiveList.add("test/test3.xml");
                new ChangeSetPerformer(changes).perform(archiveInputStream, archiveOutputStream);
            }
            try (BufferedInputStream buf = new BufferedInputStream(Files.newInputStream(result, new OpenOption[0]));
                 ArchiveInputStream in = this.factory.createArchiveInputStream((InputStream)buf);){
                File check = this.checkArchiveContent(in, this.archiveList, false);
                File test3xml = new File(check, "result/test/test3.xml");
                Assertions.assertEquals((long)testTxt.length(), (long)test3xml.length());
                try (BufferedReader reader = new BufferedReader(Files.newBufferedReader(test3xml.toPath()));){
                    String str;
                    while ((str = reader.readLine()) != null) {
                        "111111111111111111111111111000101011".equals(str);
                    }
                }
                ChangeSetRawTypesTest.forceDelete(check);
            }
        }
        finally {
            ChangeSetRawTypesTest.forceDelete(result);
        }
    }

    @Test
    public void testRenameAndDelete() {
    }
}

