/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.archivers.zip;

import java.math.BigInteger;
import org.apache.commons.compress.archivers.zip.ZipEightByteInteger;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ZipEightByteIntegerTest {
    @Test
    public void testBIFromBytes() {
        byte[] val = new byte[]{-2, -1, -1, -1, -1, -1, -1, -1};
        ZipEightByteInteger zl = new ZipEightByteInteger(val);
        Assertions.assertEquals((Object)BigInteger.valueOf(Long.MAX_VALUE).shiftLeft(1), (Object)zl.getValue(), (String)"value from bytes");
    }

    @Test
    public void testBIToBytes() {
        ZipEightByteInteger zl = new ZipEightByteInteger(BigInteger.valueOf(Long.MAX_VALUE).shiftLeft(1));
        byte[] result = zl.getBytes();
        Assertions.assertEquals((int)8, (int)result.length, (String)"length getBytes");
        Assertions.assertEquals((byte)-2, (byte)result[0], (String)"first byte getBytes");
        Assertions.assertEquals((byte)-1, (byte)result[1], (String)"second byte getBytes");
        Assertions.assertEquals((byte)-1, (byte)result[2], (String)"third byte getBytes");
        Assertions.assertEquals((byte)-1, (byte)result[3], (String)"fourth byte getBytes");
        Assertions.assertEquals((byte)-1, (byte)result[4], (String)"fifth byte getBytes");
        Assertions.assertEquals((byte)-1, (byte)result[5], (String)"sixth byte getBytes");
        Assertions.assertEquals((byte)-1, (byte)result[6], (String)"seventh byte getBytes");
        Assertions.assertEquals((byte)-1, (byte)result[7], (String)"eighth byte getBytes");
    }

    @Test
    public void testEquals() {
        ZipEightByteInteger zl = new ZipEightByteInteger(305419896L);
        ZipEightByteInteger zl2 = new ZipEightByteInteger(305419896L);
        ZipEightByteInteger zl3 = new ZipEightByteInteger(-2023406815L);
        Assertions.assertEquals((Object)zl, (Object)zl, (String)"reflexive");
        Assertions.assertEquals((Object)zl, (Object)zl2, (String)"works");
        Assertions.assertNotEquals((Object)zl, (Object)zl3, (String)"works, part two");
        Assertions.assertEquals((Object)zl2, (Object)zl, (String)"symmetric");
        Assertions.assertNotEquals(null, (Object)zl, (String)"null handling");
        Assertions.assertNotEquals((Object)zl, (Object)4660, (String)"non ZipEightByteInteger handling");
    }

    @Test
    public void testLongFromBytes() {
        byte[] val = new byte[]{120, 86, 52, 18, -85, 0, 0, 0};
        ZipEightByteInteger zl = new ZipEightByteInteger(val);
        Assertions.assertEquals((long)734744827512L, (long)zl.getLongValue(), (String)"longValue from bytes");
    }

    @Test
    public void testLongToBytes() {
        ZipEightByteInteger zl = new ZipEightByteInteger(734744827512L);
        byte[] result = zl.getBytes();
        Assertions.assertEquals((int)8, (int)result.length, (String)"length getBytes");
        Assertions.assertEquals((int)120, (int)result[0], (String)"first byte getBytes");
        Assertions.assertEquals((int)86, (int)result[1], (String)"second byte getBytes");
        Assertions.assertEquals((int)52, (int)result[2], (String)"third byte getBytes");
        Assertions.assertEquals((int)18, (int)result[3], (String)"fourth byte getBytes");
        Assertions.assertEquals((byte)-85, (byte)result[4], (String)"fifth byte getBytes");
        Assertions.assertEquals((int)0, (int)result[5], (String)"sixth byte getBytes");
        Assertions.assertEquals((int)0, (int)result[6], (String)"seventh byte getBytes");
        Assertions.assertEquals((int)0, (int)result[7], (String)"eighth byte getBytes");
    }

    @Test
    public void testSign() {
        ZipEightByteInteger zl = new ZipEightByteInteger(new byte[]{-1, -1, -1, -1, -1, -1, -1, -1});
        Assertions.assertEquals((Object)BigInteger.valueOf(Long.MAX_VALUE).shiftLeft(1).setBit(0), (Object)zl.getValue());
    }
}

