/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.sidecar.adapters.base.db;

import com.datastax.driver.core.BoundStatement;
import com.datastax.driver.core.ResultSet;
import com.datastax.driver.core.Statement;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.apache.cassandra.sidecar.adapters.base.db.ConnectedClientStats;
import org.apache.cassandra.sidecar.adapters.base.db.ConnectedClientStatsSummary;
import org.apache.cassandra.sidecar.adapters.base.db.schema.ConnectedClientsSchema;
import org.apache.cassandra.sidecar.common.server.CQLSessionProvider;
import org.apache.cassandra.sidecar.db.DatabaseAccessor;
import org.apache.cassandra.sidecar.db.schema.TableSchema;

public class ConnectedClientStatsDatabaseAccessor
extends DatabaseAccessor<ConnectedClientsSchema> {
    public ConnectedClientStatsDatabaseAccessor(CQLSessionProvider sessionProvider, ConnectedClientsSchema tableSchema) {
        super((TableSchema)tableSchema, sessionProvider);
    }

    public ConnectedClientStatsSummary summary() {
        ((ConnectedClientsSchema)this.tableSchema).prepareStatements(this.session());
        BoundStatement statement = ((ConnectedClientsSchema)this.tableSchema).connectionsByUser().bind();
        ResultSet resultSet = this.execute((Statement)statement);
        return ConnectedClientStatsSummary.from(resultSet);
    }

    public Stream<ConnectedClientStats> stats() {
        ((ConnectedClientsSchema)this.tableSchema).prepareStatements(this.session());
        BoundStatement statement = ((ConnectedClientsSchema)this.tableSchema).stats().bind();
        ResultSet resultSet = this.execute((Statement)statement);
        return StreamSupport.stream(resultSet.spliterator(), false).map(ConnectedClientStats::from);
    }
}

