/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.sidecar.adapters.base;

import java.io.IOException;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ExecutionException;
import org.apache.cassandra.sidecar.adapters.base.RingProvider;
import org.apache.cassandra.sidecar.adapters.base.TokenRangeReplicaProvider;
import org.apache.cassandra.sidecar.adapters.base.jmx.StorageJmxOperations;
import org.apache.cassandra.sidecar.common.response.RingResponse;
import org.apache.cassandra.sidecar.common.response.TokenRangeReplicasResponse;
import org.apache.cassandra.sidecar.common.server.JmxClient;
import org.apache.cassandra.sidecar.common.server.StorageOperations;
import org.apache.cassandra.sidecar.common.server.cluster.locator.Partitioners;
import org.apache.cassandra.sidecar.common.server.data.Name;
import org.apache.cassandra.sidecar.common.server.dns.DnsResolver;
import org.apache.cassandra.sidecar.common.server.exceptions.NodeBootstrappingException;
import org.apache.cassandra.sidecar.common.server.exceptions.SnapshotAlreadyExistsException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CassandraStorageOperations
implements StorageOperations {
    private static final Logger LOGGER = LoggerFactory.getLogger(CassandraStorageOperations.class);
    protected final JmxClient jmxClient;
    protected final RingProvider ringProvider;
    protected final TokenRangeReplicaProvider tokenRangeReplicaProvider;
    private volatile List<String> dataFileLocations;

    public CassandraStorageOperations(JmxClient jmxClient, DnsResolver dnsResolver) {
        this(jmxClient, new RingProvider(jmxClient, dnsResolver), new TokenRangeReplicaProvider(jmxClient, dnsResolver));
    }

    public CassandraStorageOperations(JmxClient jmxClient, RingProvider ringProvider, TokenRangeReplicaProvider tokenRangeReplicaProvider) {
        this.jmxClient = jmxClient;
        this.ringProvider = ringProvider;
        this.tokenRangeReplicaProvider = tokenRangeReplicaProvider;
    }

    public void takeSnapshot(@NotNull String tag, @NotNull String keyspace, @NotNull String table, @Nullable Map<String, String> options) {
        if (options != null && options.containsKey("ttl")) {
            LOGGER.warn("The ttl option is not supported in Cassandra 4.0");
        }
        this.takeSnapshotInternal(tag, keyspace, table, options);
    }

    protected void takeSnapshotInternal(@NotNull String tag, @NotNull String keyspace, @NotNull String table, @Nullable Map<String, String> options) {
        Objects.requireNonNull(tag, "snapshot tag must be non-null");
        Objects.requireNonNull(keyspace, "keyspace for the  must be non-null");
        Objects.requireNonNull(table, "table must be non-null");
        try {
            ((StorageJmxOperations)this.jmxClient.proxy(StorageJmxOperations.class, "org.apache.cassandra.db:type=StorageService")).takeSnapshot(tag, options, keyspace + "." + table);
        }
        catch (IOException e) {
            String errorMessage = e.getMessage();
            if (errorMessage != null) {
                if (errorMessage.contains("Snapshot " + tag + " already exists")) {
                    throw new SnapshotAlreadyExistsException((Exception)e);
                }
                if (errorMessage.contains("Keyspace " + keyspace + " does not exist")) {
                    throw new IllegalArgumentException(e);
                }
                if (errorMessage.contains("Cannot snapshot until bootstrap completes")) {
                    throw new NodeBootstrappingException((Exception)e);
                }
            }
            throw new RuntimeException(e);
        }
    }

    public void clearSnapshot(@NotNull String tag, @NotNull String keyspace, @NotNull String table) {
        Objects.requireNonNull(tag, "snapshot tag must be non-null");
        Objects.requireNonNull(keyspace, "keyspace must be non-null");
        Objects.requireNonNull(table, "table must be non-null");
        LOGGER.debug("Table is not supported by Cassandra JMX endpoints. Clearing snapshot with tag={} and keyspace={}; table={} is ignored", new Object[]{tag, keyspace, table});
        String[] keyspaces = new String[]{keyspace};
        ((StorageJmxOperations)this.jmxClient.proxy(StorageJmxOperations.class, "org.apache.cassandra.db:type=StorageService")).clearSnapshot(tag, keyspaces);
    }

    public RingResponse ring(@Nullable Name keyspace) throws UnknownHostException {
        return this.ringProvider.ring(keyspace);
    }

    public TokenRangeReplicasResponse tokenRangeReplicas(@NotNull Name keyspace, @NotNull String partitioner) {
        return this.tokenRangeReplicaProvider.tokenRangeReplicas(keyspace, Partitioners.from((String)partitioner));
    }

    public List<String> dataFileLocations() {
        if (this.dataFileLocations == null) {
            String[] allDataFileLocations = ((StorageJmxOperations)this.jmxClient.proxy(StorageJmxOperations.class, "org.apache.cassandra.db:type=StorageService")).getAllDataFileLocations();
            this.dataFileLocations = Collections.unmodifiableList(Arrays.asList(allDataFileLocations));
        }
        return this.dataFileLocations;
    }

    public void outOfRangeDataCleanup(@NotNull String keyspace, @NotNull String table, int concurrency) throws IOException, ExecutionException, InterruptedException {
        Objects.requireNonNull(keyspace, "keyspace must be non-null");
        Objects.requireNonNull(table, "table must be non-null");
        ((StorageJmxOperations)this.jmxClient.proxy(StorageJmxOperations.class, "org.apache.cassandra.db:type=StorageService")).forceKeyspaceCleanup(concurrency, keyspace, table);
    }

    public String operationMode() {
        return ((StorageJmxOperations)this.jmxClient.proxy(StorageJmxOperations.class, "org.apache.cassandra.db:type=StorageService")).getOperationMode();
    }

    public void decommission(boolean force) {
        ((StorageJmxOperations)this.jmxClient.proxy(StorageJmxOperations.class, "org.apache.cassandra.db:type=StorageService")).decommission(force);
    }

    public boolean isGossipRunning() {
        return ((StorageJmxOperations)this.jmxClient.proxy(StorageJmxOperations.class, "org.apache.cassandra.db:type=StorageService")).isGossipRunning();
    }

    public String clusterName() {
        return ((StorageJmxOperations)this.jmxClient.proxy(StorageJmxOperations.class, "org.apache.cassandra.db:type=StorageService")).getClusterName();
    }
}

