/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.sidecar.adapters.base;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.management.openmbean.CompositeData;
import org.apache.cassandra.sidecar.adapters.base.data.SessionInfo;
import org.apache.cassandra.sidecar.adapters.base.data.StreamState;
import org.apache.cassandra.sidecar.adapters.base.db.ConnectedClientStats;
import org.apache.cassandra.sidecar.adapters.base.db.ConnectedClientStatsDatabaseAccessor;
import org.apache.cassandra.sidecar.adapters.base.db.ConnectedClientStatsSummary;
import org.apache.cassandra.sidecar.adapters.base.db.schema.ConnectedClientsSchema;
import org.apache.cassandra.sidecar.adapters.base.jmx.MetricsJmxOperations;
import org.apache.cassandra.sidecar.adapters.base.jmx.StreamManagerJmxOperations;
import org.apache.cassandra.sidecar.common.response.ConnectedClientStatsResponse;
import org.apache.cassandra.sidecar.common.response.TableStatsResponse;
import org.apache.cassandra.sidecar.common.response.data.ClientConnectionEntry;
import org.apache.cassandra.sidecar.common.response.data.StreamsProgressStats;
import org.apache.cassandra.sidecar.common.server.CQLSessionProvider;
import org.apache.cassandra.sidecar.common.server.JmxClient;
import org.apache.cassandra.sidecar.common.server.MetricsOperations;
import org.apache.cassandra.sidecar.common.server.data.QualifiedTableName;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CassandraMetricsOperations
implements MetricsOperations {
    private static final Logger LOGGER = LoggerFactory.getLogger(CassandraMetricsOperations.class);
    private final ConnectedClientStatsDatabaseAccessor dbAccessor;
    protected final JmxClient jmxClient;

    public CassandraMetricsOperations(JmxClient jmxClient, CQLSessionProvider session) {
        this.jmxClient = jmxClient;
        this.dbAccessor = new ConnectedClientStatsDatabaseAccessor(session, new ConnectedClientsSchema());
    }

    public TableStatsResponse tableStats(QualifiedTableName tableName) {
        long sstableCount = this.queryMetric(tableName, TableStatsMetrics.SSTABLE_COUNT);
        long diskSpaceUsed = this.queryMetric(tableName, TableStatsMetrics.DISKSPACE_USED);
        long totalDiskSpaceUsed = this.queryMetric(tableName, TableStatsMetrics.TOTAL_DISKSPACE_USED);
        long snapshotsSize = this.queryMetric(tableName, TableStatsMetrics.SNAPSHOTS_SIZE);
        return new TableStatsResponse(tableName.keyspace(), tableName.tableName(), sstableCount, diskSpaceUsed, totalDiskSpaceUsed, snapshotsSize);
    }

    private long queryMetric(QualifiedTableName tableName, TableStatsMetrics metric) {
        String metricObjectType = String.format("org.apache.cassandra.metrics:type=Table,keyspace=%s,scope=%s,name=%s", tableName.keyspace(), tableName.tableName(), metric.metricName());
        MetricsJmxOperations queryResult = (MetricsJmxOperations)this.jmxClient.proxy(MetricsJmxOperations.class, metricObjectType);
        return this.extractValue(metric, queryResult);
    }

    private long extractValue(TableStatsMetrics metric, MetricsJmxOperations queryResult) {
        switch (metric.type) {
            case GAUGE: {
                return this.getValueAsLong(queryResult.getValue());
            }
            case COUNTER: {
                return queryResult.getCount();
            }
        }
        throw new IllegalArgumentException("Unknown MetricType: " + metric.type);
    }

    private long getValueAsLong(Object value) {
        if (value instanceof Integer) {
            return ((Integer)value).longValue();
        }
        if (value instanceof Long) {
            return (Long)value;
        }
        throw new IllegalArgumentException("Unsupported value type: " + value.getClass());
    }

    public ConnectedClientStatsResponse connectedClientStats(boolean summaryOnly) {
        if (summaryOnly) {
            return this.connectedClientSummary();
        }
        return this.connectedClientDetails();
    }

    public ConnectedClientStatsResponse connectedClientDetails() {
        List<ClientConnectionEntry> entries = this.statsToEntries(this.dbAccessor.stats());
        Map<String, Long> connectionsByUser = entries.stream().collect(Collectors.groupingBy(ClientConnectionEntry::username, Collectors.counting()));
        long totalConnectedClients = entries.size();
        return new ConnectedClientStatsResponse(entries, totalConnectedClients, connectionsByUser);
    }

    public StreamsProgressStats streamsProgressStats() {
        Set<CompositeData> streamData = ((StreamManagerJmxOperations)this.jmxClient.proxy(StreamManagerJmxOperations.class, "org.apache.cassandra.net:type=StreamManager")).getCurrentStreams();
        return this.computeStats(streamData.stream().map(StreamState::new));
    }

    private StreamsProgressStats computeStats(Stream<StreamState> streamStates) {
        Iterator sessions = streamStates.map(StreamState::sessions).flatMap(Collection::stream).iterator();
        long totalFilesToReceive = 0L;
        long totalFilesReceived = 0L;
        long totalBytesToReceive = 0L;
        long totalBytesReceived = 0L;
        long totalFilesToSend = 0L;
        long totalFilesSent = 0L;
        long totalBytesToSend = 0L;
        long totalBytesSent = 0L;
        while (sessions.hasNext()) {
            SessionInfo sessionInfo = (SessionInfo)sessions.next();
            totalBytesToReceive += sessionInfo.totalSizeToReceive();
            totalBytesReceived += sessionInfo.totalSizeReceived();
            totalFilesToReceive += sessionInfo.totalFilesToReceive();
            totalFilesReceived += sessionInfo.totalFilesReceived();
            totalBytesToSend += sessionInfo.totalSizeToSend();
            totalBytesSent += sessionInfo.totalSizeSent();
            totalFilesToSend += sessionInfo.totalFilesToSend();
            totalFilesSent += sessionInfo.totalFilesSent();
        }
        LOGGER.debug("Progress Stats: totalBytesToReceive:{} totalBytesReceived:{} totalBytesToSend:{} totalBytesSent:{}", new Object[]{totalBytesToReceive, totalBytesReceived, totalBytesToSend, totalBytesSent});
        return new StreamsProgressStats(totalFilesToReceive, totalFilesReceived, totalBytesToReceive, totalBytesReceived, totalFilesToSend, totalFilesSent, totalBytesToSend, totalBytesSent);
    }

    private ConnectedClientStatsResponse connectedClientSummary() {
        ConnectedClientStatsSummary summary = this.dbAccessor.summary();
        return new ConnectedClientStatsResponse(null, (long)summary.totalConnectedClients, summary.connectionsByUser);
    }

    private List<ClientConnectionEntry> statsToEntries(Stream<ConnectedClientStats> stats) {
        return stats.map(CassandraMetricsOperations::statToEntry).collect(Collectors.toList());
    }

    @NotNull
    private static ClientConnectionEntry statToEntry(ConnectedClientStats stat) {
        return new ClientConnectionEntry(stat.address, stat.port, stat.sslEnabled, stat.sslCipherSuite, stat.sslProtocol, stat.protocolVersion, stat.username, stat.requestCount, stat.driverName, stat.driverVersion, stat.keyspaceName, stat.clientOptions, stat.authenticationMode, stat.authenticationMetadata);
    }

    public static enum TableStatsMetrics {
        SSTABLE_COUNT("LiveSSTableCount", MetricType.GAUGE),
        DISKSPACE_USED("LiveDiskSpaceUsed", MetricType.COUNTER),
        TOTAL_DISKSPACE_USED("TotalDiskSpaceUsed", MetricType.COUNTER),
        SNAPSHOTS_SIZE("SnapshotsSize", MetricType.GAUGE);

        private final String metricName;
        private final MetricType type;

        private TableStatsMetrics(String metricName, MetricType type) {
            this.metricName = metricName;
            this.type = type;
        }

        String metricName() {
            return this.metricName;
        }
    }

    public static enum MetricType {
        GAUGE,
        COUNTER;

    }
}

