/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.sidecar.tasks;

import io.vertx.core.Promise;
import io.vertx.core.Vertx;
import org.apache.cassandra.sidecar.common.server.utils.DurationSpec;
import org.apache.cassandra.sidecar.config.SslConfiguration;
import org.apache.cassandra.sidecar.server.Server;
import org.apache.cassandra.sidecar.tasks.PeriodicTask;
import org.apache.cassandra.sidecar.tasks.ScheduleDecision;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KeyStoreCheckPeriodicTask
implements PeriodicTask {
    private static final Logger LOGGER = LoggerFactory.getLogger(KeyStoreCheckPeriodicTask.class);
    private final Vertx vertx;
    private final Server server;
    private final SslConfiguration configuration;
    private long lastModifiedTime = 0L;

    public KeyStoreCheckPeriodicTask(Vertx vertx, Server server, SslConfiguration configuration) {
        this.vertx = vertx;
        this.server = server;
        this.configuration = configuration;
        this.maybeRecordLastModifiedTime();
    }

    @Override
    public ScheduleDecision scheduleDecision() {
        return this.shouldSkip() ? ScheduleDecision.SKIP : ScheduleDecision.EXECUTE;
    }

    @Override
    public DurationSpec delay() {
        return this.configuration.keystore().checkInterval();
    }

    @Override
    public void execute(Promise<Void> promise) {
        LOGGER.info("Running periodic key store checker");
        String keyStorePath = this.configuration.keystore().path();
        this.vertx.fileSystem().props(keyStorePath).onSuccess(props -> {
            long previousLastModifiedTime = this.lastModifiedTime;
            if (props.lastModifiedTime() != previousLastModifiedTime) {
                LOGGER.info("Certificate file change detected for path={}, previousLastModifiedTime={}, lastModifiedTime={}", new Object[]{keyStorePath, previousLastModifiedTime, props.lastModifiedTime()});
                this.server.updateSSLOptions(props.lastModifiedTime()).onSuccess(v -> {
                    this.lastModifiedTime = props.lastModifiedTime();
                    LOGGER.info("Completed reloading certificates from path={}", (Object)keyStorePath);
                    promise.complete();
                }).onFailure(cause -> {
                    LOGGER.error("Failed to reload certificate from path={}", (Object)keyStorePath, cause);
                    promise.fail(cause);
                });
            } else {
                promise.complete();
            }
        }).onFailure(error -> {
            LOGGER.warn("Unable to retrieve props for path={}", (Object)keyStorePath, error);
            promise.fail(error);
        });
    }

    protected void maybeRecordLastModifiedTime() {
        if (this.shouldSkip()) {
            return;
        }
        String keyStorePath = this.configuration.keystore().path();
        this.vertx.fileSystem().props(keyStorePath).onSuccess(props -> {
            this.lastModifiedTime = props.lastModifiedTime();
        }).onFailure(err -> {
            LOGGER.error("Unable to get lastModifiedTime for path={}", (Object)keyStorePath);
            this.lastModifiedTime = -1L;
        });
    }

    private boolean shouldSkip() {
        return !this.configuration.isKeystoreConfigured() || !this.configuration.keystore().reloadStore();
    }
}

