/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.sidecar.snapshots;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import io.vertx.core.Future;
import io.vertx.core.Vertx;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.AbstractMap;
import java.util.List;
import java.util.Objects;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.apache.cassandra.sidecar.cluster.InstancesMetadata;
import org.apache.cassandra.sidecar.common.utils.Preconditions;
import org.apache.cassandra.sidecar.concurrent.ExecutorPools;
import org.apache.cassandra.sidecar.routes.data.StreamSSTableComponentRequestParam;
import org.apache.cassandra.sidecar.utils.BaseFileSystem;
import org.apache.cassandra.sidecar.utils.CassandraInputValidator;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.VisibleForTesting;

@Singleton
public class SnapshotPathBuilder
extends BaseFileSystem {
    public static final String SNAPSHOTS_DIR_NAME = "snapshots";

    @Inject
    public SnapshotPathBuilder(Vertx vertx, InstancesMetadata instancesMetadata, CassandraInputValidator validator, ExecutorPools executorPools) {
        super(vertx.fileSystem(), instancesMetadata, validator, executorPools);
    }

    public Future<Stream<SnapshotFile>> streamSnapshotFiles(List<String> tableDataDirectoryList, String snapshotName, boolean includeSecondaryIndexFiles) {
        return this.executorPools.internal().executeBlocking(() -> IntStream.range(0, tableDataDirectoryList.size()).mapToObj(dataDirIndex -> {
            String dataDir = (String)tableDataDirectoryList.get(dataDirIndex);
            Path snapshotDir = Paths.get(dataDir, new String[0]).resolve(SNAPSHOTS_DIR_NAME).resolve(snapshotName);
            return SnapshotPathBuilder.pair(dataDirIndex, snapshotDir);
        }).filter(entry -> Files.exists((Path)entry.getValue(), new LinkOption[0]) && Files.isDirectory((Path)entry.getValue(), new LinkOption[0])).flatMap(entry -> this.listSnapshotDir((Integer)entry.getKey(), (Path)entry.getValue(), includeSecondaryIndexFiles)));
    }

    protected Stream<SnapshotFile> listSnapshotDir(int dataDirectoryIndex, Path snapshotDir, boolean includeSecondaryIndexFiles) {
        String tableId = this.tableId(snapshotDir);
        int snapshotDirNameCount = snapshotDir.getNameCount();
        try {
            return Files.walk(snapshotDir, includeSecondaryIndexFiles ? 2 : 1, new FileVisitOption[0]).map(snapshotFile -> {
                try {
                    BasicFileAttributes attrs = Files.readAttributes(snapshotFile, BasicFileAttributes.class, new LinkOption[0]);
                    if (!attrs.isRegularFile()) {
                        return null;
                    }
                    String snapshotFileName = snapshotFile.subpath(snapshotDirNameCount, snapshotFile.getNameCount()).toString();
                    return new SnapshotFile(snapshotFileName, attrs.size(), dataDirectoryIndex, tableId);
                }
                catch (IOException e) {
                    throw new RuntimeException("Unable to read file attributes for " + snapshotFile, e);
                }
            }).filter(Objects::nonNull);
        }
        catch (IOException ioException) {
            throw new RuntimeException("Unable to list directory " + snapshotDir, ioException);
        }
    }

    protected void validate(StreamSSTableComponentRequestParam request) {
        this.validator.validateKeyspaceName(request.keyspace());
        this.validator.validateTableName(request.tableName());
        if (request.tableId() != null) {
            this.validator.validateTableId(request.tableId());
        }
        this.validator.validateSnapshotName(request.snapshotName());
        String secondaryIndexName = request.secondaryIndexName();
        if (secondaryIndexName != null) {
            Preconditions.checkArgument((!secondaryIndexName.isEmpty() ? 1 : 0) != 0, (String)"secondaryIndexName cannot be empty");
            Preconditions.checkArgument((secondaryIndexName.charAt(0) == '.' ? 1 : 0) != 0, (String)"Invalid secondary index name");
            String indexName = secondaryIndexName.substring(1);
            this.validator.validatePattern(indexName, indexName, "secondary index", false);
        }
        this.validator.validateRestrictedComponentName(request.componentName());
    }

    public String resolveComponentPathFromDataDirectory(String dataDirectory, StreamSSTableComponentRequestParam request) {
        this.validate(request);
        StringBuilder sb = new StringBuilder(StringUtils.removeEnd((String)dataDirectory, (String)File.separator)).append(File.separator).append(request.keyspace()).append(File.separator).append(request.tableName());
        if (request.tableId() != null) {
            sb.append("-").append(request.tableId());
        }
        return this.appendSnapshot(sb, request);
    }

    public String resolveComponentPathFromTableDirectory(String tableDirectory, StreamSSTableComponentRequestParam request) {
        this.validate(request);
        StringBuilder sb = new StringBuilder(StringUtils.removeEnd((String)tableDirectory, (String)File.separator));
        return this.appendSnapshot(sb, request);
    }

    public String maybeRemoveTableId(String tableName) {
        int dashIndex = tableName.lastIndexOf("-");
        if (dashIndex > 0) {
            return tableName.substring(0, dashIndex);
        }
        return tableName;
    }

    protected String tableId(@NotNull Path snapshotDir) {
        Path fileName = snapshotDir.getName(snapshotDir.getNameCount() - 3).getFileName();
        if (fileName == null) {
            return null;
        }
        String tableDirectory = fileName.toString();
        int index = tableDirectory.indexOf("-");
        if (index > 0 && index + 1 < tableDirectory.length()) {
            return tableDirectory.substring(index + 1);
        }
        return null;
    }

    protected String appendSnapshot(StringBuilder sb, StreamSSTableComponentRequestParam request) {
        sb.append(File.separator).append(SNAPSHOTS_DIR_NAME).append(File.separator).append(request.snapshotName());
        if (request.secondaryIndexName() != null) {
            sb.append(File.separator).append(request.secondaryIndexName());
        }
        return sb.append(File.separator).append(request.componentName()).toString();
    }

    private static <K, V> AbstractMap.SimpleEntry<K, V> pair(K key, V value) {
        return new AbstractMap.SimpleEntry<K, V>(key, value);
    }

    public static class SnapshotFile {
        public final String name;
        public final long size;
        public final int dataDirectoryIndex;
        public final String tableId;
        private final int hashCode;

        @VisibleForTesting
        SnapshotFile(Path path, long size, int dataDirectoryIndex, String tableId) {
            this(Objects.requireNonNull(path.getFileName(), "path.getFileName() cannot be null").toString(), size, dataDirectoryIndex, tableId);
        }

        public SnapshotFile(String name, long size, int dataDirectoryIndex, String tableId) {
            this.name = name;
            this.size = size;
            this.dataDirectoryIndex = dataDirectoryIndex;
            this.tableId = tableId;
            this.hashCode = Objects.hash(name, size, dataDirectoryIndex, tableId);
        }

        public String toString() {
            return "SnapshotFile{name='" + this.name + "', size=" + this.size + ", dataDirectoryIndex=" + this.dataDirectoryIndex + ", tableId='" + this.tableId + "'}";
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null || this.getClass() != object.getClass()) {
                return false;
            }
            SnapshotFile that = (SnapshotFile)object;
            return this.size == that.size && this.dataDirectoryIndex == that.dataDirectoryIndex && Objects.equals(this.name, that.name) && Objects.equals(this.tableId, that.tableId);
        }

        public int hashCode() {
            return this.hashCode;
        }
    }
}

