/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.sidecar.routes.sstableuploads;

import com.github.benmanes.caffeine.cache.Cache;
import com.google.inject.Inject;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.vertx.core.Future;
import io.vertx.core.http.HttpServerRequest;
import io.vertx.core.net.SocketAddress;
import io.vertx.ext.auth.authorization.Authorization;
import io.vertx.ext.web.RoutingContext;
import io.vertx.ext.web.handler.HttpException;
import java.nio.file.NoSuchFileException;
import java.util.Set;
import org.apache.cassandra.sidecar.acl.authorization.BasicPermissions;
import org.apache.cassandra.sidecar.acl.authorization.CassandraPermissions;
import org.apache.cassandra.sidecar.acl.authorization.ResourceScopes;
import org.apache.cassandra.sidecar.common.response.SSTableImportResponse;
import org.apache.cassandra.sidecar.concurrent.ExecutorPools;
import org.apache.cassandra.sidecar.exceptions.CassandraUnavailableException;
import org.apache.cassandra.sidecar.routes.AbstractHandler;
import org.apache.cassandra.sidecar.routes.AccessProtected;
import org.apache.cassandra.sidecar.routes.data.SSTableImportRequestParam;
import org.apache.cassandra.sidecar.utils.CacheFactory;
import org.apache.cassandra.sidecar.utils.CassandraInputValidator;
import org.apache.cassandra.sidecar.utils.HttpExceptions;
import org.apache.cassandra.sidecar.utils.InstanceMetadataFetcher;
import org.apache.cassandra.sidecar.utils.SSTableImporter;
import org.apache.cassandra.sidecar.utils.SSTableUploadsPathBuilder;
import org.jetbrains.annotations.NotNull;

public class SSTableImportHandler
extends AbstractHandler<SSTableImportRequestParam>
implements AccessProtected {
    private final SSTableImporter importer;
    private final SSTableUploadsPathBuilder uploadPathBuilder;
    private final Cache<SSTableImporter.ImportOptions, Future<Void>> cache;

    @Inject
    protected SSTableImportHandler(InstanceMetadataFetcher metadataFetcher, SSTableImporter importer, SSTableUploadsPathBuilder uploadPathBuilder, CacheFactory cacheFactory, ExecutorPools executorPools, CassandraInputValidator validator) {
        super(metadataFetcher, executorPools, validator);
        this.importer = importer;
        this.uploadPathBuilder = uploadPathBuilder;
        this.cache = cacheFactory.ssTableImportCache();
    }

    @Override
    public Set<Authorization> requiredAuthorizations() {
        Set<String> eligibleResources = ResourceScopes.TABLE_SCOPE.expandedResources();
        Authorization modifyAuthorization = CassandraPermissions.MODIFY.toAuthorization(eligibleResources);
        Authorization importAuthorization = BasicPermissions.IMPORT_STAGED_SSTABLE.toAuthorization();
        return Set.of(modifyAuthorization, importAuthorization);
    }

    @Override
    public void handleInternal(RoutingContext context, HttpServerRequest httpRequest, @NotNull String host, SocketAddress remoteAddress, SSTableImportRequestParam request) {
        this.uploadPathBuilder.build(host, request).onSuccess(uploadDirectory -> {
            SSTableImporter.ImportOptions importOptions = SSTableImportHandler.importOptions(host, request, uploadDirectory);
            Future<Void> importResult = (Future<Void>)this.cache.get((Object)importOptions, this::importSSTablesAsync);
            if (importResult == null) {
                importResult = this.importSSTablesAsync(importOptions);
            }
            if (!importResult.isComplete()) {
                this.logger.debug("ImportHandler accepted request={}, remoteAddress={}, instance={}", new Object[]{request, remoteAddress, host});
                context.response().setStatusCode(HttpResponseStatus.ACCEPTED.code()).end();
            } else if (importResult.failed()) {
                this.processFailure(importResult.cause(), context, host, remoteAddress, request);
            } else {
                context.json((Object)new SSTableImportResponse(true, request.uploadId(), request.keyspace().name(), request.table().name()));
                this.logger.debug("ImportHandler completed request={}, remoteAddress={}, instance={}", new Object[]{request, remoteAddress, host});
            }
        }).onFailure(cause -> this.processFailure((Throwable)cause, context, host, remoteAddress, request));
    }

    @Override
    protected void processFailure(Throwable cause, RoutingContext context, String host, SocketAddress remoteAddress, SSTableImportRequestParam request) {
        if (cause instanceof NoSuchFileException) {
            this.logger.error("Upload directory not found for request={}, remoteAddress={}, instance={}", new Object[]{request, remoteAddress, host, cause});
            context.fail((Throwable)HttpExceptions.wrapHttpException(HttpResponseStatus.NOT_FOUND, cause.getMessage()));
        } else if (cause instanceof IllegalArgumentException) {
            context.fail((Throwable)HttpExceptions.wrapHttpException(HttpResponseStatus.BAD_REQUEST, cause.getMessage(), cause));
        } else if (cause instanceof HttpException) {
            context.fail(cause);
        }
        super.processFailure(cause, context, host, remoteAddress, request);
    }

    @Override
    protected SSTableImportRequestParam extractParamsOrThrow(RoutingContext context) {
        return SSTableImportRequestParam.from(this.qualifiedTableName(context, true), context);
    }

    private Future<Void> importSSTablesAsync(SSTableImporter.ImportOptions importOptions) {
        try {
            this.metadataFetcher.delegate(importOptions.host()).tableOperations();
            return this.uploadPathBuilder.isValidDirectory(importOptions.directory()).compose(validDirectory -> this.importer.scheduleImport(importOptions));
        }
        catch (CassandraUnavailableException exception) {
            return Future.failedFuture((Throwable)exception);
        }
    }

    private static SSTableImporter.ImportOptions importOptions(String host, SSTableImportRequestParam request, String uploadDirectory) {
        return new SSTableImporter.ImportOptions.Builder().host(host).keyspace(request.keyspace().name()).tableName(request.table().name()).directory(uploadDirectory).uploadId(request.uploadId()).resetLevel(request.resetLevel()).clearRepaired(request.clearRepaired()).verifySSTables(request.verifySSTables()).verifyTokens(request.verifyTokens()).invalidateCaches(request.invalidateCaches()).extendedVerify(request.extendedVerify()).copyData(request.copyData()).build();
    }
}

