/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.sidecar.routes.restore;

import com.codahale.metrics.Timer;
import com.datastax.driver.core.utils.UUIDs;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.vertx.core.Future;
import io.vertx.core.http.HttpServerRequest;
import io.vertx.core.json.DecodeException;
import io.vertx.core.json.Json;
import io.vertx.core.net.SocketAddress;
import io.vertx.ext.auth.authorization.Authorization;
import io.vertx.ext.web.RoutingContext;
import java.util.Collections;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import org.apache.cassandra.sidecar.acl.authorization.BasicPermissions;
import org.apache.cassandra.sidecar.common.data.RestoreJobStatus;
import org.apache.cassandra.sidecar.common.request.data.UpdateRestoreJobRequestPayload;
import org.apache.cassandra.sidecar.concurrent.ExecutorPools;
import org.apache.cassandra.sidecar.db.RestoreJobDatabaseAccessor;
import org.apache.cassandra.sidecar.metrics.DeltaGauge;
import org.apache.cassandra.sidecar.metrics.RestoreMetrics;
import org.apache.cassandra.sidecar.metrics.SidecarMetrics;
import org.apache.cassandra.sidecar.routes.AbstractHandler;
import org.apache.cassandra.sidecar.routes.AccessProtected;
import org.apache.cassandra.sidecar.routes.RoutingContextUtils;
import org.apache.cassandra.sidecar.utils.CassandraInputValidator;
import org.apache.cassandra.sidecar.utils.HttpExceptions;
import org.apache.cassandra.sidecar.utils.InstanceMetadataFetcher;
import org.jetbrains.annotations.NotNull;

@Singleton
public class UpdateRestoreJobHandler
extends AbstractHandler<UpdateRestoreJobRequestPayload>
implements AccessProtected {
    private final RestoreJobDatabaseAccessor restoreJobDatabaseAccessor;
    private final RestoreMetrics metrics;

    @Inject
    public UpdateRestoreJobHandler(ExecutorPools executorPools, InstanceMetadataFetcher instanceMetadataFetcher, RestoreJobDatabaseAccessor restoreJobDatabaseAccessor, CassandraInputValidator validator, SidecarMetrics metrics) {
        super(instanceMetadataFetcher, executorPools, validator);
        this.restoreJobDatabaseAccessor = restoreJobDatabaseAccessor;
        this.metrics = metrics.server().restore();
    }

    @Override
    public Set<Authorization> requiredAuthorizations() {
        return Collections.singleton(BasicPermissions.EDIT_RESTORE_JOB.toAuthorization());
    }

    @Override
    protected void handleInternal(RoutingContext context, HttpServerRequest httpRequest, @NotNull String host, SocketAddress remoteAddress, UpdateRestoreJobRequestPayload requestPayload) {
        RoutingContextUtils.getAsFuture(context, RoutingContextUtils.SC_RESTORE_JOB).compose(job -> {
            if (job.status.isFinal()) {
                this.logger.debug("The job has completed already. job={}", job);
                return Future.failedFuture((Throwable)HttpExceptions.wrapHttpException(HttpResponseStatus.CONFLICT, "Job is already in final state: " + job.status));
            }
            return this.executorPools.service().executeBlocking(() -> this.restoreJobDatabaseAccessor.update(requestPayload, job.jobId));
        }).onSuccess(job -> {
            this.logger.info("Successfully updated restore job. job={}, request={}, remoteAddress={}, instance={}", new Object[]{job, requestPayload, remoteAddress, host});
            if (job.status == RestoreJobStatus.SUCCEEDED) {
                ((DeltaGauge)this.metrics.successfulJobs.metric).update(1L);
                long startMillis = UUIDs.unixTimestamp((UUID)job.jobId);
                long durationMillis = System.currentTimeMillis() - startMillis;
                ((Timer)this.metrics.jobCompletionTime.metric).update(durationMillis, TimeUnit.MILLISECONDS);
            }
            if (job.secrets != null) {
                ((DeltaGauge)this.metrics.tokenRefreshed.metric).update(1L);
            }
            context.response().setStatusCode(HttpResponseStatus.OK.code()).end();
        }).onFailure(cause -> this.processFailure((Throwable)cause, context, host, remoteAddress, requestPayload));
    }

    @Override
    protected UpdateRestoreJobRequestPayload extractParamsOrThrow(RoutingContext context) {
        String bodyString = context.body().asString();
        if (bodyString == null || bodyString.equalsIgnoreCase("null")) {
            this.logger.warn("Bad request to update restore job. Received null payload.");
            throw HttpExceptions.wrapHttpException(HttpResponseStatus.BAD_REQUEST, "Unexpected null payload for request");
        }
        try {
            UpdateRestoreJobRequestPayload payload = (UpdateRestoreJobRequestPayload)Json.decodeValue((String)bodyString, UpdateRestoreJobRequestPayload.class);
            if (payload.isEmpty()) {
                this.logger.warn("Bad request to update restore job. Received empty payload.");
                throw HttpExceptions.wrapHttpException(HttpResponseStatus.BAD_REQUEST, "Update request body cannot have all empty fields");
            }
            return payload;
        }
        catch (DecodeException decodeException) {
            this.logger.warn("Bad request to update restore job. Received invalid JSON payload.");
            throw HttpExceptions.wrapHttpException(HttpResponseStatus.BAD_REQUEST, "Invalid request payload", decodeException);
        }
    }
}

