/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.sidecar.routes.restore;

import io.netty.handler.codec.http.HttpResponseStatus;
import io.vertx.core.Future;
import io.vertx.core.http.HttpServerRequest;
import io.vertx.core.net.SocketAddress;
import io.vertx.ext.auth.authorization.Authorization;
import io.vertx.ext.web.RoutingContext;
import java.util.Collections;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.apache.cassandra.sidecar.acl.authorization.BasicPermissions;
import org.apache.cassandra.sidecar.common.response.data.RestoreJobSummaryResponsePayload;
import org.apache.cassandra.sidecar.concurrent.ExecutorPools;
import org.apache.cassandra.sidecar.routes.AbstractHandler;
import org.apache.cassandra.sidecar.routes.AccessProtected;
import org.apache.cassandra.sidecar.routes.RoutingContextUtils;
import org.apache.cassandra.sidecar.utils.CassandraInputValidator;
import org.apache.cassandra.sidecar.utils.HttpExceptions;
import org.apache.cassandra.sidecar.utils.InstanceMetadataFetcher;
import org.jetbrains.annotations.NotNull;

@Singleton
public class RestoreJobSummaryHandler
extends AbstractHandler<String>
implements AccessProtected {
    @Inject
    public RestoreJobSummaryHandler(ExecutorPools executorPools, InstanceMetadataFetcher instanceMetadataFetcher, CassandraInputValidator validator) {
        super(instanceMetadataFetcher, executorPools, validator);
    }

    @Override
    public Set<Authorization> requiredAuthorizations() {
        return Collections.singleton(BasicPermissions.READ_RESTORE_JOB.toAuthorization());
    }

    @Override
    protected void handleInternal(RoutingContext context, HttpServerRequest httpRequest, @NotNull String host, SocketAddress remoteAddress, String jobId) {
        this.validateAndFindJob(context).onSuccess(arg_0 -> ((RoutingContext)context).json(arg_0)).onFailure(cause -> this.processFailure((Throwable)cause, context, host, remoteAddress, jobId));
    }

    @Override
    protected String extractParamsOrThrow(RoutingContext context) {
        return context.pathParam("jobId");
    }

    private Future<RestoreJobSummaryResponsePayload> validateAndFindJob(RoutingContext context) {
        return RoutingContextUtils.getAsFuture(context, RoutingContextUtils.SC_RESTORE_JOB).compose(restoreJob -> {
            if (restoreJob.status == null || restoreJob.secrets == null) {
                this.logger.error("Restore job record read is missing required fields. job={}", restoreJob);
                return Future.failedFuture((Throwable)HttpExceptions.wrapHttpException(HttpResponseStatus.INTERNAL_SERVER_ERROR, "Restore job is missing required fields"));
            }
            RestoreJobSummaryResponsePayload response = new RestoreJobSummaryResponsePayload(restoreJob.createdAt.toString(), restoreJob.jobId, restoreJob.jobAgent, restoreJob.keyspaceName, restoreJob.tableName, restoreJob.secrets, restoreJob.statusWithOptionalDescription());
            return Future.succeededFuture((Object)response);
        });
    }
}

