/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.sidecar.routes.restore;

import io.netty.handler.codec.http.HttpResponseStatus;
import io.vertx.core.Future;
import io.vertx.core.http.HttpServerRequest;
import io.vertx.core.json.DecodeException;
import io.vertx.core.json.Json;
import io.vertx.core.net.SocketAddress;
import io.vertx.ext.auth.authorization.Authorization;
import io.vertx.ext.web.RoutingContext;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.Set;
import javax.inject.Inject;
import org.apache.cassandra.sidecar.acl.authorization.BasicPermissions;
import org.apache.cassandra.sidecar.cluster.instance.InstanceMetadata;
import org.apache.cassandra.sidecar.common.request.data.CreateSliceRequestPayload;
import org.apache.cassandra.sidecar.common.server.data.QualifiedTableName;
import org.apache.cassandra.sidecar.concurrent.ExecutorPools;
import org.apache.cassandra.sidecar.db.RestoreJob;
import org.apache.cassandra.sidecar.db.RestoreRange;
import org.apache.cassandra.sidecar.db.RestoreSlice;
import org.apache.cassandra.sidecar.db.RestoreSliceDatabaseAccessor;
import org.apache.cassandra.sidecar.exceptions.RestoreJobFatalException;
import org.apache.cassandra.sidecar.restore.RestoreJobManagerGroup;
import org.apache.cassandra.sidecar.restore.RestoreJobProgressTracker;
import org.apache.cassandra.sidecar.restore.RestoreJobUtil;
import org.apache.cassandra.sidecar.routes.AbstractHandler;
import org.apache.cassandra.sidecar.routes.AccessProtected;
import org.apache.cassandra.sidecar.routes.RoutingContextUtils;
import org.apache.cassandra.sidecar.utils.CassandraInputValidator;
import org.apache.cassandra.sidecar.utils.HttpExceptions;
import org.apache.cassandra.sidecar.utils.InstanceMetadataFetcher;
import org.jetbrains.annotations.NotNull;

public class CreateRestoreSliceHandler
extends AbstractHandler<CreateSliceRequestPayload>
implements AccessProtected {
    private static final int SERVER_ERROR_RESTORE_JOB_FAILED = 550;
    private final RestoreJobManagerGroup restoreJobManagerGroup;
    private final RestoreSliceDatabaseAccessor restoreSliceDatabaseAccessor;

    @Inject
    public CreateRestoreSliceHandler(ExecutorPools executorPools, InstanceMetadataFetcher instanceMetadataFetcher, RestoreJobManagerGroup restoreJobManagerGroup, RestoreSliceDatabaseAccessor restoreSliceDatabaseAccessor, CassandraInputValidator validator) {
        super(instanceMetadataFetcher, executorPools, validator);
        this.restoreJobManagerGroup = restoreJobManagerGroup;
        this.restoreSliceDatabaseAccessor = restoreSliceDatabaseAccessor;
    }

    @Override
    public Set<Authorization> requiredAuthorizations() {
        return Collections.singleton(BasicPermissions.CREATE_RESTORE_JOB.toAuthorization());
    }

    @Override
    protected void handleInternal(RoutingContext context, HttpServerRequest httpRequest, @NotNull String host, SocketAddress remoteAddress, CreateSliceRequestPayload request) {
        InstanceMetadata instance = this.metadataFetcher.instance(host);
        RoutingContextUtils.getAsFuture(context, RoutingContextUtils.SC_RESTORE_JOB).map(restoreJob -> {
            if (restoreJob.status.isFinal()) {
                this.logger.debug("The job has completed already. job={}", restoreJob);
                String errMsg = "Job is already in final state: " + restoreJob.status;
                throw HttpExceptions.wrapHttpException(HttpResponseStatus.CONFLICT, errMsg);
            }
            return restoreJob;
        }).compose(restoreJob -> RoutingContextUtils.getAsFuture(context, RoutingContextUtils.SC_QUALIFIED_TABLE_NAME).map(tableName -> {
            RestoreSlice slice = RestoreSlice.builder().jobId(restoreJob.jobId).qualifiedTableName((QualifiedTableName)tableName).createSliceRequestPayload(request).build();
            return new RestoreSliceAndJob(slice, (RestoreJob)restoreJob);
        })).compose(sliceAndJob -> {
            RestoreSlice slice = sliceAndJob.restoreSlice;
            RestoreJob job = sliceAndJob.restoreJob;
            if (job.isManagedBySidecar()) {
                this.createSliceForSidecarManagedJob(context, slice);
            } else {
                this.createOrPollRangeForSparkManagedJob(context, instance, job, slice);
            }
            return Future.succeededFuture();
        }).onSuccess(nothing -> {
            if (!context.response().ended()) {
                this.logger.warn("The response should have been ended on the absence of error, but not.");
                context.fail(HttpResponseStatus.INTERNAL_SERVER_ERROR.code());
            }
        }).onFailure(cause -> this.processFailure((Throwable)cause, context, host, remoteAddress, request));
    }

    @Override
    protected CreateSliceRequestPayload extractParamsOrThrow(RoutingContext context) {
        String bodyString = context.getBodyAsString();
        if (bodyString == null || bodyString.equalsIgnoreCase("null")) {
            this.logger.warn("Bad request to create restore slice. Received null payload.");
            throw HttpExceptions.wrapHttpException(HttpResponseStatus.BAD_REQUEST, "Unexpected null payload for request");
        }
        try {
            return (CreateSliceRequestPayload)Json.decodeValue((String)bodyString, CreateSliceRequestPayload.class);
        }
        catch (DecodeException decodeException) {
            this.logger.warn("Bad request to create restore slice. Received invalid JSON payload. payload={}", (Object)bodyString);
            throw HttpExceptions.wrapHttpException(HttpResponseStatus.BAD_REQUEST, "Invalid request payload", decodeException);
        }
    }

    private void createOrPollRangeForSparkManagedJob(RoutingContext context, InstanceMetadata instance, RestoreJob job, RestoreSlice slice) {
        RestoreJobProgressTracker.Status status;
        String uploadId = RestoreJobUtil.generateUniqueUploadId(job.jobId, slice.sliceId());
        RestoreRange range = RestoreRange.builderFromSlice(slice).ownerInstance(instance).stageDirectory(Paths.get(instance.stagingDir(), new String[0]), uploadId).build();
        try {
            status = this.restoreJobManagerGroup.trySubmit(instance, range, job);
        }
        catch (RestoreJobFatalException ex) {
            String errorMessage = "Restore slice failed. jobId=" + slice.jobId() + " sliceId=" + slice.sliceId();
            this.logger.error(errorMessage, (Throwable)ex);
            context.fail((Throwable)HttpExceptions.wrapHttpException(HttpResponseStatus.valueOf((int)550), errorMessage, ex));
            return;
        }
        this.logger.info("slice is {}. slice key {}", (Object)status, (Object)slice.key());
        switch (status) {
            case CREATED: {
                context.response().setStatusCode(HttpResponseStatus.CREATED.code()).end();
                break;
            }
            case PENDING: {
                context.response().setStatusCode(HttpResponseStatus.ACCEPTED.code()).end();
                break;
            }
            case COMPLETED: {
                context.response().setStatusCode(HttpResponseStatus.OK.code()).end();
                break;
            }
            default: {
                this.logger.error("Unknown restore slice status. jobId={}, sliceId={}, status={}", new Object[]{slice.jobId(), slice.sliceId(), status});
                context.fail(HttpResponseStatus.INTERNAL_SERVER_ERROR.code());
            }
        }
    }

    private void createSliceForSidecarManagedJob(RoutingContext context, RestoreSlice slice) {
        try {
            this.restoreSliceDatabaseAccessor.create(slice);
        }
        catch (Exception ex) {
            this.logger.error("Failed to persist restore slice. jobId={} sliceId={}", new Object[]{slice.jobId(), slice.sliceId(), ex});
            context.fail(HttpResponseStatus.INTERNAL_SERVER_ERROR.code());
            return;
        }
        context.response().setStatusCode(HttpResponseStatus.CREATED.code()).end();
    }

    private static class RestoreSliceAndJob {
        final RestoreJob restoreJob;
        final RestoreSlice restoreSlice;

        RestoreSliceAndJob(RestoreSlice restoreSlice, RestoreJob restoreJob) {
            this.restoreJob = restoreJob;
            this.restoreSlice = restoreSlice;
        }
    }
}

