/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.sidecar.routes.restore;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.vertx.core.http.HttpServerRequest;
import io.vertx.core.json.Json;
import io.vertx.core.net.SocketAddress;
import io.vertx.ext.auth.authorization.Authorization;
import io.vertx.ext.web.RoutingContext;
import java.util.Collections;
import java.util.Set;
import org.apache.cassandra.sidecar.acl.authorization.BasicPermissions;
import org.apache.cassandra.sidecar.common.request.data.AbortRestoreJobRequestPayload;
import org.apache.cassandra.sidecar.concurrent.ExecutorPools;
import org.apache.cassandra.sidecar.db.RestoreJobDatabaseAccessor;
import org.apache.cassandra.sidecar.metrics.DeltaGauge;
import org.apache.cassandra.sidecar.metrics.RestoreMetrics;
import org.apache.cassandra.sidecar.metrics.SidecarMetrics;
import org.apache.cassandra.sidecar.routes.AbstractHandler;
import org.apache.cassandra.sidecar.routes.AccessProtected;
import org.apache.cassandra.sidecar.routes.RoutingContextUtils;
import org.apache.cassandra.sidecar.utils.CassandraInputValidator;
import org.apache.cassandra.sidecar.utils.HttpExceptions;
import org.apache.cassandra.sidecar.utils.InstanceMetadataFetcher;
import org.jetbrains.annotations.NotNull;

@Singleton
public class AbortRestoreJobHandler
extends AbstractHandler<AbortRestoreJobRequestPayload>
implements AccessProtected {
    private static final AbortRestoreJobRequestPayload EMPTY_PAYLOAD = new AbortRestoreJobRequestPayload(null);
    private final RestoreJobDatabaseAccessor restoreJobDatabaseAccessor;
    private final RestoreMetrics metrics;

    @Inject
    public AbortRestoreJobHandler(ExecutorPools executorPools, InstanceMetadataFetcher instanceMetadataFetcher, RestoreJobDatabaseAccessor restoreJobDatabaseAccessor, CassandraInputValidator validator, SidecarMetrics metrics) {
        super(instanceMetadataFetcher, executorPools, validator);
        this.restoreJobDatabaseAccessor = restoreJobDatabaseAccessor;
        this.metrics = metrics.server().restore();
    }

    @Override
    public Set<Authorization> requiredAuthorizations() {
        return Collections.singleton(BasicPermissions.DELETE_RESTORE_JOB.toAuthorization());
    }

    @Override
    protected void handleInternal(RoutingContext context, HttpServerRequest httpRequest, @NotNull String host, SocketAddress remoteAddress, AbortRestoreJobRequestPayload payload) {
        RoutingContextUtils.getAsFuture(context, RoutingContextUtils.SC_RESTORE_JOB).map(job -> {
            if (job.status.isFinal()) {
                throw HttpExceptions.wrapHttpException(HttpResponseStatus.CONFLICT, "Job is already in final state: " + job.status);
            }
            this.restoreJobDatabaseAccessor.abort(job.jobId, payload.reason());
            this.logger.info("Successfully aborted restore job. job={} remoteAddress={} instance={} reason='{}'", new Object[]{job, remoteAddress, host, payload.reason()});
            return job;
        }).onSuccess(job -> {
            ((DeltaGauge)this.metrics.failedJobs.metric).update(1L);
            context.response().setStatusCode(HttpResponseStatus.OK.code()).end();
        }).onFailure(cause -> this.processFailure((Throwable)cause, context, host, remoteAddress, payload));
    }

    @Override
    @NotNull
    protected AbortRestoreJobRequestPayload extractParamsOrThrow(RoutingContext context) {
        String bodyString = context.body().asString();
        try {
            return (AbortRestoreJobRequestPayload)Json.decodeValue((String)bodyString, AbortRestoreJobRequestPayload.class);
        }
        catch (Exception cause) {
            if (bodyString != null) {
                this.logger.warn("Failed to deserialize json string into AbortRestoreJobRequestPayload", (Throwable)cause);
            }
            return EMPTY_PAYLOAD;
        }
    }
}

