/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.sidecar.routes;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.vertx.core.http.HttpServerRequest;
import io.vertx.core.net.SocketAddress;
import io.vertx.ext.auth.authorization.Authorization;
import io.vertx.ext.web.RoutingContext;
import java.util.Collections;
import java.util.Set;
import org.apache.cassandra.sidecar.acl.authorization.BasicPermissions;
import org.apache.cassandra.sidecar.cluster.CassandraAdapterDelegate;
import org.apache.cassandra.sidecar.common.response.NodeSettings;
import org.apache.cassandra.sidecar.common.server.StorageOperations;
import org.apache.cassandra.sidecar.common.server.data.Name;
import org.apache.cassandra.sidecar.concurrent.ExecutorPools;
import org.apache.cassandra.sidecar.routes.AbstractHandler;
import org.apache.cassandra.sidecar.routes.AccessProtected;
import org.apache.cassandra.sidecar.utils.CassandraInputValidator;
import org.apache.cassandra.sidecar.utils.HttpExceptions;
import org.apache.cassandra.sidecar.utils.InstanceMetadataFetcher;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;

@Singleton
public class TokenRangeReplicaMapHandler
extends AbstractHandler<Name>
implements AccessProtected {
    @Inject
    public TokenRangeReplicaMapHandler(InstanceMetadataFetcher metadataFetcher, CassandraInputValidator validator, ExecutorPools executorPools) {
        super(metadataFetcher, executorPools, validator);
    }

    @Override
    public Set<Authorization> requiredAuthorizations() {
        return Collections.singleton(BasicPermissions.READ_TOPOLOGY.toAuthorization());
    }

    @Override
    public void handleInternal(RoutingContext context, HttpServerRequest httpRequest, @NotNull String host, SocketAddress remoteAddress, Name keyspace) {
        CassandraAdapterDelegate delegate = this.metadataFetcher.delegate(host);
        NodeSettings nodeSettings = delegate.nodeSettings();
        StorageOperations operations = delegate.storageOperations();
        this.executorPools.service().executeBlocking(() -> operations.tokenRangeReplicas(keyspace, nodeSettings.partitioner())).onSuccess(arg_0 -> ((RoutingContext)context).json(arg_0)).onFailure(cause -> this.processFailure((Throwable)cause, context, host, remoteAddress, keyspace));
    }

    @Override
    protected Name extractParamsOrThrow(RoutingContext context) {
        Name keyspace = this.keyspace(context, true);
        if (keyspace == null) {
            throw HttpExceptions.wrapHttpException(HttpResponseStatus.BAD_REQUEST, "'keyspace' is required but not supplied");
        }
        return keyspace;
    }

    @Override
    protected void processFailure(Throwable cause, RoutingContext context, String host, SocketAddress remoteAddress, Name keyspace) {
        if (cause instanceof AssertionError && StringUtils.contains((CharSequence)cause.getMessage(), (CharSequence)"Unknown keyspace")) {
            context.fail((Throwable)HttpExceptions.wrapHttpException(HttpResponseStatus.NOT_FOUND, cause.getMessage()));
            return;
        }
        super.processFailure(cause, context, host, remoteAddress, keyspace);
    }
}

