/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.sidecar.restore;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.cassandra.sidecar.cluster.InstancesMetadata;
import org.apache.cassandra.sidecar.cluster.instance.InstanceMetadata;
import org.apache.cassandra.sidecar.common.server.cluster.locator.TokenRange;
import org.apache.cassandra.sidecar.concurrent.ExecutorPools;
import org.apache.cassandra.sidecar.config.RestoreJobConfiguration;
import org.apache.cassandra.sidecar.config.SidecarConfiguration;
import org.apache.cassandra.sidecar.db.RestoreJob;
import org.apache.cassandra.sidecar.db.RestoreRange;
import org.apache.cassandra.sidecar.exceptions.RestoreJobFatalException;
import org.apache.cassandra.sidecar.restore.RestoreJobDiscoverer;
import org.apache.cassandra.sidecar.restore.RestoreJobManager;
import org.apache.cassandra.sidecar.restore.RestoreJobProgressTracker;
import org.apache.cassandra.sidecar.restore.RestoreProcessor;
import org.apache.cassandra.sidecar.restore.RingTopologyRefresher;
import org.apache.cassandra.sidecar.tasks.PeriodicTaskExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class RestoreJobManagerGroup {
    private static final Logger LOGGER = LoggerFactory.getLogger(RestoreJobManagerGroup.class);
    private final RestoreJobConfiguration restoreJobConfig;
    private final Map<Integer, RestoreJobManager> managerGroup = new ConcurrentHashMap<Integer, RestoreJobManager>();
    private final RestoreProcessor restoreProcessor;
    private final ExecutorPools executorPools;

    @Inject
    public RestoreJobManagerGroup(SidecarConfiguration configuration, InstancesMetadata instancesMetadata, ExecutorPools executorPools, PeriodicTaskExecutor periodicTaskExecutor, RestoreProcessor restoreProcessor, RestoreJobDiscoverer jobDiscoverer, RingTopologyRefresher ringTopologyRefresher) {
        this.restoreJobConfig = configuration.restoreJobConfiguration();
        this.restoreProcessor = restoreProcessor;
        this.executorPools = executorPools;
        this.initializeManagers(instancesMetadata);
        periodicTaskExecutor.schedule(jobDiscoverer);
        periodicTaskExecutor.schedule(restoreProcessor);
        periodicTaskExecutor.schedule(ringTopologyRefresher);
    }

    public RestoreJobProgressTracker.Status trySubmit(InstanceMetadata instance, RestoreRange range, RestoreJob restoreJob) throws RestoreJobFatalException {
        return this.getManager(instance).trySubmit(range, restoreJob);
    }

    void removeJobInternal(RestoreJob restoreJob) {
        if (!restoreJob.status.isFinal()) {
            throw new IllegalStateException("Cannot remove job that is not in final status");
        }
        this.managerGroup.values().forEach(manager -> manager.removeJobInternal(restoreJob.jobId));
    }

    void updateRestoreJob(RestoreJob restoreJob) {
        if (restoreJob.status.isFinal()) {
            throw new IllegalStateException("Cannot update with a restore job in final status");
        }
        this.managerGroup.values().forEach(manager -> manager.updateRestoreJob(restoreJob));
    }

    Set<RestoreRange> discardOverlappingRanges(InstanceMetadata instanceMetadata, RestoreJob restoreJob, Set<TokenRange> otherRanges) {
        if (restoreJob.status.isFinal()) {
            throw new IllegalStateException("Cannot remove ranges from a restore job in final status");
        }
        RestoreJobManager manager = this.managerGroup.get(instanceMetadata.id());
        if (manager == null) {
            LOGGER.debug("No RestoreJobManager found for Cassandra instance. No ranges to discard. instanceId={}", (Object)instanceMetadata.id());
            return Set.of();
        }
        return manager.discardOverlappingRanges(restoreJob, otherRanges);
    }

    private RestoreJobManager getManager(InstanceMetadata instance) {
        return this.managerGroup.computeIfAbsent(instance.id(), id -> new RestoreJobManager(this.restoreJobConfig, instance, this.executorPools, this.restoreProcessor));
    }

    private void initializeManagers(InstancesMetadata instancesMetadata) {
        instancesMetadata.instances().forEach(this::getManager);
    }
}

