/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.sidecar.metrics;

import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.SharedMetricRegistries;
import com.google.common.annotations.VisibleForTesting;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.Collections;
import java.util.List;
import org.apache.cassandra.sidecar.config.SidecarConfiguration;
import org.apache.cassandra.sidecar.metrics.FilteringMetricRegistry;
import org.apache.cassandra.sidecar.metrics.MetricFilter;

@Singleton
public class MetricRegistryFactory {
    private final String globalRegistryName;
    private final List<MetricFilter> inclusions;
    private final List<MetricFilter> exclusions;

    @Inject
    public MetricRegistryFactory(SidecarConfiguration sidecarConfiguration) {
        this(sidecarConfiguration.metricsConfiguration().registryName(), MetricFilter.parse(sidecarConfiguration.metricsConfiguration().includeConfigurations()), MetricFilter.parse(sidecarConfiguration.metricsConfiguration().excludeConfigurations()));
    }

    @VisibleForTesting
    public MetricRegistryFactory(String globalRegistryName, List<MetricFilter> inclusions, List<MetricFilter> exclusions) {
        this.globalRegistryName = globalRegistryName;
        this.inclusions = Collections.unmodifiableList(inclusions);
        this.exclusions = Collections.unmodifiableList(exclusions);
    }

    public MetricRegistry getOrCreate() {
        return this.getOrCreate(this.globalRegistryName);
    }

    public MetricRegistry getOrCreate(int cassInstanceId) {
        String instanceRegistryName = this.globalRegistryName + "_" + cassInstanceId;
        return this.getOrCreate(instanceRegistryName);
    }

    public MetricRegistry getOrCreate(String name) {
        if (SharedMetricRegistries.names().contains(name)) {
            return SharedMetricRegistries.getOrCreate((String)name);
        }
        FilteringMetricRegistry metricRegistry = new FilteringMetricRegistry(this::isAllowed);
        SharedMetricRegistries.add((String)name, (MetricRegistry)metricRegistry);
        return SharedMetricRegistries.getOrCreate((String)name);
    }

    private boolean isAllowed(String name) {
        boolean included = this.inclusions.isEmpty() || this.inclusions.stream().anyMatch(filter -> filter.matches(name));
        boolean excluded = this.exclusions.stream().anyMatch(filter -> filter.matches(name));
        return included && !excluded;
    }
}

