/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.sidecar.db.schema;

import com.datastax.driver.core.KeyspaceMetadata;
import com.datastax.driver.core.PreparedStatement;
import com.datastax.driver.core.Session;
import com.google.inject.Singleton;
import org.apache.cassandra.sidecar.db.schema.CassandraSystemTableSchema;
import org.apache.cassandra.sidecar.exceptions.SchemaUnavailableException;
import org.jetbrains.annotations.NotNull;

@Singleton
public class SystemAuthSchema
extends CassandraSystemTableSchema {
    private static final String IDENTITY_TO_ROLE_TABLE = "identity_to_role";
    private PreparedStatement roleFromIdentity;
    private PreparedStatement allRolesAndIdentities;
    private PreparedStatement roleSuperuserStatus;
    private PreparedStatement allRoles;
    private PreparedStatement allRolesAndPermissions;

    protected String keyspaceName() {
        return "system_auth";
    }

    protected void prepareStatements(@NotNull Session session) {
        this.roleSuperuserStatus = this.prepare(this.roleSuperuserStatus, session, "SELECT is_superuser FROM system_auth.roles WHERE role = ?");
        this.allRoles = this.prepare(this.allRoles, session, "SELECT * FROM system_auth.roles");
        this.allRolesAndPermissions = this.prepare(this.allRolesAndPermissions, session, "SELECT * FROM system_auth.role_permissions");
        KeyspaceMetadata keyspaceMetadata = session.getCluster().getMetadata().getKeyspace(this.keyspaceName());
        if (keyspaceMetadata == null || keyspaceMetadata.getTable(IDENTITY_TO_ROLE_TABLE) == null) {
            this.logger.info("system_auth.identity_to_role does not exist. Skip preparing. table={}.{}", (Object)this.keyspaceName(), (Object)IDENTITY_TO_ROLE_TABLE);
            return;
        }
        this.roleFromIdentity = this.prepare(this.roleFromIdentity, session, "SELECT role FROM system_auth.identity_to_role WHERE identity = ?");
        this.allRolesAndIdentities = this.prepare(this.allRolesAndIdentities, session, "SELECT role, identity FROM system_auth.identity_to_role");
    }

    protected String tableName() {
        throw new UnsupportedOperationException("SystemAuthSchema supports reading information from multiple tables in system_auth keyspace");
    }

    @NotNull
    public PreparedStatement roleFromIdentity() {
        this.ensureSchemaAvailable();
        return this.roleFromIdentity;
    }

    @NotNull
    public PreparedStatement allRolesAndIdentities() {
        this.ensureSchemaAvailable();
        return this.allRolesAndIdentities;
    }

    public PreparedStatement allRolesAndPermissions() {
        return this.allRolesAndPermissions;
    }

    public PreparedStatement roleSuperuserStatus() {
        return this.roleSuperuserStatus;
    }

    public PreparedStatement allRoles() {
        return this.allRoles;
    }

    protected void ensureSchemaAvailable() throws SchemaUnavailableException {
        if (this.roleFromIdentity == null || this.allRolesAndIdentities == null) {
            throw new SchemaUnavailableException(this.keyspaceName(), IDENTITY_TO_ROLE_TABLE);
        }
    }
}

