/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.sidecar.db.schema;

import com.datastax.driver.core.PreparedStatement;
import com.datastax.driver.core.Session;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import org.apache.cassandra.sidecar.config.SchemaKeyspaceConfiguration;
import org.apache.cassandra.sidecar.config.ServiceConfiguration;
import org.apache.cassandra.sidecar.db.schema.TableSchema;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.VisibleForTesting;

@Singleton
public class SidecarLeaseSchema
extends TableSchema {
    private static final String TABLE_NAME = "sidecar_lease_v1";
    private final SchemaKeyspaceConfiguration keyspaceConfig;
    private PreparedStatement claimLease;
    private PreparedStatement extendLease;

    @Inject
    public SidecarLeaseSchema(ServiceConfiguration configuration) {
        this(configuration.schemaKeyspaceConfiguration());
    }

    public SidecarLeaseSchema(SchemaKeyspaceConfiguration keyspaceConfig) {
        this.keyspaceConfig = keyspaceConfig;
    }

    protected String tableName() {
        return TABLE_NAME;
    }

    protected String keyspaceName() {
        return this.keyspaceConfig.keyspace();
    }

    @VisibleForTesting
    public void prepareStatements(@NotNull Session session) {
        this.claimLease = this.prepare(this.claimLease, session, String.format("INSERT INTO %s.%s (name,owner) VALUES ('cluster_lease_holder',?) IF NOT EXISTS USING TTL %d", this.keyspaceName(), this.tableName(), this.keyspaceConfig.leaseSchemaTTL().toSeconds()));
        this.extendLease = this.prepare(this.extendLease, session, String.format("UPDATE %s.%s USING TTL %d SET owner = ? WHERE name = 'cluster_lease_holder' IF owner = ?", this.keyspaceName(), this.tableName(), this.keyspaceConfig.leaseSchemaTTL().toSeconds()));
    }

    @VisibleForTesting
    public String createSchemaStatement() {
        return String.format("CREATE TABLE IF NOT EXISTS %s.%s (name text PRIMARY KEY,owner text) WITH gc_grace_seconds = 86400", this.keyspaceName(), this.tableName());
    }

    public PreparedStatement claimLeaseStatement() {
        return this.claimLease;
    }

    public PreparedStatement extendLeaseStatement() {
        return this.extendLease;
    }
}

