/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.sidecar.db;

import com.datastax.driver.core.BoundStatement;
import com.datastax.driver.core.ResultSet;
import com.datastax.driver.core.Row;
import com.datastax.driver.core.Statement;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import io.vertx.ext.auth.authorization.Authorization;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.cassandra.sidecar.acl.authorization.PermissionFactory;
import org.apache.cassandra.sidecar.common.server.CQLSessionProvider;
import org.apache.cassandra.sidecar.db.DatabaseAccessor;
import org.apache.cassandra.sidecar.db.schema.SidecarRolePermissionsSchema;
import org.apache.cassandra.sidecar.db.schema.TableSchema;

@Singleton
public class SidecarPermissionsDatabaseAccessor
extends DatabaseAccessor<SidecarRolePermissionsSchema> {
    private final PermissionFactory permissionFactory;

    @Inject
    protected SidecarPermissionsDatabaseAccessor(SidecarRolePermissionsSchema tableSchema, CQLSessionProvider sessionProvider, PermissionFactory permissionFactory) {
        super((TableSchema)tableSchema, sessionProvider);
        this.permissionFactory = permissionFactory;
    }

    public Map<String, Set<Authorization>> rolesToAuthorizations() {
        BoundStatement statement = ((SidecarRolePermissionsSchema)this.tableSchema).allRolesPermissions().bind();
        ResultSet result = this.execute((Statement)statement);
        HashMap<String, Set<Authorization>> roleAuthorizations = new HashMap<String, Set<Authorization>>();
        for (Row row : result) {
            String role = row.getString("role");
            String resource = row.getString("resource");
            Set permissions = row.getSet("permissions", String.class);
            HashSet<Authorization> authorizations = new HashSet<Authorization>();
            for (String permission : permissions) {
                try {
                    authorizations.add(this.permissionFactory.createPermission(permission).toAuthorization(resource));
                }
                catch (Exception e) {
                    this.logger.error("Error parsing Sidecar permission={} resource={} role={}", new Object[]{permission, resource, role, e});
                }
            }
            if (authorizations.isEmpty()) continue;
            roleAuthorizations.computeIfAbsent(role, k -> new HashSet()).addAll(authorizations);
        }
        return roleAuthorizations;
    }
}

