/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.sidecar.db;

import com.datastax.driver.core.BoundStatement;
import com.datastax.driver.core.ResultSet;
import com.datastax.driver.core.Statement;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import org.apache.cassandra.sidecar.common.server.CQLSessionProvider;
import org.apache.cassandra.sidecar.db.DatabaseAccessor;
import org.apache.cassandra.sidecar.db.schema.SidecarLeaseSchema;
import org.apache.cassandra.sidecar.db.schema.TableSchema;
import org.jetbrains.annotations.VisibleForTesting;

@Singleton
public class SidecarLeaseDatabaseAccessor
extends DatabaseAccessor<SidecarLeaseSchema> {
    @Inject
    @VisibleForTesting
    public SidecarLeaseDatabaseAccessor(SidecarLeaseSchema tableSchema, CQLSessionProvider sessionProvider) {
        super((TableSchema)tableSchema, sessionProvider);
    }

    public LeaseClaimResult claimLease(String leaseClaimer) {
        BoundStatement statement = ((SidecarLeaseSchema)this.tableSchema).claimLeaseStatement().bind(new Object[]{leaseClaimer});
        ResultSet resultSet = this.execute((Statement)statement);
        return LeaseClaimResult.from(resultSet, leaseClaimer);
    }

    public LeaseClaimResult extendLease(String currentOwner) {
        BoundStatement statement = ((SidecarLeaseSchema)this.tableSchema).extendLeaseStatement().bind(new Object[]{currentOwner, currentOwner});
        ResultSet resultSet = this.execute((Statement)statement);
        return LeaseClaimResult.from(resultSet, currentOwner);
    }

    public static class LeaseClaimResult {
        public final boolean leaseAcquired;
        public final String currentOwner;

        LeaseClaimResult(boolean leaseAcquired, String currentOwner) {
            this.leaseAcquired = leaseAcquired;
            this.currentOwner = currentOwner;
        }

        static LeaseClaimResult from(ResultSet resultSet, String newOwner) {
            return resultSet.wasApplied() ? new LeaseClaimResult(true, newOwner) : new LeaseClaimResult(false, resultSet.one().getString("owner"));
        }
    }
}

