/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.sidecar.db;

import com.datastax.driver.core.BoundStatement;
import com.datastax.driver.core.ResultSet;
import com.datastax.driver.core.Row;
import com.datastax.driver.core.Statement;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.ArrayList;
import java.util.List;
import org.apache.cassandra.sidecar.common.server.CQLSessionProvider;
import org.apache.cassandra.sidecar.common.server.cluster.locator.TokenRange;
import org.apache.cassandra.sidecar.db.DatabaseAccessor;
import org.apache.cassandra.sidecar.db.RestoreJob;
import org.apache.cassandra.sidecar.db.RestoreSlice;
import org.apache.cassandra.sidecar.db.schema.RestoreSlicesSchema;
import org.apache.cassandra.sidecar.db.schema.SidecarSchema;
import org.apache.cassandra.sidecar.db.schema.TableSchema;

@Singleton
public class RestoreSliceDatabaseAccessor
extends DatabaseAccessor<RestoreSlicesSchema> {
    private final SidecarSchema sidecarSchema;

    @Inject
    protected RestoreSliceDatabaseAccessor(SidecarSchema sidecarSchema, RestoreSlicesSchema restoreSlicesSchema, CQLSessionProvider cqlSessionProvider) {
        super((TableSchema)restoreSlicesSchema, cqlSessionProvider);
        this.sidecarSchema = sidecarSchema;
    }

    public RestoreSlice create(RestoreSlice slice) {
        this.sidecarSchema.ensureInitialized();
        BoundStatement statement = ((RestoreSlicesSchema)this.tableSchema).insertSlice().bind(new Object[]{slice.jobId(), slice.bucketId(), slice.sliceId(), slice.bucket(), slice.key(), slice.checksum(), slice.startToken(), slice.endToken(), slice.compressedSize(), slice.uncompressedSize()});
        this.execute((Statement)statement);
        return slice;
    }

    public List<RestoreSlice> selectByJobByBucketByTokenRange(RestoreJob restoreJob, short bucketId, TokenRange range) {
        this.sidecarSchema.ensureInitialized();
        BoundStatement statement = ((RestoreSlicesSchema)this.tableSchema).findAllByTokenRange().bind(new Object[]{restoreJob.jobId, bucketId, range.start().toBigInteger(), range.end().toBigInteger()});
        ResultSet result = this.execute((Statement)statement);
        ArrayList<RestoreSlice> slices = new ArrayList<RestoreSlice>();
        for (Row row : result) {
            slices.add(RestoreSlice.from(row, restoreJob));
        }
        return slices;
    }
}

