/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.sidecar.db;

import com.datastax.driver.core.BoundStatement;
import com.datastax.driver.core.ResultSet;
import com.datastax.driver.core.Row;
import com.datastax.driver.core.Statement;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.apache.cassandra.sidecar.common.server.CQLSessionProvider;
import org.apache.cassandra.sidecar.db.DatabaseAccessor;
import org.apache.cassandra.sidecar.db.RestoreRange;
import org.apache.cassandra.sidecar.db.schema.RestoreRangesSchema;
import org.apache.cassandra.sidecar.db.schema.SidecarSchema;
import org.apache.cassandra.sidecar.db.schema.TableSchema;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class RestoreRangeDatabaseAccessor
extends DatabaseAccessor<RestoreRangesSchema> {
    private static final Logger LOGGER = LoggerFactory.getLogger(RestoreRangeDatabaseAccessor.class);
    private final SidecarSchema sidecarSchema;

    @Inject
    protected RestoreRangeDatabaseAccessor(SidecarSchema sidecarSchema, RestoreRangesSchema tableSchema, CQLSessionProvider sessionProvider) {
        super((TableSchema)tableSchema, sessionProvider);
        this.sidecarSchema = sidecarSchema;
    }

    public RestoreRange create(RestoreRange range) {
        this.sidecarSchema.ensureInitialized();
        BoundStatement statement = ((RestoreRangesSchema)this.tableSchema).createRange().bind(new Object[]{range.sliceId(), range.sliceBucket(), range.sliceKey(), range.statusTextByReplica(), range.jobId(), range.bucketId(), range.startToken(), range.endToken()});
        this.execute((Statement)statement);
        LOGGER.debug("Created range={}", (Object)range);
        return range;
    }

    public RestoreRange updateStatus(RestoreRange range) {
        this.sidecarSchema.ensureInitialized();
        BoundStatement statement = ((RestoreRangesSchema)this.tableSchema).updateStatus().bind(new Object[]{range.statusTextByReplica(), range.jobId(), range.bucketId(), range.startToken(), range.endToken()});
        this.execute((Statement)statement);
        LOGGER.debug("Updated range={}", (Object)range);
        return range;
    }

    public List<RestoreRange> findAll(UUID jobId, short bucketId) {
        this.sidecarSchema.ensureInitialized();
        BoundStatement statement = ((RestoreRangesSchema)this.tableSchema).findAll().bind(new Object[]{jobId, bucketId});
        ResultSet result = this.execute((Statement)statement);
        ArrayList<RestoreRange> ranges = new ArrayList<RestoreRange>();
        for (Row row : result) {
            ranges.add(RestoreRange.from(row));
        }
        return ranges;
    }
}

