/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.sidecar.db;

import com.datastax.driver.core.Row;
import java.math.BigInteger;
import java.net.InetSocketAddress;
import java.nio.file.Path;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.function.Function;
import org.apache.cassandra.sidecar.cluster.instance.InstanceMetadata;
import org.apache.cassandra.sidecar.cluster.locator.LocalTokenRangesProvider;
import org.apache.cassandra.sidecar.common.DataObjectBuilder;
import org.apache.cassandra.sidecar.common.response.data.RestoreRangeJson;
import org.apache.cassandra.sidecar.common.server.cluster.locator.TokenRange;
import org.apache.cassandra.sidecar.common.server.data.RestoreRangeStatus;
import org.apache.cassandra.sidecar.common.server.utils.StringUtils;
import org.apache.cassandra.sidecar.concurrent.TaskExecutorPool;
import org.apache.cassandra.sidecar.db.RestoreJob;
import org.apache.cassandra.sidecar.db.RestoreRangeDatabaseAccessor;
import org.apache.cassandra.sidecar.db.RestoreSlice;
import org.apache.cassandra.sidecar.exceptions.CassandraUnavailableException;
import org.apache.cassandra.sidecar.exceptions.RestoreJobExceptions;
import org.apache.cassandra.sidecar.exceptions.RestoreJobFatalException;
import org.apache.cassandra.sidecar.metrics.SidecarMetrics;
import org.apache.cassandra.sidecar.restore.RestoreJobProgressTracker;
import org.apache.cassandra.sidecar.restore.RestoreJobUtil;
import org.apache.cassandra.sidecar.restore.RestoreRangeHandler;
import org.apache.cassandra.sidecar.restore.RestoreRangeTask;
import org.apache.cassandra.sidecar.restore.StorageClient;
import org.apache.cassandra.sidecar.restore.StorageClientPool;
import org.apache.cassandra.sidecar.utils.SSTableImporter;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;

public class RestoreRange {
    public static final Comparator<RestoreRange> TOKEN_BASED_NATURAL_ORDER = Comparator.comparing(RestoreRange::startToken).thenComparing(RestoreRange::endToken);
    @NotNull
    private final UUID jobId;
    @NotNull
    private final short bucketId;
    @NotNull
    private final String sliceId;
    @NotNull
    private final String sliceBucket;
    @NotNull
    private final String sliceKey;
    @NotNull
    private final TokenRange tokenRange;
    @NotNull
    private final Map<String, RestoreRangeStatus> statusByReplica;
    @Nullable
    private final RestoreSlice source;
    private final Path stageDirectory;
    private final Path stagedObjectPath;
    private final String uploadId;
    private final InstanceMetadata owner;
    private final RestoreJobProgressTracker tracker;
    private Long sliceObjectLength;
    private boolean existsOnS3 = false;
    private boolean hasStaged = false;
    private boolean hasImported = false;
    private int downloadAttempt = 0;
    private volatile boolean isCancelled = false;
    private volatile boolean discarded = false;

    public static RestoreRange from(Row row) {
        return new Builder().jobId(row.getUUID("job_id")).bucketId(row.getShort("bucket_id")).startToken(row.getVarint("start_token")).endToken(row.getVarint("end_token")).replicaStatusText(row.getMap("status_by_replica", String.class, String.class)).sliceId(row.getString("slice_id")).sliceBucket(row.getString("slice_bucket")).sliceKey(row.getString("slice_key")).build();
    }

    public static Builder builderFromSlice(RestoreSlice slice) {
        return new Builder().sourceSlice(slice);
    }

    private RestoreRange(Builder builder) {
        this.jobId = builder.jobId;
        this.bucketId = builder.bucketId;
        this.tokenRange = new TokenRange(builder.startToken, builder.endToken);
        this.source = builder.sourceSlice;
        this.sliceId = builder.sliceId;
        this.sliceKey = builder.sliceKey;
        this.sliceBucket = builder.sliceBucket;
        this.stageDirectory = builder.stageDirectory;
        this.stagedObjectPath = builder.stagedObjectPath;
        this.uploadId = builder.uploadId;
        this.owner = builder.owner;
        this.statusByReplica = new HashMap<String, RestoreRangeStatus>(builder.statusByReplica);
        this.tracker = builder.tracker;
        this.discarded = builder.discarded;
    }

    public Builder unbuild() {
        return new Builder(this);
    }

    public RestoreRangeJson toJson() {
        return new RestoreRangeJson(this.sliceId, (int)this.bucketId, this.sliceBucket, this.sliceKey, this.tokenRange.startAsBigInt(), this.tokenRange.endAsBigInt());
    }

    public int hashCode() {
        return Objects.hash(this.tokenRange, this.jobId, this.bucketId, this.sliceId);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof RestoreRange)) {
            return false;
        }
        RestoreRange that = (RestoreRange)obj;
        return Objects.equals(this.tokenRange, that.tokenRange) && Objects.equals(this.jobId, that.jobId) && Objects.equals(this.bucketId, that.bucketId) && Objects.equals(this.sliceId, that.sliceId);
    }

    public String toString() {
        return "RestoreRange{jobId=" + this.jobId + ", sliceId='" + this.sliceId + "', tokenRange=" + this.tokenRange + ", statusByReplica=" + this.statusByReplica + ", sliceKey='" + this.sliceKey + "', sliceBucket='" + this.sliceBucket + "'}";
    }

    public void complete() {
        this.tracker.completeRange(this);
    }

    public void completeStagePhase() {
        this.hasStaged = true;
        this.updateRangeStatusForInstance(this.owner(), RestoreRangeStatus.STAGED);
    }

    public void completeImportPhase() {
        this.hasImported = true;
        this.updateRangeStatusForInstance(this.owner(), RestoreRangeStatus.SUCCEEDED);
    }

    public void fail(RestoreJobFatalException exception) {
        this.tracker.fail(exception);
        this.updateRangeStatusForInstance(this.owner(), RestoreRangeStatus.FAILED);
    }

    public void requestOutOfRangeDataCleanup() {
        this.tracker.requestOutOfRangeDataCleanup();
    }

    public void setExistsOnS3(Long objectLength) {
        this.existsOnS3 = true;
        this.sliceObjectLength = objectLength;
    }

    public void incrementDownloadAttempt() {
        ++this.downloadAttempt;
    }

    public void cancel() {
        this.isCancelled = true;
    }

    public void discard() {
        this.discarded = true;
        this.updateRangeStatusForInstance(this.owner(), RestoreRangeStatus.DISCARDED);
        this.cancel();
    }

    public boolean isDiscarded() {
        return this.discarded;
    }

    public RestoreRangeHandler toAsyncTask(StorageClientPool s3ClientPool, TaskExecutorPool executorPool, SSTableImporter importer, double requiredUsableSpacePercentage, RestoreRangeDatabaseAccessor rangeDatabaseAccessor, RestoreJobUtil restoreJobUtil, LocalTokenRangesProvider localTokenRangesProvider, SidecarMetrics metrics) {
        if (!this.canProduceTask()) {
            return RestoreRangeTask.failed(RestoreJobExceptions.ofFatal("Restore range is missing progress tracker or source slice", this, null), this);
        }
        if (this.isCancelled) {
            return RestoreRangeTask.failed(RestoreJobExceptions.ofFatal("Restore range is cancelled", this, null), this);
        }
        if (this.tracker.restoreJob().hasExpired(System.currentTimeMillis())) {
            return RestoreRangeTask.failed(RestoreJobExceptions.ofFatal("Restore job expired on " + this.tracker.restoreJob().expireAt.toInstant(), this, null), this);
        }
        try {
            StorageClient s3Client = s3ClientPool.storageClient(this.job());
            return new RestoreRangeTask(this, s3Client, executorPool, importer, requiredUsableSpacePercentage, rangeDatabaseAccessor, restoreJobUtil, localTokenRangesProvider, metrics);
        }
        catch (Exception cause) {
            return RestoreRangeTask.failed(RestoreJobExceptions.ofFatal("Restore range is failed", this, cause), this);
        }
    }

    @NotNull
    public final RestoreJob job() {
        return this.tracker.restoreJob();
    }

    public UUID jobId() {
        return this.jobId;
    }

    public String sliceId() {
        return this.sliceId;
    }

    public String sliceKey() {
        return this.sliceKey;
    }

    public String sliceBucket() {
        return this.sliceBucket;
    }

    public String sliceChecksum() {
        return this.readSliceProperty(RestoreSlice::checksum);
    }

    public long sliceCreationTimeNanos() {
        return Objects.requireNonNull(this.source, "Source slice does not exist").creationTimeNanos();
    }

    public long sliceCompressedSize() {
        return Objects.requireNonNull(this.source, "Source slice does not exist").compressedSize();
    }

    public long sliceUncompressedSize() {
        return Objects.requireNonNull(this.source, "Source slice does not exist").uncompressedSize();
    }

    public String keyspace() {
        return this.readSliceProperty(RestoreSlice::keyspace);
    }

    public String table() {
        return this.readSliceProperty(RestoreSlice::table);
    }

    public short bucketId() {
        return this.bucketId;
    }

    public String uploadId() {
        return this.uploadId;
    }

    public BigInteger startToken() {
        return this.tokenRange.startAsBigInt();
    }

    public BigInteger endToken() {
        return this.tokenRange.endAsBigInt();
    }

    public TokenRange tokenRange() {
        return this.tokenRange;
    }

    public Map<String, RestoreRangeStatus> statusByReplica() {
        return Collections.unmodifiableMap(this.statusByReplica);
    }

    public Map<String, String> statusTextByReplica() {
        HashMap<String, String> result = new HashMap<String, String>(this.statusByReplica.size());
        this.statusByReplica.forEach((k, v) -> result.put((String)k, v.name()));
        return result;
    }

    public Path stageDirectory() {
        return this.stageDirectory;
    }

    public Path stagedObjectPath() {
        return this.stagedObjectPath;
    }

    public InstanceMetadata owner() {
        return this.owner;
    }

    public boolean existsOnS3() {
        return this.existsOnS3;
    }

    public long sliceObjectLength() {
        return this.sliceObjectLength == null ? 0L : this.sliceObjectLength;
    }

    public boolean hasStaged() {
        return this.hasStaged;
    }

    public boolean hasImported() {
        return this.hasImported;
    }

    public int downloadAttempt() {
        return this.downloadAttempt;
    }

    public boolean isCancelled() {
        return this.isCancelled;
    }

    public boolean canProduceTask() {
        return this.tracker != null && this.source != null;
    }

    public long estimatedSpaceRequiredInBytes() {
        return this.sliceCompressedSize() + this.sliceUncompressedSize();
    }

    public String shortDescription() {
        return "RestoreRange{sliceId='" + this.sliceId + "', sliceKey='" + this.sliceKey() + "', sliceBucket='" + this.sliceBucket() + "'}";
    }

    @VisibleForTesting
    public RestoreJobProgressTracker trackerUnsafe() {
        return this.tracker;
    }

    @Nullable
    private <T> T readSliceProperty(Function<RestoreSlice, T> func) {
        if (this.source == null) {
            return null;
        }
        return func.apply(this.source);
    }

    private void updateRangeStatusForInstance(InstanceMetadata instance, RestoreRangeStatus status) {
        if (!this.job().isManagedBySidecar()) {
            return;
        }
        this.statusByReplica.put(this.storageAddressWithPort(instance), status);
    }

    private String storageAddressWithPort(InstanceMetadata instance) throws CassandraUnavailableException {
        InetSocketAddress storageAddress = instance.delegate().localStorageBroadcastAddress();
        return StringUtils.cassandraFormattedHostAndPort((InetSocketAddress)storageAddress);
    }

    public static class Builder
    implements DataObjectBuilder<Builder, RestoreRange> {
        private UUID jobId;
        private short bucketId;
        private BigInteger startToken;
        private BigInteger endToken;
        private RestoreSlice sourceSlice;
        private String sliceId;
        private String sliceKey;
        private String sliceBucket;
        private InstanceMetadata owner;
        private Path stageDirectory;
        private Path stagedObjectPath;
        private String uploadId;
        private Map<String, RestoreRangeStatus> statusByReplica = Collections.emptyMap();
        private RestoreJobProgressTracker tracker = null;
        private boolean discarded;

        private Builder() {
        }

        private Builder(RestoreRange range) {
            this.jobId = range.jobId;
            this.bucketId = range.bucketId;
            this.sourceSlice = range.source;
            this.sliceId = range.sliceId;
            this.sliceKey = range.sliceKey;
            this.sliceBucket = range.sliceBucket;
            this.stageDirectory = range.stageDirectory;
            this.uploadId = range.uploadId;
            this.owner = range.owner;
            this.startToken = range.tokenRange.startAsBigInt();
            this.endToken = range.tokenRange.endAsBigInt();
            this.statusByReplica = new HashMap<String, RestoreRangeStatus>(range.statusByReplica);
            this.tracker = range.tracker;
            this.discarded = range.discarded;
        }

        public Builder jobId(UUID jobId) {
            return (Builder)this.update(b -> {
                b.jobId = jobId;
            });
        }

        public Builder bucketId(short bucketId) {
            return (Builder)this.update(b -> {
                b.bucketId = bucketId;
            });
        }

        public Builder sourceSlice(RestoreSlice sourceSlice) {
            return ((Builder)this.update(b -> {
                b.sourceSlice = sourceSlice;
            })).jobId(sourceSlice.jobId()).sliceId(sourceSlice.sliceId()).sliceBucket(sourceSlice.bucket()).sliceKey(sourceSlice.key()).bucketId(sourceSlice.bucketId()).startToken(sourceSlice.startToken()).endToken(sourceSlice.endToken());
        }

        public Builder sliceId(String sliceId) {
            return (Builder)this.update(b -> {
                b.sliceId = sliceId;
            });
        }

        public Builder sliceBucket(String sliceBucket) {
            return (Builder)this.update(b -> {
                b.sliceBucket = sliceBucket;
            });
        }

        public Builder sliceKey(String sliceKey) {
            return (Builder)this.update(b -> {
                b.sliceKey = sliceKey;
            });
        }

        public Builder stageDirectory(Path basePath, String uploadId) {
            return (Builder)this.update(b -> {
                b.stageDirectory = basePath.resolve(uploadId);
                b.uploadId = uploadId;
            });
        }

        public Builder ownerInstance(InstanceMetadata owner) {
            return (Builder)this.update(b -> {
                b.owner = owner;
            });
        }

        public Builder startToken(BigInteger startToken) {
            return (Builder)this.update(b -> {
                b.startToken = startToken;
            });
        }

        public Builder endToken(BigInteger endToken) {
            return (Builder)this.update(b -> {
                b.endToken = endToken;
            });
        }

        public Builder replicaStatus(Map<String, RestoreRangeStatus> statusByReplica) {
            return (Builder)this.update(b -> {
                b.statusByReplica = new HashMap<String, RestoreRangeStatus>(statusByReplica);
            });
        }

        public Builder replicaStatusText(Map<String, String> statusTextByReplica) {
            HashMap<String, RestoreRangeStatus> map = new HashMap<String, RestoreRangeStatus>(statusTextByReplica.size());
            statusTextByReplica.forEach((k, v) -> map.put((String)k, RestoreRangeStatus.valueOf((String)v)));
            return this.replicaStatus(map);
        }

        public Builder restoreJobProgressTracker(RestoreJobProgressTracker tracker) {
            return (Builder)this.update(b -> {
                b.tracker = tracker;
            });
        }

        public RestoreRange build() {
            if (this.sourceSlice != null) {
                this.stagedObjectPath = this.stageDirectory.resolve(this.sourceSlice.key());
            }
            return new RestoreRange(this);
        }

        public Builder self() {
            return this;
        }

        @VisibleForTesting
        public Builder unsetSourceSlice() {
            return (Builder)this.update(b -> {
                b.sourceSlice = null;
            });
        }
    }
}

