/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.sidecar.db;

import com.datastax.driver.core.BatchStatement;
import com.datastax.driver.core.BoundStatement;
import com.datastax.driver.core.LocalDate;
import com.datastax.driver.core.ResultSet;
import com.datastax.driver.core.Row;
import com.datastax.driver.core.Statement;
import com.datastax.driver.core.utils.UUIDs;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Preconditions;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import org.apache.cassandra.sidecar.common.data.RestoreJobSecrets;
import org.apache.cassandra.sidecar.common.data.RestoreJobStatus;
import org.apache.cassandra.sidecar.common.request.data.CreateRestoreJobRequestPayload;
import org.apache.cassandra.sidecar.common.request.data.UpdateRestoreJobRequestPayload;
import org.apache.cassandra.sidecar.common.server.CQLSessionProvider;
import org.apache.cassandra.sidecar.common.server.data.QualifiedTableName;
import org.apache.cassandra.sidecar.db.DataObjectMappingException;
import org.apache.cassandra.sidecar.db.DatabaseAccessor;
import org.apache.cassandra.sidecar.db.RestoreJob;
import org.apache.cassandra.sidecar.db.schema.RestoreJobsSchema;
import org.apache.cassandra.sidecar.db.schema.SidecarSchema;
import org.apache.cassandra.sidecar.db.schema.TableSchema;
import org.jetbrains.annotations.Nullable;

@Singleton
public class RestoreJobDatabaseAccessor
extends DatabaseAccessor<RestoreJobsSchema> {
    private static final ObjectMapper MAPPER = new ObjectMapper();
    private static final long ONE_DAY_MILLISECONDS = TimeUnit.DAYS.toMillis(1L);
    public final SidecarSchema sidecarSchema;

    @Inject
    public RestoreJobDatabaseAccessor(SidecarSchema sidecarSchema, RestoreJobsSchema restoreJobsSchema, CQLSessionProvider cqlSessionProvider) {
        super((TableSchema)restoreJobsSchema, cqlSessionProvider);
        this.sidecarSchema = sidecarSchema;
    }

    public RestoreJob create(CreateRestoreJobRequestPayload payload, QualifiedTableName qualifiedTableName) throws DataObjectMappingException {
        this.sidecarSchema.ensureInitialized();
        UUID jobIdFromRequest = payload.jobId();
        UUID jobId = jobIdFromRequest == null ? UUIDs.timeBased() : jobIdFromRequest;
        RestoreJob job = RestoreJob.builder().createdAt(RestoreJob.toLocalDate(jobId)).jobId(jobId).keyspace(qualifiedTableName.keyspace()).table(qualifiedTableName.tableName()).jobAgent(payload.jobAgent()).jobStatus(RestoreJobStatus.CREATED).jobSecrets(payload.secrets()).sstableImportOptions(payload.importOptions()).expireAt(payload.expireAtAsDate()).consistencyLevel(payload.consistencyConfig().consistencyLevel).localDatacenter(payload.consistencyConfig().localDatacenter).build();
        ByteBuffer secrets = RestoreJobDatabaseAccessor.serializeValue(job.secrets, "secrets");
        ByteBuffer importOptions = RestoreJobDatabaseAccessor.serializeValue(job.importOptions, "sstable import options");
        BoundStatement statement = ((RestoreJobsSchema)this.tableSchema).insertJob().bind(new Object[]{job.createdAt, job.jobId, job.keyspaceName, job.tableName, job.jobAgent, job.status.name(), secrets, importOptions, job.consistencyLevelText(), job.localDatacenter, job.expireAt});
        this.execute((Statement)statement);
        return job;
    }

    public RestoreJob update(UpdateRestoreJobRequestPayload payload, UUID jobId) throws DataObjectMappingException {
        this.sidecarSchema.ensureInitialized();
        RestoreJob.Builder updateBuilder = RestoreJob.builder();
        LocalDate createdAt = RestoreJob.toLocalDate(jobId);
        updateBuilder.createdAt(createdAt).jobId(jobId);
        RestoreJobSecrets secrets = payload.secrets();
        RestoreJobStatus status = payload.status();
        String jobAgent = payload.jobAgent();
        Date expireAt = payload.expireAtAsDate();
        Long sliceCount = payload.sliceCount();
        BatchStatement batchStatement = new BatchStatement(BatchStatement.Type.UNLOGGED);
        if (secrets != null) {
            try {
                byte[] secretBytes = MAPPER.writeValueAsBytes((Object)secrets);
                ByteBuffer wrappedSecrets = ByteBuffer.wrap(secretBytes);
                batchStatement.add((Statement)((RestoreJobsSchema)this.tableSchema).updateBlobSecrets().bind(new Object[]{createdAt, jobId, wrappedSecrets}));
            }
            catch (JsonProcessingException e) {
                throw new DataObjectMappingException("Failed to serialize secrets", (Throwable)e);
            }
            updateBuilder.jobSecrets(secrets);
        }
        if (status != null) {
            batchStatement.add((Statement)((RestoreJobsSchema)this.tableSchema).updateStatus().bind(new Object[]{createdAt, jobId, status.name()}));
            updateBuilder.jobStatus(status);
        }
        if (jobAgent != null) {
            batchStatement.add((Statement)((RestoreJobsSchema)this.tableSchema).updateJobAgent().bind(new Object[]{createdAt, jobId, jobAgent}));
            updateBuilder.jobAgent(jobAgent);
        }
        if (expireAt != null) {
            batchStatement.add((Statement)((RestoreJobsSchema)this.tableSchema).updateExpireAt().bind(new Object[]{createdAt, jobId, expireAt}));
            updateBuilder.expireAt(expireAt);
        }
        if (sliceCount != null) {
            batchStatement.add((Statement)((RestoreJobsSchema)this.tableSchema).updateSliceCount().bind(new Object[]{createdAt, jobId, sliceCount}));
            updateBuilder.sliceCount(sliceCount);
        }
        this.execute((Statement)batchStatement);
        return updateBuilder.build();
    }

    public void abort(UUID jobId, @Nullable String reason) {
        this.sidecarSchema.ensureInitialized();
        LocalDate createdAt = RestoreJob.toLocalDate(jobId);
        Object status = RestoreJobStatus.ABORTED.name();
        if (reason != null) {
            status = (String)status + ": " + reason;
        }
        BoundStatement statement = ((RestoreJobsSchema)this.tableSchema).updateStatus().bind(new Object[]{createdAt, jobId, status});
        this.execute((Statement)statement);
    }

    public RestoreJob find(UUID jobId) {
        this.sidecarSchema.ensureInitialized();
        BoundStatement statement = ((RestoreJobsSchema)this.tableSchema).selectJob().bind(new Object[]{RestoreJob.toLocalDate(jobId), jobId});
        ResultSet resultSet = this.execute((Statement)statement);
        Row row = resultSet.one();
        if (row == null) {
            return null;
        }
        return RestoreJob.from(row);
    }

    public boolean exists(UUID jobId) {
        return this.find(jobId) != null;
    }

    public List<RestoreJob> findAllByCreationDate(LocalDate date) {
        this.sidecarSchema.ensureInitialized();
        BoundStatement statement = ((RestoreJobsSchema)this.tableSchema).findAllByCreatedAt().bind(new Object[]{date});
        ResultSet resultSet = this.execute((Statement)statement);
        ArrayList<RestoreJob> result = new ArrayList<RestoreJob>();
        for (Row row : resultSet) {
            if (resultSet.getAvailableWithoutFetching() == 100 && !resultSet.isFullyFetched()) {
                resultSet.fetchMoreResults();
            }
            result.add(RestoreJob.from(row));
        }
        return result;
    }

    public List<RestoreJob> findAllRecent(long referenceTimestampMillis, int days) {
        Preconditions.checkArgument((days >= 0 ? 1 : 0) != 0, (Object)"Input days cannot be negative. We can only look up the created jobs");
        if (days > 10) {
            this.logger.warn("Potentially collecting too many restore jobs. numberOfRecentDays={}", (Object)days);
        }
        int actualDays = days + 1;
        ArrayList<RestoreJob> result = new ArrayList<RestoreJob>();
        for (int i = actualDays; i >= 0; --i) {
            result.addAll(this.findAllByCreationDate(RestoreJobDatabaseAccessor.dateInPast(referenceTimestampMillis, i)));
        }
        return result;
    }

    static LocalDate dateInPast(long referenceTimestampMillis, int days) {
        long daysInMillis = (long)days * ONE_DAY_MILLISECONDS;
        return LocalDate.fromMillisSinceEpoch((long)(referenceTimestampMillis - daysInMillis));
    }

    private static <T> ByteBuffer serializeValue(T value, String type) {
        byte[] bytes;
        try {
            bytes = MAPPER.writeValueAsBytes(value);
        }
        catch (JsonProcessingException e) {
            throw new DataObjectMappingException("Failed to serialize " + type, (Throwable)e);
        }
        return ByteBuffer.wrap(bytes);
    }
}

