/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.sidecar.coordination;

import com.datastax.driver.core.KeyspaceMetadata;
import com.datastax.driver.core.Session;
import java.math.BigInteger;
import java.net.InetSocketAddress;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.cassandra.sidecar.cluster.CassandraAdapterDelegate;
import org.apache.cassandra.sidecar.cluster.instance.InstanceMetadata;
import org.apache.cassandra.sidecar.common.response.NodeSettings;
import org.apache.cassandra.sidecar.common.response.TokenRangeReplicasResponse;
import org.apache.cassandra.sidecar.common.server.CQLSessionProvider;
import org.apache.cassandra.sidecar.common.server.StorageOperations;
import org.apache.cassandra.sidecar.common.server.data.Name;
import org.apache.cassandra.sidecar.common.server.utils.StringUtils;
import org.apache.cassandra.sidecar.config.SidecarConfiguration;
import org.apache.cassandra.sidecar.coordination.ElectorateMembership;
import org.apache.cassandra.sidecar.exceptions.CassandraUnavailableException;
import org.apache.cassandra.sidecar.utils.InstanceMetadataFetcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MostReplicatedKeyspaceTokenZeroElectorateMembership
implements ElectorateMembership {
    private static final Logger LOGGER = LoggerFactory.getLogger(MostReplicatedKeyspaceTokenZeroElectorateMembership.class);
    private final InstanceMetadataFetcher instanceMetadataFetcher;
    private final CQLSessionProvider cqlSessionProvider;
    private final SidecarConfiguration configuration;

    public MostReplicatedKeyspaceTokenZeroElectorateMembership(InstanceMetadataFetcher instanceMetadataFetcher, CQLSessionProvider cqlSessionProvider, SidecarConfiguration sidecarConfiguration) {
        this.instanceMetadataFetcher = instanceMetadataFetcher;
        this.cqlSessionProvider = cqlSessionProvider;
        this.configuration = sidecarConfiguration;
    }

    @Override
    public boolean isMember() {
        Set<String> localInstancesHostsAndPorts = this.collectLocalInstancesHostsAndPorts();
        if (localInstancesHostsAndPorts.isEmpty()) {
            return false;
        }
        String userKeyspace = this.highestReplicationFactorKeyspace();
        if (userKeyspace == null) {
            return false;
        }
        TokenRangeReplicasResponse tokenRangeReplicas = this.instanceMetadataFetcher.callOnFirstAvailableInstance(instance -> {
            CassandraAdapterDelegate delegate = instance.delegate();
            StorageOperations operations = delegate.storageOperations();
            NodeSettings nodeSettings = delegate.nodeSettings();
            return operations.tokenRangeReplicas(new Name(userKeyspace), nodeSettings.partitioner());
        });
        return this.anyInstanceOwnsTokenZero(tokenRangeReplicas, localInstancesHostsAndPorts);
    }

    Set<String> collectLocalInstancesHostsAndPorts() {
        HashSet<String> result = new HashSet<String>();
        for (InstanceMetadata instance : this.instanceMetadataFetcher.allLocalInstances()) {
            try {
                InetSocketAddress address = instance.delegate().localStorageBroadcastAddress();
                result.add(StringUtils.cassandraFormattedHostAndPort((InetSocketAddress)address));
            }
            catch (CassandraUnavailableException exception) {
                LOGGER.warn("Unable to determine local storage broadcast address for instance. instance={}", (Object)instance, (Object)exception);
            }
        }
        return result;
    }

    String highestReplicationFactorKeyspace() {
        Session activeSession;
        if (this.instanceMetadataFetcher.allLocalInstances().isEmpty()) {
            LOGGER.warn("There are no local Cassandra instances managed by this Sidecar");
            return null;
        }
        try {
            activeSession = this.cqlSessionProvider.get();
        }
        catch (CassandraUnavailableException exception) {
            LOGGER.warn("There is no active session to Cassandra");
            return null;
        }
        Set<String> forbiddenKeyspaces = this.configuration.cassandraInputValidationConfiguration().forbiddenKeyspaces();
        String sidecarKeyspaceName = this.configuration.serviceConfiguration().schemaKeyspaceConfiguration().keyspace();
        return activeSession.getCluster().getMetadata().getKeyspaces().stream().filter(keyspace -> !forbiddenKeyspaces.contains(keyspace.getName())).sorted(Comparator.comparingInt(this::aggregateReplicationFactor).reversed().thenComparing(KeyspaceMetadata::getName)).map(KeyspaceMetadata::getName).findFirst().orElse(sidecarKeyspaceName);
    }

    boolean anyInstanceOwnsTokenZero(TokenRangeReplicasResponse tokenRangeReplicas, Set<String> localInstancesHostAndPorts) {
        return tokenRangeReplicas.readReplicas().stream().filter(this::replicaOwnsTokenZero).anyMatch(replicaInfo -> {
            for (List replicas : replicaInfo.replicasByDatacenter().values()) {
                for (String replica : replicas) {
                    if (!localInstancesHostAndPorts.contains(replica)) continue;
                    return true;
                }
            }
            return false;
        });
    }

    boolean replicaOwnsTokenZero(TokenRangeReplicasResponse.ReplicaInfo replicaInfo) {
        BigInteger start = new BigInteger(replicaInfo.start());
        BigInteger end = new BigInteger(replicaInfo.end());
        return start.compareTo(BigInteger.ZERO) < 0 && end.compareTo(BigInteger.ZERO) >= 0;
    }

    int aggregateReplicationFactor(KeyspaceMetadata keyspace) {
        int replicationFactor = 0;
        for (String value : keyspace.getReplication().values()) {
            try {
                replicationFactor += Integer.parseInt(value);
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return replicationFactor;
    }
}

