/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.sidecar.config.yaml;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import com.google.common.collect.Sets;
import com.google.common.reflect.ClassPath;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.cassandra.sidecar.common.DataObjectBuilder;
import org.apache.cassandra.sidecar.common.server.utils.MillisecondBoundConfiguration;
import org.apache.cassandra.sidecar.config.AccessControlConfiguration;
import org.apache.cassandra.sidecar.config.CassandraInputValidationConfiguration;
import org.apache.cassandra.sidecar.config.DriverConfiguration;
import org.apache.cassandra.sidecar.config.InstanceConfiguration;
import org.apache.cassandra.sidecar.config.MetricsConfiguration;
import org.apache.cassandra.sidecar.config.PeriodicTaskConfiguration;
import org.apache.cassandra.sidecar.config.RestoreJobConfiguration;
import org.apache.cassandra.sidecar.config.S3ClientConfiguration;
import org.apache.cassandra.sidecar.config.SchemaReportingConfiguration;
import org.apache.cassandra.sidecar.config.ServiceConfiguration;
import org.apache.cassandra.sidecar.config.SidecarConfiguration;
import org.apache.cassandra.sidecar.config.SslConfiguration;
import org.apache.cassandra.sidecar.config.VertxConfiguration;
import org.apache.cassandra.sidecar.config.yaml.AccessControlConfigurationImpl;
import org.apache.cassandra.sidecar.config.yaml.CassandraInputValidationConfigurationImpl;
import org.apache.cassandra.sidecar.config.yaml.DriverConfigurationImpl;
import org.apache.cassandra.sidecar.config.yaml.MetricsConfigurationImpl;
import org.apache.cassandra.sidecar.config.yaml.PeriodicTaskConfigurationImpl;
import org.apache.cassandra.sidecar.config.yaml.RestoreJobConfigurationImpl;
import org.apache.cassandra.sidecar.config.yaml.S3ClientConfigurationImpl;
import org.apache.cassandra.sidecar.config.yaml.SchemaReportingConfigurationImpl;
import org.apache.cassandra.sidecar.config.yaml.ServiceConfigurationImpl;
import org.apache.cassandra.sidecar.config.yaml.VertxConfigurationImpl;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;

public class SidecarConfigurationImpl
implements SidecarConfiguration {
    @Deprecated
    @JsonProperty(value="cassandra")
    protected final InstanceConfiguration cassandraInstance;
    @JsonProperty(value="cassandra_instances")
    protected final List<InstanceConfiguration> cassandraInstances;
    @JsonProperty(value="driver_parameters")
    protected final DriverConfiguration driverConfiguration;
    @JsonProperty(value="sidecar")
    protected final ServiceConfiguration serviceConfiguration;
    @JsonProperty(value="ssl")
    protected final SslConfiguration sslConfiguration;
    @JsonProperty(value="access_control")
    protected final AccessControlConfiguration accessControlConfiguration;
    @JsonProperty(value="healthcheck")
    protected final PeriodicTaskConfiguration healthCheckConfiguration;
    @JsonProperty(value="metrics")
    protected final MetricsConfiguration metricsConfiguration;
    @JsonProperty(value="cassandra_input_validation")
    protected final CassandraInputValidationConfiguration cassandraInputValidationConfiguration;
    @JsonProperty(value="blob_restore")
    protected final RestoreJobConfiguration restoreJobConfiguration;
    @JsonProperty(value="s3_client")
    protected final S3ClientConfiguration s3ClientConfiguration;
    @JsonProperty(value="vertx")
    @Nullable
    protected final VertxConfiguration vertxConfiguration;
    @JsonProperty(value="schema_reporting")
    @NotNull
    protected final SchemaReportingConfiguration schemaReportingConfiguration;

    public SidecarConfigurationImpl() {
        this(SidecarConfigurationImpl.builder());
    }

    protected SidecarConfigurationImpl(Builder builder) {
        this.cassandraInstance = builder.cassandraInstance;
        this.cassandraInstances = builder.cassandraInstances;
        this.serviceConfiguration = builder.serviceConfiguration;
        this.sslConfiguration = builder.sslConfiguration;
        this.accessControlConfiguration = builder.accessControlConfiguration;
        this.healthCheckConfiguration = builder.healthCheckConfiguration;
        this.metricsConfiguration = builder.metricsConfiguration;
        this.cassandraInputValidationConfiguration = builder.cassandraInputValidationConfiguration;
        this.driverConfiguration = builder.driverConfiguration;
        this.restoreJobConfiguration = builder.restoreJobConfiguration;
        this.s3ClientConfiguration = builder.s3ClientConfiguration;
        this.vertxConfiguration = builder.vertxConfiguration;
        this.schemaReportingConfiguration = builder.schemaReportingConfiguration;
    }

    @Override
    @JsonProperty(value="cassandra")
    @Deprecated
    public InstanceConfiguration cassandra() {
        return this.cassandraInstance;
    }

    @Override
    @JsonProperty(value="cassandra_instances")
    public List<InstanceConfiguration> cassandraInstances() {
        if (this.cassandraInstance != null) {
            return Collections.singletonList(this.cassandraInstance);
        }
        if (this.cassandraInstances != null && !this.cassandraInstances.isEmpty()) {
            return Collections.unmodifiableList(this.cassandraInstances);
        }
        return Collections.emptyList();
    }

    @Override
    @JsonProperty(value="sidecar", required=true)
    public ServiceConfiguration serviceConfiguration() {
        return this.serviceConfiguration;
    }

    @Override
    @JsonProperty(value="ssl")
    public SslConfiguration sslConfiguration() {
        return this.sslConfiguration;
    }

    @Override
    @JsonProperty(value="access_control")
    public AccessControlConfiguration accessControlConfiguration() {
        return this.accessControlConfiguration;
    }

    @Override
    @JsonProperty(value="healthcheck")
    public PeriodicTaskConfiguration healthCheckConfiguration() {
        return this.healthCheckConfiguration;
    }

    @Override
    @JsonProperty(value="metrics")
    public MetricsConfiguration metricsConfiguration() {
        return this.metricsConfiguration;
    }

    @Override
    @JsonProperty(value="driver_parameters")
    public DriverConfiguration driverConfiguration() {
        return this.driverConfiguration;
    }

    @Override
    @JsonProperty(value="cassandra_input_validation")
    public CassandraInputValidationConfiguration cassandraInputValidationConfiguration() {
        return this.cassandraInputValidationConfiguration;
    }

    @Override
    @JsonProperty(value="blob_restore")
    public RestoreJobConfiguration restoreJobConfiguration() {
        return this.restoreJobConfiguration;
    }

    @Override
    @JsonProperty(value="s3_client")
    public S3ClientConfiguration s3ClientConfiguration() {
        return this.s3ClientConfiguration;
    }

    @Override
    @JsonProperty(value="vertx")
    @Nullable
    public VertxConfiguration vertxConfiguration() {
        return this.vertxConfiguration;
    }

    @Override
    @JsonProperty(value="schema_reporting")
    @NotNull
    public SchemaReportingConfiguration schemaReportingConfiguration() {
        return this.schemaReportingConfiguration;
    }

    public static SidecarConfigurationImpl readYamlConfiguration(String yamlConfigurationPath) throws IOException {
        try {
            return SidecarConfigurationImpl.readYamlConfiguration(Paths.get(new URI(yamlConfigurationPath)));
        }
        catch (URISyntaxException e) {
            throw new IOException("Invalid URI: " + yamlConfigurationPath, e);
        }
    }

    public static SidecarConfigurationImpl readYamlConfiguration(Path yamlConfigurationPath) throws IOException {
        ObjectMapper mapper = new ObjectMapper((JsonFactory)new YAMLFactory()).configure(DeserializationFeature.ACCEPT_SINGLE_VALUE_AS_ARRAY, true).configure(DeserializationFeature.UNWRAP_SINGLE_VALUE_ARRAYS, true).configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false).registerModule((Module)SidecarConfigurationImpl.resolveYamlTypeMappings());
        return (SidecarConfigurationImpl)mapper.readValue(yamlConfigurationPath.toFile(), SidecarConfigurationImpl.class);
    }

    @VisibleForTesting
    static SidecarConfigurationImpl fromYamlString(String yaml) throws IOException {
        ObjectMapper mapper = new ObjectMapper((JsonFactory)new YAMLFactory()).configure(DeserializationFeature.ACCEPT_SINGLE_VALUE_AS_ARRAY, true).configure(DeserializationFeature.UNWRAP_SINGLE_VALUE_ARRAYS, true).configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false).registerModule((Module)SidecarConfigurationImpl.resolveYamlTypeMappings());
        return (SidecarConfigurationImpl)mapper.readValue(yaml, SidecarConfigurationImpl.class);
    }

    private static SimpleModule resolveYamlTypeMappings() throws IOException {
        String packageName = SidecarConfigurationImpl.class.getPackage().getName();
        String outerPackageName = SidecarConfiguration.class.getPackage().getName();
        SimpleModule module = new SimpleModule();
        ClassPath path = ClassPath.from((ClassLoader)ClassLoader.getSystemClassLoader());
        Set declared = path.getTopLevelClasses(outerPackageName).stream().filter(c -> c.getName().endsWith("Configuration")).map(ClassPath.ClassInfo::load).collect(Collectors.toSet());
        HashSet implemented = new HashSet();
        ClassPath.from((ClassLoader)ClassLoader.getSystemClassLoader()).getTopLevelClasses(packageName).stream().map(ClassPath.ClassInfo::load).forEach(clazz -> {
            if (clazz.isInterface()) {
                return;
            }
            Class<?>[] interfaces = clazz.getInterfaces();
            Class<?> configurationInterface = null;
            for (Class<?> c : interfaces) {
                if (!c.getPackage().getName().equals(outerPackageName) || !c.getName().endsWith("Configuration")) continue;
                configurationInterface = c;
                if (implemented.add(configurationInterface)) break;
                throw new IllegalStateException("Multiple implementations found for configuration interface: " + configurationInterface);
            }
            if (configurationInterface == null) {
                return;
            }
            module.addAbstractTypeMapping(configurationInterface, clazz);
        });
        Sets.SetView unimplemented = Sets.difference(declared, implemented);
        if (!unimplemented.isEmpty()) {
            throw new IllegalStateException("Found unimplemented configuration class(es): " + (Set)unimplemented);
        }
        return module;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder
    implements DataObjectBuilder<Builder, SidecarConfigurationImpl> {
        private InstanceConfiguration cassandraInstance;
        private List<InstanceConfiguration> cassandraInstances;
        private ServiceConfiguration serviceConfiguration = new ServiceConfigurationImpl();
        private SslConfiguration sslConfiguration = null;
        private AccessControlConfiguration accessControlConfiguration = new AccessControlConfigurationImpl();
        private PeriodicTaskConfiguration healthCheckConfiguration = new PeriodicTaskConfigurationImpl(true, MillisecondBoundConfiguration.ZERO, MillisecondBoundConfiguration.parse((String)"30s"));
        private MetricsConfiguration metricsConfiguration = new MetricsConfigurationImpl();
        private CassandraInputValidationConfiguration cassandraInputValidationConfiguration = new CassandraInputValidationConfigurationImpl();
        private DriverConfiguration driverConfiguration = new DriverConfigurationImpl();
        private RestoreJobConfiguration restoreJobConfiguration = new RestoreJobConfigurationImpl();
        private S3ClientConfiguration s3ClientConfiguration = new S3ClientConfigurationImpl();
        private VertxConfiguration vertxConfiguration = new VertxConfigurationImpl();
        private SchemaReportingConfiguration schemaReportingConfiguration = new SchemaReportingConfigurationImpl();

        protected Builder() {
        }

        public Builder self() {
            return this;
        }

        public Builder cassandraInstance(InstanceConfiguration cassandraInstance) {
            return (Builder)this.update(b -> {
                b.cassandraInstance = cassandraInstance;
            });
        }

        public Builder cassandraInstances(List<InstanceConfiguration> cassandraInstances) {
            return (Builder)this.update(b -> {
                b.cassandraInstances = cassandraInstances;
            });
        }

        public Builder serviceConfiguration(ServiceConfiguration serviceConfiguration) {
            return (Builder)this.update(b -> {
                b.serviceConfiguration = serviceConfiguration;
            });
        }

        public Builder sslConfiguration(SslConfiguration sslConfiguration) {
            return (Builder)this.update(b -> {
                b.sslConfiguration = sslConfiguration;
            });
        }

        public Builder accessControlConfiguration(AccessControlConfiguration accessControlConfiguration) {
            return (Builder)this.update(b -> {
                b.accessControlConfiguration = accessControlConfiguration;
            });
        }

        public Builder healthCheckConfiguration(PeriodicTaskConfiguration healthCheckConfiguration) {
            return (Builder)this.update(b -> {
                b.healthCheckConfiguration = healthCheckConfiguration;
            });
        }

        public Builder metricsConfiguration(MetricsConfiguration metricsConfiguration) {
            return (Builder)this.update(b -> {
                b.metricsConfiguration = metricsConfiguration;
            });
        }

        public Builder driverConfiguration(DriverConfiguration driverConfiguration) {
            return (Builder)this.update(b -> {
                b.driverConfiguration = driverConfiguration;
            });
        }

        public Builder cassandraInputValidationConfiguration(CassandraInputValidationConfiguration configuration) {
            return (Builder)this.update(b -> {
                b.cassandraInputValidationConfiguration = configuration;
            });
        }

        public Builder restoreJobConfiguration(RestoreJobConfiguration configuration) {
            return (Builder)this.update(b -> {
                b.restoreJobConfiguration = configuration;
            });
        }

        public Builder s3ClientConfiguration(S3ClientConfiguration configuration) {
            return (Builder)this.update(b -> {
                b.s3ClientConfiguration = configuration;
            });
        }

        public Builder vertxConfiguration(VertxConfiguration configuration) {
            return (Builder)this.update(b -> {
                b.vertxConfiguration = configuration;
            });
        }

        public Builder schemaReportingConfiguration(SchemaReportingConfiguration configuration) {
            return (Builder)this.update(builder -> {
                builder.schemaReportingConfiguration = configuration;
            });
        }

        public SidecarConfigurationImpl build() {
            return new SidecarConfigurationImpl(this);
        }
    }
}

