/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.sidecar.config.yaml;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.vertx.core.http.HttpMethod;
import java.util.concurrent.TimeUnit;
import org.apache.cassandra.sidecar.common.server.utils.MillisecondBoundConfiguration;
import org.apache.cassandra.sidecar.config.SchemaReportingConfiguration;
import org.apache.cassandra.sidecar.config.yaml.PeriodicTaskConfigurationImpl;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SchemaReportingConfigurationImpl
extends PeriodicTaskConfigurationImpl
implements SchemaReportingConfiguration {
    protected static final boolean DEFAULT_ENABLED = false;
    protected static final MillisecondBoundConfiguration DEFAULT_DELAY = new MillisecondBoundConfiguration(6L, TimeUnit.HOURS);
    protected static final MillisecondBoundConfiguration DEFAULT_INTERVAL = new MillisecondBoundConfiguration(12L, TimeUnit.HOURS);
    protected static final String DEFAULT_ENDPOINT = null;
    protected static final String DEFAULT_METHOD = HttpMethod.PUT.name();
    protected static final int DEFAULT_RETRIES = 3;
    @JsonProperty(value="endpoint")
    @Nullable
    protected final String endpoint;
    @JsonProperty(value="method")
    @Nullable
    protected final String method;
    @JsonProperty(value="retries")
    protected final int retries;

    public SchemaReportingConfigurationImpl() {
        this(false, DEFAULT_DELAY, DEFAULT_INTERVAL, DEFAULT_ENDPOINT, DEFAULT_METHOD, 3);
    }

    public SchemaReportingConfigurationImpl(boolean enabled, @NotNull MillisecondBoundConfiguration delay, @NotNull MillisecondBoundConfiguration interval, @Nullable String endpoint, @Nullable String method, int retries) {
        super(enabled, delay, interval);
        this.endpoint = endpoint;
        this.method = method;
        this.retries = retries;
    }

    @Override
    @Nullable
    public String endpoint() {
        return this.endpoint;
    }

    @Override
    @Nullable
    public HttpMethod method() {
        return this.method != null ? HttpMethod.valueOf((String)this.method) : null;
    }

    @Override
    public int retries() {
        return this.retries;
    }
}

