/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.sidecar.config.yaml;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.vertx.core.file.FileSystemOptions;
import org.apache.cassandra.sidecar.config.FileSystemOptionsConfiguration;

public class FileSystemOptionsConfigurationImpl
implements FileSystemOptionsConfiguration {
    @JsonProperty(value="classpath_resolving_enabled")
    private final boolean classpathResolvingEnabled;
    private String fileCacheDir;
    @JsonProperty(value="file_caching_enabled")
    private final boolean fileCachingEnabled;
    public static final boolean DEFAULT_CLASSPATH_RESOLVING_ENABLED = false;
    public static final boolean DEFAULT_FILE_CACHING_ENABLED = false;

    public FileSystemOptionsConfigurationImpl() {
        this(false, FileSystemOptions.DEFAULT_FILE_CACHING_DIR, false);
    }

    public FileSystemOptionsConfigurationImpl(boolean classpathResolvingEnabled, String fileCacheDir, boolean fileCachingEnabled) {
        this.classpathResolvingEnabled = classpathResolvingEnabled;
        this.fileCachingEnabled = fileCachingEnabled;
        this.setFileCacheDir(fileCacheDir);
    }

    @Override
    @JsonProperty(value="classpath_resolving_enabled")
    public boolean classpathResolvingEnabled() {
        return this.classpathResolvingEnabled;
    }

    @Override
    @JsonProperty(value="file_cache_dir")
    public String fileCacheDir() {
        return this.fileCacheDir;
    }

    @JsonProperty(value="file_cache_dir")
    public void setFileCacheDir(String fileCacheDir) {
        this.fileCacheDir = fileCacheDir == null || fileCacheDir.isEmpty() ? FileSystemOptions.DEFAULT_FILE_CACHING_DIR : fileCacheDir;
    }

    @Override
    @JsonProperty(value="file_caching_enabled")
    public boolean fileCachingEnabled() {
        return this.fileCachingEnabled;
    }
}

