/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.sidecar.config.yaml;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.concurrent.TimeUnit;
import org.apache.cassandra.sidecar.common.server.utils.SecondBoundConfiguration;
import org.apache.cassandra.sidecar.config.CdcConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CdcConfigurationImpl
implements CdcConfiguration {
    private static final Logger LOGGER = LoggerFactory.getLogger(CdcConfigurationImpl.class);
    public static final String SEGMENT_HARD_LINK_CACHE_EXPIRY_PROPERTY = "segment_hardlink_cache_expiry";
    public static final SecondBoundConfiguration DEFAULT_SEGMENT_HARD_LINK_CACHE_EXPIRY = SecondBoundConfiguration.parse((String)"5m");
    protected SecondBoundConfiguration segmentHardLinkCacheExpiry;

    public CdcConfigurationImpl() {
        this.segmentHardLinkCacheExpiry = DEFAULT_SEGMENT_HARD_LINK_CACHE_EXPIRY;
    }

    public CdcConfigurationImpl(SecondBoundConfiguration segmentHardLinkCacheExpiry) {
        this.segmentHardLinkCacheExpiry = segmentHardLinkCacheExpiry;
    }

    @Override
    @JsonProperty(value="segment_hardlink_cache_expiry")
    public SecondBoundConfiguration segmentHardLinkCacheExpiry() {
        return this.segmentHardLinkCacheExpiry;
    }

    @JsonProperty(value="segment_hardlink_cache_expiry")
    public void setSegmentHardLinkCacheExpiry(SecondBoundConfiguration segmentHardlinkCacheExpiry) {
        this.segmentHardLinkCacheExpiry = segmentHardlinkCacheExpiry;
    }

    @JsonProperty(value="segment_hardlink_cache_expiry_in_secs")
    @Deprecated
    public void setSegmentHardLinkCacheExpiryInSecs(long segmentHardlinkCacheExpiryInSecs) {
        LOGGER.warn("'segment_hardlink_cache_expiry_in_secs' is deprecated, use 'segment_hardlink_cache_expiry' instead");
        this.setSegmentHardLinkCacheExpiry(new SecondBoundConfiguration(segmentHardlinkCacheExpiryInSecs, TimeUnit.SECONDS));
    }
}

