/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.sidecar.cluster.locator;

import com.datastax.driver.core.Host;
import com.datastax.driver.core.KeyspaceMetadata;
import com.datastax.driver.core.Metadata;
import com.datastax.driver.core.TokenRange;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;
import org.apache.cassandra.sidecar.cluster.InstancesMetadata;
import org.apache.cassandra.sidecar.cluster.instance.InstanceMetadata;
import org.apache.cassandra.sidecar.cluster.locator.LocalTokenRangesProvider;
import org.apache.cassandra.sidecar.common.server.dns.DnsResolver;
import org.apache.cassandra.sidecar.exceptions.CassandraUnavailableException;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CachedLocalTokenRanges
implements LocalTokenRangesProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(CachedLocalTokenRanges.class);
    private final InstancesMetadata instancesMetadata;
    private final DnsResolver dnsResolver;
    @GuardedBy(value="this")
    private Set<Integer> localInstanceIdsCache;
    @GuardedBy(value="this")
    private Set<Host> allInstancesCache;
    @GuardedBy(value="this")
    private Set<Host> localInstancesCache;
    @GuardedBy(value="this")
    private ImmutableMap<String, Map<Integer, Set<org.apache.cassandra.sidecar.common.server.cluster.locator.TokenRange>>> localTokenRangesCache;

    public CachedLocalTokenRanges(InstancesMetadata instancesMetadata, DnsResolver dnsResolver) {
        this.instancesMetadata = instancesMetadata;
        this.dnsResolver = dnsResolver;
        this.localTokenRangesCache = null;
        this.localInstanceIdsCache = null;
        this.allInstancesCache = null;
        this.localInstancesCache = null;
    }

    @Override
    public Map<Integer, Set<org.apache.cassandra.sidecar.common.server.cluster.locator.TokenRange>> localTokenRanges(String keyspace, boolean forceRefresh) {
        Metadata metadata;
        List<InstanceMetadata> localInstances = this.instancesMetadata.instances();
        if (localInstances.isEmpty()) {
            LOGGER.warn("No local instances found");
            return Collections.emptyMap();
        }
        try {
            metadata = localInstances.get(0).delegate().metadata();
        }
        catch (CassandraUnavailableException ignored) {
            LOGGER.debug("Not yet connect to Cassandra cluster");
            return Collections.emptyMap();
        }
        if (metadata.getKeyspace(keyspace) == null) {
            throw new NoSuchElementException("Keyspace does not exist. keyspace: " + keyspace);
        }
        Set<Integer> localInstanceIds = localInstances.stream().map(InstanceMetadata::id).collect(Collectors.toSet());
        Set allInstances = metadata.getAllHosts();
        return this.getCacheOrReload(metadata, keyspace, localInstanceIds, localInstances, allInstances);
    }

    @Nullable
    private Pair<Host, Set<org.apache.cassandra.sidecar.common.server.cluster.locator.TokenRange>> tokenRangesOfHost(Metadata metadata, String keyspace, InstanceMetadata instance, Map<IpAddressAndPort, Host> allHosts) {
        Host host;
        try {
            IpAddressAndPort ip = IpAddressAndPort.of(this.dnsResolver.resolve(instance.host()), instance.port());
            host = allHosts.get(ip);
            if (host == null) {
                LOGGER.warn("Could not map InstanceMetadata to Host host={} port={} ip={}", new Object[]{instance.host(), instance.port(), ip.ipAddress});
                return null;
            }
        }
        catch (UnknownHostException e) {
            throw new RuntimeException("Failed to resolve hostname to ip. hostname: " + instance.host(), e);
        }
        return Pair.of((Object)host, this.tokenRangesOfHost(metadata, keyspace, host));
    }

    public Set<org.apache.cassandra.sidecar.common.server.cluster.locator.TokenRange> tokenRangesOfHost(Metadata metadata, String keyspace, Host host) {
        return metadata.getTokenRanges(keyspace, host).stream().flatMap(range -> org.apache.cassandra.sidecar.common.server.cluster.locator.TokenRange.from((TokenRange)range).stream()).collect(Collectors.toSet());
    }

    private synchronized Map<Integer, Set<org.apache.cassandra.sidecar.common.server.cluster.locator.TokenRange>> getCacheOrReload(Metadata metadata, String keyspace, Set<Integer> localInstanceIds, List<InstanceMetadata> localInstances, Set<Host> allInstances) {
        boolean isClusterTheSame;
        boolean bl = isClusterTheSame = allInstances.equals(this.allInstancesCache) && localInstanceIds.equals(this.localInstanceIdsCache);
        if (this.localTokenRangesCache != null && this.localTokenRangesCache.containsKey((Object)keyspace) && isClusterTheSame) {
            return (Map)this.localTokenRangesCache.getOrDefault((Object)keyspace, Collections.emptyMap());
        }
        this.localInstanceIdsCache = localInstanceIds;
        this.allInstancesCache = allInstances;
        if (allInstances.isEmpty()) {
            LOGGER.warn("No instances found in client session");
        }
        HashMap<IpAddressAndPort, Host> allHosts = new HashMap<IpAddressAndPort, Host>(this.allInstancesCache.size());
        BiConsumer<InetSocketAddress, Host> putNullSafe = (endpoint, host) -> {
            if (endpoint != null) {
                allHosts.put(IpAddressAndPort.of(endpoint), (Host)host);
            }
        };
        for (Host host2 : this.allInstancesCache) {
            putNullSafe.accept(host2.getSocketAddress(), host2);
            putNullSafe.accept(host2.getListenSocketAddress(), host2);
            putNullSafe.accept(host2.getBroadcastSocketAddress(), host2);
        }
        ImmutableMap.Builder perKeyspaceBuilder = ImmutableMap.builder();
        ImmutableSet.Builder hostBuilder = ImmutableSet.builder();
        if (isClusterTheSame && this.localInstancesCache != null) {
            hostBuilder.addAll(this.localInstancesCache);
        }
        for (KeyspaceMetadata ks : metadata.getKeyspaces()) {
            if (isClusterTheSame && this.localTokenRangesCache != null && this.localTokenRangesCache.containsKey((Object)ks.getName())) {
                perKeyspaceBuilder.put((Object)ks.getName(), (Object)((Map)this.localTokenRangesCache.get((Object)ks.getName())));
                continue;
            }
            ImmutableMap.Builder resultBuilder = ImmutableMap.builder();
            for (InstanceMetadata instance : localInstances) {
                Pair<Host, Set<org.apache.cassandra.sidecar.common.server.cluster.locator.TokenRange>> pair = this.tokenRangesOfHost(metadata, keyspace, instance, allHosts);
                if (pair == null) continue;
                hostBuilder.add((Object)((Host)pair.getKey()));
                resultBuilder.put((Object)instance.id(), Collections.unmodifiableSet((Set)pair.getValue()));
            }
            perKeyspaceBuilder.put((Object)ks.getName(), (Object)resultBuilder.build());
        }
        this.localTokenRangesCache = perKeyspaceBuilder.build();
        this.localInstancesCache = hostBuilder.build();
        if (this.localInstancesCache.isEmpty()) {
            LOGGER.warn("Unable to determine local instances from client meta-data!");
        }
        return (Map)this.localTokenRangesCache.getOrDefault((Object)keyspace, Collections.emptyMap());
    }

    private static class IpAddressAndPort {
        final String ipAddress;
        final int port;

        static IpAddressAndPort of(@NotNull InetSocketAddress endpoint) {
            return IpAddressAndPort.of(endpoint.getAddress().getHostAddress(), endpoint.getPort());
        }

        static IpAddressAndPort of(String ipAddress, int port) {
            return new IpAddressAndPort(ipAddress, port);
        }

        IpAddressAndPort(String ipAddress, int port) {
            this.ipAddress = ipAddress;
            this.port = port;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            IpAddressAndPort that = (IpAddressAndPort)o;
            return this.port == that.port && Objects.equals(this.ipAddress, that.ipAddress);
        }

        public int hashCode() {
            return Objects.hash(this.ipAddress, this.port);
        }
    }
}

