/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.sidecar.cluster.instance;

import com.codahale.metrics.MetricRegistry;
import java.io.File;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.cassandra.sidecar.cluster.CassandraAdapterDelegate;
import org.apache.cassandra.sidecar.cluster.instance.InstanceMetadata;
import org.apache.cassandra.sidecar.common.DataObjectBuilder;
import org.apache.cassandra.sidecar.common.server.dns.DnsResolver;
import org.apache.cassandra.sidecar.common.utils.Preconditions;
import org.apache.cassandra.sidecar.exceptions.CassandraUnavailableException;
import org.apache.cassandra.sidecar.exceptions.ConfigurationException;
import org.apache.cassandra.sidecar.metrics.instance.InstanceMetrics;
import org.apache.cassandra.sidecar.metrics.instance.InstanceMetricsImpl;
import org.apache.cassandra.sidecar.utils.FileUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InstanceMetadataImpl
implements InstanceMetadata {
    private static final String DEFAULT_CDC_RAW_DIR = "cdc_raw";
    private static final String DEFAULT_COMMITLOG_DIR = "commitlog";
    private static final String DEFAULT_HINTS_DIR = "hints";
    private static final String DEFAULT_SAVED_CACHES_DIR = "saved_caches";
    private final int id;
    private final String host;
    private final int port;
    private final List<String> dataDirs;
    private final String stagingDir;
    @Nullable
    private final String cdcDir;
    private final String commitlogDir;
    private final String hintsDir;
    private final String savedCachesDir;
    private final String localSystemDataFileDir;
    @Nullable
    private final CassandraAdapterDelegate delegate;
    private final InstanceMetrics metrics;
    private final DnsResolver dnsResolver;
    private volatile String ipAddress;

    protected InstanceMetadataImpl(Builder builder) {
        this.id = builder.id;
        this.host = builder.host;
        this.dnsResolver = builder.dnsResolver;
        this.ipAddress = builder.ipAddress;
        this.port = builder.port;
        this.delegate = builder.delegate;
        this.metrics = builder.metrics;
        this.stagingDir = FileUtils.maybeResolveHomeDirectory(builder.stagingDir);
        this.dataDirs = builder.resolveDataDirectories();
        this.commitlogDir = builder.resolveCommitlogDir();
        this.cdcDir = builder.resolveCdcDir();
        this.hintsDir = builder.resolveHintsDir();
        this.savedCachesDir = builder.resolveSavedCachesDir();
        this.localSystemDataFileDir = FileUtils.maybeResolveHomeDirectory(builder.localSystemDataFileDir);
    }

    @Override
    public int id() {
        return this.id;
    }

    @Override
    public String host() {
        return this.host;
    }

    @Override
    @Nullable
    public String ipAddress() {
        return this.ipAddress;
    }

    @Override
    public String refreshIpAddress() throws UnknownHostException {
        this.ipAddress = this.dnsResolver.resolve(this.host);
        return this.ipAddress;
    }

    @Override
    public int port() {
        return this.port;
    }

    @Override
    @NotNull
    public List<String> dataDirs() {
        return this.dataDirs;
    }

    @Override
    public String stagingDir() {
        return this.stagingDir;
    }

    @Override
    @Nullable
    public String cdcDir() {
        return this.cdcDir;
    }

    @Override
    @NotNull
    public CassandraAdapterDelegate delegate() throws CassandraUnavailableException {
        if (this.delegate == null) {
            throw new CassandraUnavailableException(CassandraUnavailableException.Service.CQL_AND_JMX, "CassandraAdapterDelegate is null");
        }
        return this.delegate;
    }

    @Override
    @NotNull
    public String commitlogDir() {
        return this.commitlogDir;
    }

    @Override
    @NotNull
    public String hintsDir() {
        return this.hintsDir;
    }

    @Override
    @NotNull
    public String savedCachesDir() {
        return this.savedCachesDir;
    }

    @Override
    @Nullable
    public String localSystemDataFileDir() {
        return this.localSystemDataFileDir;
    }

    @Override
    @NotNull
    public InstanceMetrics metrics() {
        return this.metrics;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        return "InstanceMetadataImpl{id=" + this.id + ", host='" + this.host + "', port=" + this.port + "}";
    }

    public static class Builder
    implements DataObjectBuilder<Builder, InstanceMetadataImpl> {
        protected DnsResolver dnsResolver;
        protected Integer id;
        protected String host;
        protected String ipAddress;
        protected int port;
        protected String storageDir;
        protected List<String> dataDirs;
        protected String stagingDir;
        protected String cdcDir;
        protected String commitlogDir;
        protected String hintsDir;
        protected String savedCachesDir;
        protected String localSystemDataFileDir;
        protected CassandraAdapterDelegate delegate;
        protected MetricRegistry metricRegistry;
        protected InstanceMetrics metrics;

        protected Builder() {
        }

        protected Builder(InstanceMetadataImpl instanceMetadata) {
            this.id = instanceMetadata.id;
            this.host = instanceMetadata.host;
            this.ipAddress = instanceMetadata.ipAddress;
            this.port = instanceMetadata.port;
            this.dataDirs = new ArrayList<String>(instanceMetadata.dataDirs);
            this.stagingDir = instanceMetadata.stagingDir;
            this.cdcDir = instanceMetadata.cdcDir;
            this.commitlogDir = instanceMetadata.commitlogDir;
            this.hintsDir = instanceMetadata.hintsDir;
            this.savedCachesDir = instanceMetadata.savedCachesDir;
            this.localSystemDataFileDir = instanceMetadata.localSystemDataFileDir;
            this.delegate = instanceMetadata.delegate;
            this.metrics = instanceMetadata.metrics;
        }

        public Builder self() {
            return this;
        }

        public Builder id(int id) {
            return (Builder)this.update(b -> {
                b.id = id;
            });
        }

        public Builder host(String host) {
            return this.host(host, DnsResolver.DEFAULT);
        }

        public Builder host(String host, DnsResolver dnsResolver) {
            return (Builder)this.update(b -> {
                b.host = host;
                b.dnsResolver = dnsResolver;
            });
        }

        public Builder port(int port) {
            return (Builder)this.update(b -> {
                b.port = port;
            });
        }

        public Builder storageDir(String storageDir) {
            return (Builder)this.update(b -> {
                b.storageDir = storageDir;
            });
        }

        public Builder dataDirs(List<String> dataDirs) {
            return (Builder)this.update(b -> {
                b.dataDirs = dataDirs;
            });
        }

        public Builder stagingDir(String stagingDir) {
            return (Builder)this.update(b -> {
                b.stagingDir = stagingDir;
            });
        }

        public Builder cdcDir(String cdcDir) {
            return (Builder)this.update(b -> {
                b.cdcDir = cdcDir;
            });
        }

        public Builder commitlogDir(String commitlogDir) {
            return (Builder)this.update(b -> {
                b.commitlogDir = commitlogDir;
            });
        }

        public Builder hintsDir(String hintsDir) {
            return (Builder)this.update(b -> {
                b.hintsDir = hintsDir;
            });
        }

        public Builder savedCachesDir(String savedCachesDir) {
            return (Builder)this.update(b -> {
                b.savedCachesDir = savedCachesDir;
            });
        }

        public Builder localSystemDataFileDir(String localSystemDataFileDir) {
            return (Builder)this.update(b -> {
                b.localSystemDataFileDir = localSystemDataFileDir;
            });
        }

        public Builder delegate(CassandraAdapterDelegate delegate) {
            return (Builder)this.update(b -> {
                b.delegate = delegate;
            });
        }

        public Builder metricRegistry(MetricRegistry metricRegistry) {
            return (Builder)this.update(b -> {
                b.metricRegistry = metricRegistry;
            });
        }

        public InstanceMetadataImpl build() {
            Objects.requireNonNull(this.id);
            Objects.requireNonNull(this.metricRegistry);
            if (this.storageDir == null) {
                Objects.requireNonNull(this.dataDirs, "dataDirs are required when storageDir is not configured");
                Preconditions.checkArgument((!this.dataDirs.isEmpty() ? 1 : 0) != 0, (String)"dataDirs are required when storageDir is not configured");
                Objects.requireNonNull(this.commitlogDir, "commitlogDir is required when storageDir is not configured");
                Objects.requireNonNull(this.hintsDir, "hintsDir is required when storageDir is not configured");
                Objects.requireNonNull(this.savedCachesDir, "savedCachesDir is required when storageDir is not configured");
            }
            this.metrics = new InstanceMetricsImpl(this.metricRegistry);
            return new InstanceMetadataImpl(this);
        }

        public List<String> resolveDataDirectories() {
            if (this.dataDirs != null && !this.dataDirs.isEmpty()) {
                return this.dataDirs.stream().map(FileUtils::maybeResolveHomeDirectory).filter(dataDir -> dataDir != null && !dataDir.isEmpty()).collect(Collectors.collectingAndThen(Collectors.toList(), Collections::unmodifiableList));
            }
            return Collections.singletonList(this.storageDirWithErrorMessage("data_file_directories") + File.separatorChar + "data");
        }

        public String resolveCommitlogDir() {
            return this.commitlogDir != null ? FileUtils.maybeResolveHomeDirectory(this.commitlogDir) : this.storageDirFor(InstanceMetadataImpl.DEFAULT_COMMITLOG_DIR);
        }

        public String resolveHintsDir() {
            return this.hintsDir != null ? FileUtils.maybeResolveHomeDirectory(this.hintsDir) : this.storageDirFor(InstanceMetadataImpl.DEFAULT_HINTS_DIR);
        }

        public String resolveSavedCachesDir() {
            return this.savedCachesDir != null ? FileUtils.maybeResolveHomeDirectory(this.savedCachesDir) : this.storageDirFor(InstanceMetadataImpl.DEFAULT_SAVED_CACHES_DIR);
        }

        public String resolveCdcDir() {
            if (this.cdcDir != null) {
                return FileUtils.maybeResolveHomeDirectory(this.cdcDir);
            }
            if (this.storageDir != null) {
                return this.storageDirFor(InstanceMetadataImpl.DEFAULT_CDC_RAW_DIR);
            }
            return null;
        }

        private String storageDirFor(String type) {
            return this.storageDirWithErrorMessage(type + "_directory") + File.separatorChar + type;
        }

        private String storageDirWithErrorMessage(String errMsgType) {
            if (this.storageDir == null) {
                throw new ConfigurationException(errMsgType + " is missing and storage_dir configuration is not set");
            }
            return FileUtils.maybeResolveHomeDirectory(this.storageDir);
        }
    }
}

