/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.sidecar.cluster;

import com.datastax.driver.core.AuthProvider;
import com.datastax.driver.core.Cluster;
import com.datastax.driver.core.NettyOptions;
import com.datastax.driver.core.PlainTextAuthProvider;
import com.datastax.driver.core.QueryOptions;
import com.datastax.driver.core.RemoteEndpointAwareNettySSLOptions;
import com.datastax.driver.core.SSLOptions;
import com.datastax.driver.core.Session;
import com.datastax.driver.core.exceptions.DriverException;
import com.datastax.driver.core.exceptions.DriverInternalError;
import com.datastax.driver.core.policies.ExponentialReconnectionPolicy;
import com.datastax.driver.core.policies.LoadBalancingPolicy;
import com.datastax.driver.core.policies.ReconnectionPolicy;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslContextBuilder;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetSocketAddress;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.stream.Collectors;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.TrustManagerFactory;
import org.apache.cassandra.sidecar.cluster.driver.SidecarLoadBalancingPolicy;
import org.apache.cassandra.sidecar.common.server.CQLSessionProvider;
import org.apache.cassandra.sidecar.common.server.utils.DriverUtils;
import org.apache.cassandra.sidecar.config.DriverConfiguration;
import org.apache.cassandra.sidecar.config.KeyStoreConfiguration;
import org.apache.cassandra.sidecar.config.SidecarConfiguration;
import org.apache.cassandra.sidecar.config.SslConfiguration;
import org.apache.cassandra.sidecar.exceptions.CassandraUnavailableException;
import org.apache.cassandra.sidecar.exceptions.ConfigurationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CQLSessionProviderImpl
implements CQLSessionProvider {
    private static final Logger logger = LoggerFactory.getLogger(CQLSessionProviderImpl.class);
    private final List<InetSocketAddress> contactPoints;
    private final int numAdditionalConnections;
    private final String localDc;
    private final SslConfiguration sslConfiguration;
    private final NettyOptions nettyOptions;
    private final ReconnectionPolicy reconnectionPolicy;
    private final List<InetSocketAddress> localInstances;
    private final String username;
    private final String password;
    private final DriverUtils driverUtils;
    private volatile Session session;

    @VisibleForTesting
    public CQLSessionProviderImpl(List<InetSocketAddress> contactPoints, List<InetSocketAddress> localInstances, int healthCheckFrequencyMillis, String localDc, int numAdditionalConnections, NettyOptions options) {
        this(contactPoints, localInstances, healthCheckFrequencyMillis, localDc, numAdditionalConnections, null, null, null, options);
    }

    @VisibleForTesting
    public CQLSessionProviderImpl(List<InetSocketAddress> contactPoints, List<InetSocketAddress> localInstances, int healthCheckFrequencyMillis, String localDc, int numAdditionalConnections, String username, String password, SslConfiguration sslConfiguration, NettyOptions options) {
        this.contactPoints = contactPoints;
        this.localInstances = localInstances;
        this.localDc = localDc;
        this.numAdditionalConnections = numAdditionalConnections;
        this.username = username;
        this.password = password;
        this.sslConfiguration = sslConfiguration;
        this.nettyOptions = options;
        this.reconnectionPolicy = new ExponentialReconnectionPolicy(500L, (long)healthCheckFrequencyMillis);
        this.driverUtils = new DriverUtils();
    }

    public CQLSessionProviderImpl(SidecarConfiguration configuration, NettyOptions options, DriverUtils driverUtils) {
        this.driverUtils = driverUtils;
        DriverConfiguration driverConfiguration = configuration.driverConfiguration();
        this.contactPoints = driverConfiguration.contactPoints();
        this.localInstances = configuration.cassandraInstances().stream().map(i -> new InetSocketAddress(i.host(), i.port())).collect(Collectors.toList());
        this.localDc = driverConfiguration.localDc();
        this.username = driverConfiguration.username();
        this.password = driverConfiguration.password();
        this.sslConfiguration = driverConfiguration.sslConfiguration();
        this.numAdditionalConnections = driverConfiguration.numConnections();
        this.nettyOptions = options;
        long maxDelayMs = configuration.healthCheckConfiguration().executeInterval().toMillis();
        this.reconnectionPolicy = new ExponentialReconnectionPolicy(500L, maxDelayMs);
    }

    static RuntimeException propagateCause(ExecutionException e) {
        Throwable cause = e.getCause();
        if (cause instanceof Error) {
            throw (Error)cause;
        }
        if (cause instanceof DriverException) {
            throw ((DriverException)cause).copy();
        }
        throw new DriverInternalError("Unexpected exception thrown", cause);
    }

    @NotNull
    public synchronized Session get() throws CassandraUnavailableException {
        if (this.session != null) {
            return this.session;
        }
        Cluster cluster = null;
        try {
            logger.info("Connecting to cluster using contact points {}", this.contactPoints);
            SidecarLoadBalancingPolicy lbp = new SidecarLoadBalancingPolicy(this.localInstances, this.localDc, this.numAdditionalConnections, this.driverUtils);
            QueryOptions queryOptions = new QueryOptions().setReprepareOnUp(false);
            Cluster.Builder builder = Cluster.builder().addContactPointsWithPorts(this.contactPoints).withReconnectionPolicy(this.reconnectionPolicy).withoutMetrics().withLoadBalancingPolicy((LoadBalancingPolicy)lbp).withQueryOptions(queryOptions).withNettyOptions(this.nettyOptions);
            SslContext sslContext = this.createSslContext(this.sslConfiguration);
            if (sslContext != null) {
                RemoteEndpointAwareNettySSLOptions sslOptions = new RemoteEndpointAwareNettySSLOptions(sslContext);
                builder.withSSL((SSLOptions)sslOptions);
            }
            if (this.username != null && this.password != null) {
                builder.withCredentials(this.username, this.password);
            } else if (this.sslConfiguration != null && this.sslConfiguration.isKeystoreConfigured()) {
                builder.withAuthProvider((AuthProvider)new PlainTextAuthProvider("", ""));
            }
            cluster = builder.build();
            this.session = cluster.connect();
            logger.info("Successfully connected to Cassandra!");
            return this.session;
        }
        catch (Exception connectionException) {
            logger.error("Failed to reach Cassandra", (Throwable)connectionException);
            if (cluster != null) {
                try {
                    cluster.close();
                }
                catch (Exception closeException) {
                    logger.error("Failed to close cluster in cleanup", (Throwable)closeException);
                    connectionException.addSuppressed(closeException);
                }
            }
            throw new CassandraUnavailableException(CassandraUnavailableException.Service.CQL, (Throwable)connectionException);
        }
    }

    @Nullable
    public Session getIfConnected() {
        return this.session;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        Session localSession;
        CQLSessionProviderImpl cQLSessionProviderImpl = this;
        synchronized (cQLSessionProviderImpl) {
            localSession = this.session;
            this.session = null;
        }
        if (localSession != null) {
            try {
                localSession.getCluster().closeAsync().get(1L, TimeUnit.MINUTES);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            catch (TimeoutException e) {
                logger.warn("Unable to close session after 1 minute for provider {}", (Object)this, (Object)e);
            }
            catch (ExecutionException e) {
                throw CQLSessionProviderImpl.propagateCause(e);
            }
        }
    }

    private SslContext createSslContext(SslConfiguration sslConfiguration) {
        if (sslConfiguration == null || !sslConfiguration.enabled()) {
            return null;
        }
        try {
            SslContextBuilder sslContextBuilder = SslContextBuilder.forClient().protocols(sslConfiguration.secureTransportProtocols());
            if (sslConfiguration.isKeystoreConfigured()) {
                KeyStore keyStore = this.createKeystore(sslConfiguration.keystore());
                KeyManagerFactory kmf = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
                kmf.init(keyStore, sslConfiguration.keystore().password().toCharArray());
                sslContextBuilder.keyManager(kmf);
            }
            if (sslConfiguration.isTrustStoreConfigured()) {
                KeyStore truststore = this.createKeystore(sslConfiguration.truststore());
                TrustManagerFactory tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
                tmf.init(truststore);
                sslContextBuilder.trustManager(tmf);
            }
            return sslContextBuilder.build();
        }
        catch (Exception e) {
            throw new ConfigurationException("Error creating SsLContext for Cassandra connections", e);
        }
    }

    private KeyStore createKeystore(KeyStoreConfiguration config) throws KeyStoreException, IOException, CertificateException, NoSuchAlgorithmException {
        KeyStore keystore = KeyStore.getInstance(config.type());
        try (InputStream inputStream = Files.newInputStream(Paths.get(config.path(), new String[0]), new OpenOption[0]);){
            keystore.load(inputStream, config.password().toCharArray());
        }
        return keystore;
    }
}

