/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.sidecar.acl.authorization;

import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.ext.auth.User;
import io.vertx.ext.auth.authorization.Authorization;
import io.vertx.ext.auth.authorization.AuthorizationProvider;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.cassandra.sidecar.acl.IdentityToRoleCache;
import org.apache.cassandra.sidecar.acl.authorization.RoleAuthorizationsCache;
import org.apache.cassandra.sidecar.utils.AuthUtils;

public class RoleBasedAuthorizationProvider
implements AuthorizationProvider {
    private final IdentityToRoleCache identityToRoleCache;
    private final RoleAuthorizationsCache roleAuthorizationsCache;

    public RoleBasedAuthorizationProvider(IdentityToRoleCache identityToRoleCache, RoleAuthorizationsCache roleAuthorizationsCache) {
        this.identityToRoleCache = identityToRoleCache;
        this.roleAuthorizationsCache = roleAuthorizationsCache;
    }

    public String getId() {
        return "RoleBasedAccessControl";
    }

    public void getAuthorizations(User user, Handler<AsyncResult<Void>> handler) {
        this.getAuthorizations(user).onComplete(handler);
    }

    public Future<Void> getAuthorizations(User user) {
        List<String> identities = AuthUtils.extractIdentities(user);
        if (identities.isEmpty()) {
            return Future.failedFuture((String)"Missing client identities");
        }
        HashSet<Authorization> authorizations = new HashSet<Authorization>();
        for (String identity : identities) {
            Set<Authorization> roleAuthorizations;
            String role = (String)this.identityToRoleCache.get(identity);
            if (role == null || (roleAuthorizations = this.roleAuthorizationsCache.getAuthorizations(role)) == null) continue;
            authorizations.addAll(roleAuthorizations);
        }
        user.authorizations().add(this.getId(), authorizations);
        return Future.succeededFuture();
    }
}

