/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.sidecar.acl.authorization;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.cassandra.sidecar.acl.authorization.BasicPermissions;
import org.apache.cassandra.sidecar.acl.authorization.CassandraPermissions;
import org.apache.cassandra.sidecar.acl.authorization.CompositePermission;
import org.apache.cassandra.sidecar.acl.authorization.Permission;
import org.apache.cassandra.sidecar.acl.authorization.ResourceScopes;
import org.apache.cassandra.sidecar.acl.authorization.StandardPermission;

public enum FeaturePermission {
    ANALYTICS_READ_DIRECT("ANALYTICS:READ_DIRECT", BasicPermissions.READ_RING_KEYSPACE_SCOPED, BasicPermissions.READ_SCHEMA_KEYSPACE_SCOPED, BasicPermissions.CREATE_SNAPSHOT, BasicPermissions.READ_SNAPSHOT, BasicPermissions.DELETE_SNAPSHOT, BasicPermissions.STREAM_SNAPSHOT, new StandardPermission(CassandraPermissions.SELECT.name(), ResourceScopes.TABLE_SCOPE)),
    ANALYTICS_WRITE_DIRECT("ANALYTICS:WRITE_DIRECT", BasicPermissions.READ_SCHEMA_KEYSPACE_SCOPED, BasicPermissions.READ_TOPOLOGY, BasicPermissions.UPLOAD_STAGED_SSTABLE, BasicPermissions.IMPORT_STAGED_SSTABLE, BasicPermissions.DELETE_STAGED_SSTABLE, new StandardPermission(CassandraPermissions.MODIFY.name(), ResourceScopes.TABLE_SCOPE)),
    ANALYTICS_WRITE_S3_COMPAT("ANALYTICS:WRITE_S3_COMPAT", BasicPermissions.READ_SCHEMA_KEYSPACE_SCOPED, BasicPermissions.READ_TOPOLOGY, BasicPermissions.CREATE_RESTORE_JOB, BasicPermissions.READ_RESTORE_JOB, BasicPermissions.EDIT_RESTORE_JOB, BasicPermissions.DELETE_RESTORE_JOB),
    CDC("CDC", BasicPermissions.CDC);

    public static final List<CompositePermission> ALL_FEATURE_PERMISSIONS;
    private final CompositePermission permission;

    private FeaturePermission(String name, Permission ... permissions) {
        this.permission = new CompositePermission(name, Arrays.stream(permissions).collect(Collectors.toList()));
    }

    public CompositePermission permission() {
        return this.permission;
    }

    static {
        ALL_FEATURE_PERMISSIONS = Arrays.stream(FeaturePermission.values()).map(FeaturePermission::permission).collect(Collectors.toList());
    }
}

