/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.sidecar.acl.authorization;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import io.vertx.core.http.HttpServerRequest;
import io.vertx.core.net.SocketAddress;
import io.vertx.ext.web.RoutingContext;
import org.apache.cassandra.sidecar.common.server.data.Name;
import org.apache.cassandra.sidecar.common.server.data.QualifiedTableName;
import org.apache.cassandra.sidecar.concurrent.ExecutorPools;
import org.apache.cassandra.sidecar.routes.AbstractHandler;
import org.apache.cassandra.sidecar.routes.RoutingContextUtils;
import org.apache.cassandra.sidecar.snapshots.SnapshotPathBuilder;
import org.apache.cassandra.sidecar.utils.CassandraInputValidator;
import org.apache.cassandra.sidecar.utils.InstanceMetadataFetcher;
import org.jetbrains.annotations.NotNull;

@Singleton
public class AuthorizationParameterValidateHandler
extends AbstractHandler<QualifiedTableName> {
    private final SnapshotPathBuilder snapshotPathBuilder;

    @Inject
    protected AuthorizationParameterValidateHandler(InstanceMetadataFetcher metadataFetcher, ExecutorPools executorPools, CassandraInputValidator validator, SnapshotPathBuilder snapshotPathBuilder) {
        super(metadataFetcher, executorPools, validator);
        this.snapshotPathBuilder = snapshotPathBuilder;
    }

    @Override
    protected void handleInternal(RoutingContext context, HttpServerRequest httpRequest, @NotNull String host, SocketAddress remoteAddress, QualifiedTableName qualifiedTableName) {
        RoutingContextUtils.put(context, RoutingContextUtils.SC_QUALIFIED_TABLE_NAME, qualifiedTableName);
    }

    @Override
    protected QualifiedTableName extractParamsOrThrow(RoutingContext context) {
        Name tableName = null;
        String tableNameParam = context.pathParam("table");
        if (tableNameParam != null) {
            tableName = this.validator.validateTableName(this.snapshotPathBuilder.maybeRemoveTableId(tableNameParam));
        }
        return new QualifiedTableName(this.keyspace(context, false), tableName);
    }
}

