/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.sidecar.acl.authorization;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.Set;
import org.apache.cassandra.sidecar.acl.IdentityToRoleCache;
import org.apache.cassandra.sidecar.acl.authorization.SuperUserCache;
import org.apache.cassandra.sidecar.config.SidecarConfiguration;

@Singleton
public class AdminIdentityResolver {
    private final IdentityToRoleCache identityToRoleCache;
    private final SuperUserCache superUserCache;
    private final Set<String> adminIdentities;

    @Inject
    public AdminIdentityResolver(IdentityToRoleCache identityToRoleCache, SuperUserCache superUserCache, SidecarConfiguration sidecarConfiguration) {
        this.identityToRoleCache = identityToRoleCache;
        this.superUserCache = superUserCache;
        this.adminIdentities = sidecarConfiguration.accessControlConfiguration().adminIdentities();
    }

    public boolean isAdmin(String identity) {
        if (this.adminIdentities.contains(identity)) {
            return true;
        }
        String role = (String)this.identityToRoleCache.get(identity);
        if (role == null) {
            return false;
        }
        return this.superUserCache.isSuperUser(role);
    }
}

