/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.sidecar.acl.authentication;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import io.vertx.core.Vertx;
import io.vertx.ext.auth.mtls.CertificateIdentityExtractor;
import io.vertx.ext.auth.mtls.CertificateValidator;
import io.vertx.ext.auth.mtls.MutualTlsAuthentication;
import io.vertx.ext.auth.mtls.impl.MutualTlsAuthenticationImpl;
import io.vertx.ext.auth.mtls.impl.SpiffeIdentityExtractor;
import io.vertx.ext.web.handler.impl.AuthenticationHandlerInternal;
import java.util.Map;
import org.apache.cassandra.sidecar.acl.IdentityToRoleCache;
import org.apache.cassandra.sidecar.acl.authentication.AuthenticationHandlerFactory;
import org.apache.cassandra.sidecar.acl.authentication.CassandraIdentityExtractor;
import org.apache.cassandra.sidecar.acl.authentication.MutualTlsAuthenticationHandler;
import org.apache.cassandra.sidecar.config.AccessControlConfiguration;
import org.apache.cassandra.sidecar.exceptions.ConfigurationException;

@Singleton
public class MutualTlsAuthenticationHandlerFactory
implements AuthenticationHandlerFactory {
    protected static final String CERTIFICATE_VALIDATOR_PARAM_KEY = "certificate_validator";
    protected static final String CERTIFICATE_IDENTITY_EXTRACTOR_PARAM_KEY = "certificate_identity_extractor";
    private final IdentityToRoleCache identityToRoleCache;

    @Inject
    public MutualTlsAuthenticationHandlerFactory(IdentityToRoleCache identityToRoleCache) {
        this.identityToRoleCache = identityToRoleCache;
    }

    @Override
    public AuthenticationHandlerInternal create(Vertx vertx, AccessControlConfiguration accessControlConfiguration, Map<String, String> parameters) throws ConfigurationException {
        this.validate(parameters);
        try {
            return this.createInternal(vertx, accessControlConfiguration, parameters);
        }
        catch (Exception exception) {
            throw new ConfigurationException("Error creating MutualTlsAuthenticationHandler", exception);
        }
    }

    void validate(Map<String, String> parameters) throws ConfigurationException {
        if (parameters == null) {
            throw new ConfigurationException("Parameters cannot be null for MutualTlsAuthenticationHandlerFactory");
        }
        if (!parameters.containsKey(CERTIFICATE_VALIDATOR_PARAM_KEY)) {
            throw new ConfigurationException(String.format("Missing %s parameter for MutualTlsAuthenticationHandler creation", CERTIFICATE_VALIDATOR_PARAM_KEY));
        }
        if (!parameters.containsKey(CERTIFICATE_IDENTITY_EXTRACTOR_PARAM_KEY)) {
            throw new ConfigurationException(String.format("Missing %s parameter for MutualTlsAuthenticationHandler creation", CERTIFICATE_IDENTITY_EXTRACTOR_PARAM_KEY));
        }
    }

    private MutualTlsAuthenticationHandler createInternal(Vertx vertx, AccessControlConfiguration accessControlConfiguration, Map<String, String> parameters) throws Exception {
        CertificateValidator certificateValidator = (CertificateValidator)Class.forName(parameters.get(CERTIFICATE_VALIDATOR_PARAM_KEY)).newInstance();
        SpiffeIdentityExtractor certificateIdentityExtractor = parameters.get(CERTIFICATE_IDENTITY_EXTRACTOR_PARAM_KEY).equalsIgnoreCase(CassandraIdentityExtractor.class.getName()) ? new CassandraIdentityExtractor(this.identityToRoleCache, accessControlConfiguration.adminIdentities()) : new SpiffeIdentityExtractor();
        MutualTlsAuthenticationImpl mTLSAuthProvider = new MutualTlsAuthenticationImpl(vertx, certificateValidator, (CertificateIdentityExtractor)certificateIdentityExtractor);
        return new MutualTlsAuthenticationHandler((MutualTlsAuthentication)mTLSAuthProvider);
    }
}

