/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.sidecar.acl;

import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.LoadingCache;
import io.vertx.core.Vertx;
import io.vertx.core.eventbus.EventBus;
import java.util.Collections;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;
import org.apache.cassandra.sidecar.concurrent.ExecutorPools;
import org.apache.cassandra.sidecar.concurrent.TaskExecutorPool;
import org.apache.cassandra.sidecar.config.CacheConfiguration;
import org.apache.cassandra.sidecar.exceptions.SchemaUnavailableException;
import org.apache.cassandra.sidecar.server.SidecarServerEvents;
import org.jetbrains.annotations.VisibleForTesting;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AuthCache<K, V> {
    private static final Logger LOGGER = LoggerFactory.getLogger(AuthCache.class);
    private final String name;
    private final Function<K, V> loadFunction;
    private final Supplier<Map<K, V>> bulkLoadFunction;
    private final CacheConfiguration config;
    private final TaskExecutorPool internalPool;
    private volatile LoadingCache<K, V> cache;
    protected final Vertx vertx;

    protected AuthCache(String name, Vertx vertx, ExecutorPools executorPools, Function<K, V> loadFunction, Supplier<Map<K, V>> bulkLoadFunction, CacheConfiguration cacheConfiguration) {
        this.name = name;
        this.vertx = vertx;
        this.internalPool = executorPools.internal();
        this.loadFunction = loadFunction;
        this.bulkLoadFunction = bulkLoadFunction;
        this.config = cacheConfiguration;
        if (this.config.enabled()) {
            this.cache = this.initCache();
            this.configureSidecarServerEventListener();
        }
    }

    protected LoadingCache<K, V> cache() {
        return this.cache;
    }

    public V get(K k) {
        if (!this.config.enabled()) {
            return this.loadFunction.apply(k);
        }
        return (V)this.cache.get(k);
    }

    public Map<K, V> getAll() {
        if (!this.config.enabled()) {
            return this.bulkLoadFunction.get();
        }
        return Collections.unmodifiableMap(this.cache.asMap());
    }

    private LoadingCache<K, V> initCache() {
        return Caffeine.newBuilder().refreshAfterWrite(this.config.expireAfterAccess().quantity(), this.config.expireAfterAccess().unit()).expireAfterWrite(this.config.expireAfterAccess().quantity(), this.config.expireAfterAccess().unit()).maximumSize(this.config.maximumSize()).build(this.loadFunction::apply);
    }

    private void configureSidecarServerEventListener() {
        EventBus eventBus = this.vertx.eventBus();
        eventBus.localConsumer(SidecarServerEvents.ON_SIDECAR_SCHEMA_INITIALIZED.address(), message -> this.warmUpAsync(this.config.warmupRetries()));
    }

    private void warmUpAsync(int availableRetries) {
        this.internalPool.runBlocking(() -> this.warmUp(availableRetries));
    }

    @VisibleForTesting
    protected void warmUp(int availableRetries) {
        if (!this.config.enabled()) {
            LOGGER.info("Cache={} not enabled, skipping pre-warming", (Object)this.name);
            return;
        }
        if (availableRetries < 1) {
            LOGGER.warn("Retries exhausted, unexpected error pre-warming cache={}", (Object)this.name);
            return;
        }
        try {
            this.cache.putAll(this.bulkLoadFunction.get());
        }
        catch (SchemaUnavailableException sue) {
            LOGGER.warn("system_auth schema is unavailable. Skip warming up cache", (Throwable)sue);
        }
        catch (Exception e) {
            LOGGER.warn("Unexpected error encountered during pre-warming of cache={} ", (Object)this.name, (Object)e);
            this.vertx.setTimer(this.config.warmupRetryInterval().toMillis(), t -> this.warmUpAsync(availableRetries - 1));
        }
    }
}

