/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.log.core.internal;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.TreeMap;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.karaf.log.core.Level;
import org.apache.karaf.log.core.internal.LogServiceInternal;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class LogServiceLogbackXmlImpl
implements LogServiceInternal {
    private static final String ELEMENT_ROOT = "root";
    private static final String ELEMENT_LOGGER = "logger";
    private static final String ATTRIBUTE_NAME = "name";
    private static final String ATTRIBUTE_LEVEL = "level";
    private static final String ELEMENT_CONFIGURATION = "configuration";
    private final Path path;

    LogServiceLogbackXmlImpl(String file) {
        this.path = Paths.get(file, new String[0]);
    }

    @Override
    public Map<String, String> getLevel(String logger) {
        try {
            Document doc = LogServiceLogbackXmlImpl.loadConfig(this.path);
            Map<String, Element> loggers = this.getLoggers(doc);
            TreeMap<String, String> levels = new TreeMap<String, String>();
            for (Map.Entry<String, Element> e : loggers.entrySet()) {
                String level = e.getValue().getAttribute(ATTRIBUTE_LEVEL);
                if (level == null || level.isEmpty()) continue;
                levels.put(e.getKey(), level);
            }
            if ("ALL".equals(logger)) {
                return levels;
            }
            String l = logger;
            while (true) {
                String val;
                if ((val = (String)levels.get(l != null ? l : "ROOT")) != null || l == null) {
                    return Collections.singletonMap(logger, val);
                }
                int idx = l.lastIndexOf(46);
                if (idx < 0) {
                    l = null;
                    continue;
                }
                l = l.substring(0, idx);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to retrieve level for logger", e);
        }
    }

    @Override
    public void setLevel(String logger, String level) {
        try {
            Document doc = LogServiceLogbackXmlImpl.loadConfig(this.path);
            Map<String, Element> loggers = this.getLoggers(doc);
            Element element = loggers.get(logger);
            if (element != null) {
                if (Level.isDefault(level)) {
                    element.removeAttribute(ATTRIBUTE_LEVEL);
                } else {
                    element.setAttribute(ATTRIBUTE_LEVEL, level);
                }
            } else if (!Level.isDefault(level)) {
                Element docE = doc.getDocumentElement();
                boolean root = "ROOT".equals(logger);
                if (root) {
                    element = doc.createElement(ELEMENT_ROOT);
                    element.setAttribute(ATTRIBUTE_LEVEL, level);
                } else {
                    element = doc.createElement(ELEMENT_LOGGER);
                    element.setAttribute(ATTRIBUTE_NAME, logger);
                    element.setAttribute(ATTRIBUTE_LEVEL, level);
                }
                LogServiceLogbackXmlImpl.insertIndented(docE, element);
            } else {
                return;
            }
            try (OutputStream os = Files.newOutputStream(this.path, StandardOpenOption.WRITE, StandardOpenOption.TRUNCATE_EXISTING);){
                TransformerFactory tFactory = TransformerFactory.newInstance();
                tFactory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", Boolean.TRUE);
                try {
                    tFactory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalDTD", "");
                    tFactory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalStylesheet", "");
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
                Transformer transformer = tFactory.newTransformer();
                transformer.transform(new DOMSource(doc), new StreamResult(os));
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to set level for logger", e);
        }
    }

    static void insertIndented(Element parent, Element element) {
        Node insertAfter;
        NodeList taggedElements = parent.getElementsByTagName("*");
        ArrayList<Node> childElements = new ArrayList<Node>();
        for (int i = 0; i < taggedElements.getLength(); ++i) {
            if (!taggedElements.item(i).getParentNode().equals(parent)) continue;
            childElements.add(taggedElements.item(i));
        }
        Node node = insertAfter = childElements.size() > 0 ? (Node)childElements.get(childElements.size() - 1) : null;
        if (insertAfter != null) {
            if (insertAfter.getPreviousSibling() != null && insertAfter.getPreviousSibling().getNodeType() == 3) {
                String indent = insertAfter.getPreviousSibling().getTextContent();
                Text node2 = parent.getOwnerDocument().createTextNode(indent);
                if (insertAfter.getNextSibling() != null) {
                    parent.insertBefore(node2, insertAfter.getNextSibling());
                    insertAfter = node2;
                } else {
                    parent.appendChild(node2);
                }
            }
            if (insertAfter.getNextSibling() != null) {
                parent.insertBefore(element, insertAfter.getNextSibling());
            } else {
                parent.appendChild(element);
            }
        } else {
            String prev;
            String indent;
            if (parent.getPreviousSibling() != null && parent.getPreviousSibling().getNodeType() == 3) {
                int nl;
                prev = indent = parent.getPreviousSibling().getTextContent();
                indent = indent.endsWith("\t") ? indent + "\t" : ((nl = indent.lastIndexOf(10)) >= 0 ? indent + indent.substring(nl + 1) : indent + "\t");
                if (parent.getFirstChild() != null && parent.getPreviousSibling().getNodeType() == 3) {
                    parent.removeChild(parent.getFirstChild());
                }
            } else {
                indent = "\t";
                prev = "\n";
            }
            parent.appendChild(parent.getOwnerDocument().createTextNode(indent));
            parent.appendChild(element);
            parent.appendChild(parent.getOwnerDocument().createTextNode(prev));
        }
    }

    static Document loadConfig(Path path) throws Exception {
        try (InputStream is = Files.newInputStream(path, new OpenOption[0]);){
            Document document = LogServiceLogbackXmlImpl.loadConfig(path.toString(), is);
            return document;
        }
    }

    static Document loadConfig(String id, InputStream is) throws ParserConfigurationException, SAXException, IOException {
        InputSource source = new InputSource(is);
        source.setPublicId(id);
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        factory.setValidating(false);
        factory.setExpandEntityReferences(false);
        LogServiceLogbackXmlImpl.setFeature(factory, "http://javax.xml.XMLConstants/feature/secure-processing", true);
        LogServiceLogbackXmlImpl.setFeature(factory, "http://xml.org/sax/features/external-general-entities", false);
        LogServiceLogbackXmlImpl.setFeature(factory, "http://xml.org/sax/features/external-parameter-entities", false);
        LogServiceLogbackXmlImpl.setFeature(factory, "http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
        LogServiceLogbackXmlImpl.setFeature(factory, "http://apache.org/xml/features/xinclude/fixup-base-uris", true);
        LogServiceLogbackXmlImpl.setFeature(factory, "http://apache.org/xml/features/xinclude/fixup-language", true);
        LogServiceLogbackXmlImpl.tryCall(() -> factory.setXIncludeAware(true));
        DocumentBuilder documentBuilder = factory.newDocumentBuilder();
        return documentBuilder.parse(source);
    }

    private static void setFeature(DocumentBuilderFactory factory, String name, boolean b) {
        LogServiceLogbackXmlImpl.tryCall(() -> factory.setFeature(name, b));
    }

    private static void tryCall(RunnableWithException c) {
        try {
            c.run();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private Map<String, Element> getLoggers(Document doc) {
        TreeMap<String, Element> loggers = new TreeMap<String, Element>();
        Element docE = doc.getDocumentElement();
        if (!ELEMENT_CONFIGURATION.equals(docE.getLocalName())) {
            throw new IllegalArgumentException("Xml root document should be configuration");
        }
        NodeList loggersList = docE.getElementsByTagName(ELEMENT_LOGGER);
        for (int i = 0; i < loggersList.getLength(); ++i) {
            String name;
            Node n = loggersList.item(i);
            if (!(n instanceof Element)) continue;
            Element e = (Element)n;
            if (ELEMENT_ROOT.equals(e.getLocalName())) {
                loggers.put("ROOT", e);
                continue;
            }
            if (!ELEMENT_LOGGER.equals(e.getLocalName()) || (name = e.getAttribute(ATTRIBUTE_NAME)) == null) continue;
            loggers.put(name, e);
        }
        return loggers;
    }

    static interface RunnableWithException {
        public void run() throws Exception;
    }
}

