/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.enricher.stock;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.reflect.TypeToken;
import org.apache.brooklyn.api.catalog.Catalog;
import org.apache.brooklyn.api.catalog.CatalogConfig;
import org.apache.brooklyn.api.entity.Entity;
import org.apache.brooklyn.api.sensor.Sensor;
import org.apache.brooklyn.api.sensor.SensorEvent;
import org.apache.brooklyn.config.ConfigKey;
import org.apache.brooklyn.core.config.ConfigKeys;
import org.apache.brooklyn.core.effector.AddSensorInitializerAbstractProto;
import org.apache.brooklyn.core.entity.Entities;
import org.apache.brooklyn.enricher.stock.AbstractTransformer;
import org.apache.brooklyn.util.collections.MutableSet;
import org.apache.brooklyn.util.core.task.Tasks;
import org.apache.brooklyn.util.guava.Maybe;
import org.apache.brooklyn.util.text.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Catalog(name="Transformer", description="Transforms sensors of an entity")
public class Transformer<T, U>
extends AbstractTransformer<T, U> {
    private static final Logger LOG = LoggerFactory.getLogger(Transformer.class);
    @CatalogConfig(label="Target value")
    public static final ConfigKey<Object> TARGET_VALUE = ConfigKeys.newConfigKey(Object.class, "enricher.targetValue", "The value for the target sensor. This can use the Brooklyn DSL, which will be re-evaluated each time the trigger sensor(s) change");
    public static final ConfigKey<String> TARGET_TYPE = ConfigKeys.newStringConfigKey("enricher.targetType", "Target type for the value; default comes from sensor definition or Object (untyped)");
    public static final ConfigKey<Function<?, ?>> TRANSFORMATION_FROM_VALUE = ConfigKeys.newConfigKey(new TypeToken<Function<?, ?>>(){}, "enricher.transformation", "A function for computing the target sensor's new value (will be passed the trigger sensor's value each time)");
    public static final ConfigKey<Function<?, ?>> TRANSFORMATION_FROM_EVENT = ConfigKeys.newConfigKey(new TypeToken<Function<?, ?>>(){}, "enricher.transformation.fromevent", "A function for computing the target sensor's new value (will be passed the trigger sensor's change-event each time)");

    @Override
    protected Function<SensorEvent<T>, U> getTransformation() {
        MutableSet suppliers = MutableSet.of();
        suppliers.addIfNotNull(this.config().getRaw(TARGET_VALUE).orNull());
        suppliers.addIfNotNull(this.config().getRaw(TRANSFORMATION_FROM_EVENT).orNull());
        suppliers.addIfNotNull(this.config().getRaw(TRANSFORMATION_FROM_VALUE).orNull());
        Preconditions.checkArgument((suppliers.size() <= 1 ? 1 : 0) != 0, (String)"Must set at most one of: %s, %s, %s", (Object)TARGET_VALUE.getName(), (Object)TRANSFORMATION_FROM_VALUE.getName(), (Object)TRANSFORMATION_FROM_EVENT.getName());
        final Function fromEvent = (Function)this.config().get(TRANSFORMATION_FROM_EVENT);
        if (fromEvent != null) {
            return new Function<SensorEvent<T>, U>(){

                public U apply(SensorEvent<T> input) {
                    Object targetValueRaw = fromEvent.apply(input);
                    return Transformer.this.resolveImmediately(targetValueRaw, Transformer.this.targetSensor);
                }

                public String toString() {
                    return "" + fromEvent;
                }
            };
        }
        final Function fromValueFn = (Function)this.config().get(TRANSFORMATION_FROM_VALUE);
        if (fromValueFn != null) {
            return new Function<SensorEvent<T>, U>(){

                public U apply(SensorEvent<T> input) {
                    Object targetValueRaw = fromValueFn.apply(input == null ? null : input.getValue());
                    return Transformer.this.resolveImmediately(targetValueRaw, Transformer.this.targetSensor);
                }

                public String toString() {
                    return "" + fromValueFn;
                }
            };
        }
        final Maybe<Object> targetValueRawM = this.config().getRaw(TARGET_VALUE);
        if (targetValueRawM.isPresent()) {
            return new Function<SensorEvent<T>, U>(){

                public U apply(SensorEvent<T> input) {
                    return Transformer.this.resolveImmediately(targetValueRawM.get(), Transformer.this.targetSensor);
                }

                public String toString() {
                    return "" + targetValueRawM.get();
                }
            };
        }
        return new Function<SensorEvent<T>, U>(){

            public U apply(SensorEvent<T> input) {
                return Transformer.this.resolveImmediately(input.getValue(), Transformer.this.targetSensor);
            }

            public String toString() {
                return "<identity>";
            }
        };
    }

    private U resolveImmediately(Object rawVal, Sensor<U> targetSensor) {
        if (rawVal == Entities.UNCHANGED || rawVal == Entities.REMOVE) {
            return (U)rawVal;
        }
        String typeS = this.getConfig(TARGET_TYPE);
        TypeToken type = Strings.isNonBlank((CharSequence)typeS) ? AddSensorInitializerAbstractProto.getType((Entity)this.entity, typeS, "Transformer to " + targetSensor) : targetSensor.getTypeToken();
        return (U)Tasks.resolving(rawVal).as(type).context((Entity)this.entity).description("Computing sensor " + targetSensor + " from " + rawVal).deep().immediately(true).getMaybe().orNull();
    }
}

