/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.entity.software.base.lifecycle;

import com.google.common.annotations.Beta;
import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.reflect.TypeToken;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import javax.annotation.Nullable;
import org.apache.brooklyn.api.effector.Effector;
import org.apache.brooklyn.api.entity.Entity;
import org.apache.brooklyn.api.location.Location;
import org.apache.brooklyn.api.location.MachineLocation;
import org.apache.brooklyn.api.location.MachineManagementMixins;
import org.apache.brooklyn.api.location.MachineProvisioningLocation;
import org.apache.brooklyn.api.location.NoMachinesAvailableException;
import org.apache.brooklyn.api.mgmt.ManagementContext;
import org.apache.brooklyn.api.mgmt.Task;
import org.apache.brooklyn.api.mgmt.TaskAdaptable;
import org.apache.brooklyn.api.mgmt.entitlement.EntitlementContext;
import org.apache.brooklyn.api.sensor.AttributeSensor;
import org.apache.brooklyn.api.sensor.Feed;
import org.apache.brooklyn.config.ConfigKey;
import org.apache.brooklyn.core.config.ConfigKeys;
import org.apache.brooklyn.core.config.Sanitizer;
import org.apache.brooklyn.core.effector.EffectorBody;
import org.apache.brooklyn.core.effector.Effectors;
import org.apache.brooklyn.core.entity.Attributes;
import org.apache.brooklyn.core.entity.BrooklynConfigKeys;
import org.apache.brooklyn.core.entity.Entities;
import org.apache.brooklyn.core.entity.EntityInternal;
import org.apache.brooklyn.core.entity.internal.AttributesInternal;
import org.apache.brooklyn.core.entity.lifecycle.Lifecycle;
import org.apache.brooklyn.core.entity.lifecycle.ServiceStateLogic;
import org.apache.brooklyn.core.entity.trait.Startable;
import org.apache.brooklyn.core.entity.trait.StartableMethods;
import org.apache.brooklyn.core.feed.ConfigToAttributes;
import org.apache.brooklyn.core.location.AbstractLocation;
import org.apache.brooklyn.core.location.Locations;
import org.apache.brooklyn.core.location.Machines;
import org.apache.brooklyn.core.location.cloud.CloudLocationConfig;
import org.apache.brooklyn.core.mgmt.BrooklynTaskTags;
import org.apache.brooklyn.core.mgmt.entitlement.Entitlements;
import org.apache.brooklyn.core.sensor.BasicAttributeSensor;
import org.apache.brooklyn.core.sensor.ReleaseableLatch;
import org.apache.brooklyn.entity.machine.MachineInitTasks;
import org.apache.brooklyn.entity.machine.ProvidesProvisioningFlags;
import org.apache.brooklyn.entity.software.base.SoftwareProcess;
import org.apache.brooklyn.entity.stock.EffectorStartableImpl;
import org.apache.brooklyn.location.localhost.LocalhostMachineProvisioningLocation;
import org.apache.brooklyn.location.ssh.CanResolveOnBoxDir;
import org.apache.brooklyn.location.ssh.SshMachineLocation;
import org.apache.brooklyn.util.collections.MutableMap;
import org.apache.brooklyn.util.collections.MutableSet;
import org.apache.brooklyn.util.core.config.ConfigBag;
import org.apache.brooklyn.util.core.task.DynamicTasks;
import org.apache.brooklyn.util.core.task.Tasks;
import org.apache.brooklyn.util.core.task.ValueResolverIterator;
import org.apache.brooklyn.util.exceptions.Exceptions;
import org.apache.brooklyn.util.guava.Maybe;
import org.apache.brooklyn.util.net.UserAndHostAndPort;
import org.apache.brooklyn.util.os.Os;
import org.apache.brooklyn.util.repeat.Repeater;
import org.apache.brooklyn.util.time.Duration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Beta
public abstract class MachineLifecycleEffectorTasks {
    private static final Logger log = LoggerFactory.getLogger(MachineLifecycleEffectorTasks.class);
    public static final ConfigKey<Boolean> ON_BOX_BASE_DIR_RESOLVED = ConfigKeys.newBooleanConfigKey((String)"onbox.base.dir.resolved", (String)"Whether the on-box base directory has been resolved (for internal use)");
    public static final ConfigKey<Collection<? extends Location>> LOCATIONS = EffectorStartableImpl.StartParameters.LOCATIONS;
    public static final ConfigKey<Duration> STOP_PROCESS_TIMEOUT = ConfigKeys.newDurationConfigKey((String)"process.stop.timeout", (String)"How long to wait for the processes to be stopped; use null to mean forever", (Duration)Duration.TWO_MINUTES);
    @Beta
    public static final ConfigKey<Duration> STOP_WAIT_PROVISIONING_TIMEOUT = ConfigKeys.newDurationConfigKey((String)"stop.wait.provisioning.timeout", (String)"If stop is called on an entity while it is still provisioning the machine (such that the provisioning cannot be safely interrupted), this is the length of time to wait for the machine instance to become available so that it can be terminated. If stop aborts before this point, the machine may be left running.", (Duration)Duration.minutes((Number)10));
    @Beta
    public static final AttributeSensor<MachineLocation> INTERNAL_PROVISIONED_MACHINE = new BasicAttributeSensor(TypeToken.of(MachineLocation.class), "internal.provisioning.task.machine", "Internal transient sensor (do not use) for tracking the machine being provisioned (to better handle aborting)", AttributeSensor.SensorPersistenceMode.NONE);
    protected final MachineInitTasks machineInitTasks = new MachineInitTasks();

    public void attachLifecycleEffectors(Entity entity) {
        ((EntityInternal)entity).getMutableEntityType().addEffector(this.newStartEffector());
        ((EntityInternal)entity).getMutableEntityType().addEffector(this.newRestartEffector());
        ((EntityInternal)entity).getMutableEntityType().addEffector(this.newStopEffector());
    }

    public Effector<Void> newStartEffector() {
        return Effectors.effector((Effector)Startable.START).impl(this.newStartEffectorTask()).build();
    }

    public Effector<Void> newRestartEffector() {
        return Effectors.effector((Effector)Startable.RESTART).parameter(SoftwareProcess.RestartSoftwareParameters.RESTART_CHILDREN).parameter(SoftwareProcess.RestartSoftwareParameters.RESTART_MACHINE).impl(this.newRestartEffectorTask()).build();
    }

    public Effector<Void> newStopEffector() {
        return Effectors.effector((Effector)Startable.STOP).parameter(SoftwareProcess.StopSoftwareParameters.STOP_PROCESS_MODE).parameter(SoftwareProcess.StopSoftwareParameters.STOP_MACHINE_MODE).impl(this.newStopEffectorTask()).build();
    }

    public Effector<Void> newSuspendEffector() {
        return Effectors.effector(Void.class, (String)"suspend").description("Suspend the process/service represented by an entity").parameter(SoftwareProcess.StopSoftwareParameters.STOP_PROCESS_MODE).parameter(SoftwareProcess.StopSoftwareParameters.STOP_MACHINE_MODE).impl(this.newSuspendEffectorTask()).build();
    }

    public EffectorBody<Void> newStartEffectorTask() {
        new EffectorBody<Void>(){

            public Void call(ConfigBag parameters) {
                List locations = null;
                Object locationsRaw = parameters.getStringKey(LOCATIONS.getName());
                locations = Locations.coerceToCollectionOfLocationsManaged((ManagementContext)this.entity().getManagementContext(), (Object)locationsRaw);
                if (locations == null) {
                    locations = Collections.emptyList();
                }
                MachineLifecycleEffectorTasks.this.start(locations);
                return null;
            }
        };
        return new StartEffectorBody();
    }

    public EffectorBody<Void> newRestartEffectorTask() {
        new EffectorBody<Void>(){

            public Void call(ConfigBag parameters) {
                MachineLifecycleEffectorTasks.this.restart(parameters);
                return null;
            }
        };
        return new RestartEffectorBody();
    }

    public EffectorBody<Void> newStopEffectorTask() {
        new EffectorBody<Void>(){

            public Void call(ConfigBag parameters) {
                MachineLifecycleEffectorTasks.this.stop(parameters);
                return null;
            }
        };
        return new StopEffectorBody();
    }

    public EffectorBody<Void> newSuspendEffectorTask() {
        return new SuspendEffectorBody();
    }

    protected EntityInternal entity() {
        return (EntityInternal)BrooklynTaskTags.getTargetOrContextEntity((Task)Tasks.current());
    }

    protected Location getLocation(@Nullable Collection<? extends Location> locations) {
        Maybe ml;
        MachineProvisioningLocation provisioner;
        if (locations == null || locations.isEmpty()) {
            locations = this.entity().getLocations();
        }
        if (locations.isEmpty() && (provisioner = (MachineProvisioningLocation)this.entity().getAttribute(SoftwareProcess.PROVISIONING_LOCATION)) != null) {
            locations = Arrays.asList(provisioner);
        }
        if ((ml = Locations.findUniqueMachineLocation((Iterable)(locations = Locations.getLocationsCheckingAncestors((Collection)locations, (Entity)this.entity())))).isPresent()) {
            return (Location)ml.get();
        }
        if (locations.isEmpty()) {
            throw new IllegalArgumentException("No locations specified when starting " + this.entity());
        }
        if (locations.size() != 1 || Iterables.getOnlyElement(locations) == null) {
            throw new IllegalArgumentException("Ambiguous locations detected when starting " + this.entity() + ": " + locations);
        }
        return (Location)Iterables.getOnlyElement(locations);
    }

    public void start(Collection<? extends Location> locations) {
        ServiceStateLogic.setExpectedState((Entity)this.entity(), (Lifecycle)Lifecycle.STARTING);
        try {
            this.startInLocations(locations, ConfigBag.newInstance());
            DynamicTasks.waitForLast();
            ServiceStateLogic.setExpectedState((Entity)this.entity(), (Lifecycle)Lifecycle.RUNNING);
        }
        catch (Throwable t) {
            ServiceStateLogic.setExpectedState((Entity)this.entity(), (Lifecycle)Lifecycle.ON_FIRE);
            throw Exceptions.propagate((Throwable)t);
        }
    }

    protected void startInLocations(Collection<? extends Location> locations, ConfigBag parameters) {
        this.startInLocation(this.getLocation(locations), parameters);
    }

    protected void startInLocation(Location location, ConfigBag parameters) {
        Supplier locationS = null;
        if (location instanceof MachineProvisioningLocation) {
            Task<MachineLocation> machineTask = this.provisionAsync((MachineProvisioningLocation)location);
            locationS = Tasks.supplier(machineTask);
        } else if (location instanceof MachineLocation) {
            locationS = Suppliers.ofInstance((Object)((MachineLocation)location));
        }
        Preconditions.checkState((locationS != null ? 1 : 0) != 0, (Object)("Unsupported location " + location + ", when starting " + this.entity()));
        Supplier locationSF = locationS;
        try (CloseableLatch latch = MachineLifecycleEffectorTasks.waitForCloseableLatch((Entity)this.entity(), SoftwareProcess.START_LATCH);){
            this.preStartAtMachineAsync((Supplier<MachineLocation>)locationSF, parameters);
            DynamicTasks.queue((String)"start (processes)", (Runnable)new StartProcessesAtMachineTask((Supplier<MachineLocation>)locationSF));
            this.postStartAtMachineAsync(parameters);
        }
    }

    protected Task<MachineLocation> provisionAsync(MachineProvisioningLocation<?> location) {
        return (Task)DynamicTasks.queue((TaskAdaptable)Tasks.builder().displayName("provisioning (" + location.getDisplayName() + ")").body((Callable)new ProvisionMachineTask(location)).build());
    }

    protected void preStartAtMachineAsync(Supplier<MachineLocation> machineS, ConfigBag parameters) {
        DynamicTasks.queue((String)"pre-start", (Runnable)new PreStartTask((MachineLocation)machineS.get(), parameters));
    }

    public static String resolveOnBoxDir(EntityInternal entity, MachineLocation machine) {
        String base = (String)entity.getConfig(BrooklynConfigKeys.ONBOX_BASE_DIR);
        if (base == null) {
            base = (String)machine.getConfig(BrooklynConfigKeys.ONBOX_BASE_DIR);
        }
        if (base != null && Boolean.TRUE.equals(entity.getConfig(ON_BOX_BASE_DIR_RESOLVED))) {
            return base;
        }
        if (base == null) {
            base = (String)entity.getManagementContext().getConfig().getConfig(BrooklynConfigKeys.ONBOX_BASE_DIR);
        }
        if (base == null) {
            base = (String)entity.getConfig(BrooklynConfigKeys.BROOKLYN_DATA_DIR);
        }
        if (base == null) {
            base = (String)machine.getConfig(BrooklynConfigKeys.BROOKLYN_DATA_DIR);
        }
        if (base == null) {
            base = (String)entity.getManagementContext().getConfig().getConfig(BrooklynConfigKeys.BROOKLYN_DATA_DIR);
        }
        if (base == null) {
            base = "~/brooklyn-managed-processes";
        }
        if (base.equals("~")) {
            base = ".";
        }
        if (base.startsWith("~/")) {
            base = "." + base.substring(1);
        }
        String resolvedBase = null;
        if (((Boolean)entity.getConfig(BrooklynConfigKeys.SKIP_ON_BOX_BASE_DIR_RESOLUTION)).booleanValue() || ((Boolean)machine.getConfig(BrooklynConfigKeys.SKIP_ON_BOX_BASE_DIR_RESOLUTION)).booleanValue()) {
            if (log.isDebugEnabled()) {
                log.debug("Skipping on-box base dir resolution for " + entity + " at " + machine);
            }
            if (!Os.isAbsolutish((String)base)) {
                base = "~/" + base;
            }
            resolvedBase = Os.tidyPath((String)base);
        } else if (machine instanceof CanResolveOnBoxDir) {
            resolvedBase = ((CanResolveOnBoxDir)machine).resolveOnBoxDirFor((Entity)entity, base);
        }
        if (resolvedBase == null) {
            if (!Os.isAbsolutish((String)base)) {
                base = "~/" + base;
            }
            resolvedBase = Os.tidyPath((String)base);
            log.warn("Could not resolve on-box directory for " + entity + " at " + machine + "; using " + resolvedBase + ", though this may not be accurate at the target (and may fail shortly)");
        }
        entity.config().set(BrooklynConfigKeys.ONBOX_BASE_DIR, (Object)resolvedBase);
        entity.config().set(ON_BOX_BASE_DIR_RESOLVED, (Object)true);
        return resolvedBase;
    }

    protected void checkLocationParametersCompatible(MachineLocation oldLoc, MachineLocation newLoc, String paramSummary, Object oldParam, Object newParam) {
        if (oldParam == null || newParam == null || !oldParam.equals(newParam)) {
            throw new IllegalStateException("Cannot start " + this.entity() + " in " + newLoc + " as it has already been started with incompatible location " + oldLoc + " (" + paramSummary + " not compatible: " + oldParam + " / " + newParam + "); " + newLoc + " may require manual removal.");
        }
    }

    protected void preStartCustom(MachineLocation machine, ConfigBag parameters) {
        ConfigToAttributes.apply((Entity)this.entity());
    }

    protected Map<String, Object> obtainProvisioningFlags(MachineProvisioningLocation<?> location) {
        if (this.entity() instanceof ProvidesProvisioningFlags) {
            return ((ProvidesProvisioningFlags)this.entity()).obtainProvisioningFlags(location).getAllConfig();
        }
        return MutableMap.of();
    }

    protected abstract String startProcessesAtMachine(Supplier<MachineLocation> var1);

    protected void postStartAtMachineAsync(ConfigBag parameters) {
        DynamicTasks.queue((String)"post-start", (Runnable)new PostStartTask(parameters));
    }

    protected void postStartCustom(ConfigBag parameters) {
    }

    protected boolean getDefaultRestartStopsMachine() {
        return false;
    }

    public void restart(ConfigBag parameters) {
        ServiceStateLogic.setExpectedState((Entity)this.entity(), (Lifecycle)Lifecycle.STOPPING);
        SoftwareProcess.RestartSoftwareParameters.RestartMachineMode isRestartMachine = (SoftwareProcess.RestartSoftwareParameters.RestartMachineMode)((Object)parameters.get(SoftwareProcess.RestartSoftwareParameters.RESTART_MACHINE_TYPED));
        if (isRestartMachine == null) {
            isRestartMachine = SoftwareProcess.RestartSoftwareParameters.RestartMachineMode.AUTO;
        }
        if (isRestartMachine == SoftwareProcess.RestartSoftwareParameters.RestartMachineMode.AUTO) {
            isRestartMachine = this.getDefaultRestartStopsMachine() ? SoftwareProcess.RestartSoftwareParameters.RestartMachineMode.TRUE : SoftwareProcess.RestartSoftwareParameters.RestartMachineMode.FALSE;
        }
        DynamicTasks.queue((String)"pre-restart", (Runnable)new PreRestartTask());
        if (isRestartMachine == SoftwareProcess.RestartSoftwareParameters.RestartMachineMode.FALSE) {
            DynamicTasks.queue((String)"stopping (process)", (Callable)new StopProcessesAtMachineTask());
        } else {
            MutableMap stopMachineFlags = MutableMap.of();
            if (Entitlements.getEntitlementContext() != null) {
                stopMachineFlags.put("tags", MutableSet.of((Object)BrooklynTaskTags.tagForEntitlement((EntitlementContext)Entitlements.getEntitlementContext())));
            }
            Task stopTask = Tasks.builder().displayName("stopping (machine)").body((Callable)new StopMachineTask()).flags((Map)stopMachineFlags).build();
            DynamicTasks.queue((TaskAdaptable)stopTask);
        }
        DynamicTasks.queue((String)"starting", (Runnable)new StartInLocationsTask());
        this.restartChildren(parameters);
        DynamicTasks.queue((String)"post-restart", (Runnable)new PostRestartTask());
        DynamicTasks.waitForLast();
        ServiceStateLogic.setExpectedState((Entity)this.entity(), (Lifecycle)Lifecycle.RUNNING);
    }

    protected void restartChildren(ConfigBag parameters) {
        Boolean isRestartChildren = (Boolean)parameters.get(SoftwareProcess.RestartSoftwareParameters.RESTART_CHILDREN);
        if (isRestartChildren == null || !isRestartChildren.booleanValue()) {
            return;
        }
        if (isRestartChildren.booleanValue()) {
            DynamicTasks.queue((TaskAdaptable)StartableMethods.restartingChildren((Entity)this.entity(), (ConfigBag)parameters));
            return;
        }
        throw new IllegalArgumentException("Invalid value '" + isRestartChildren + "' for " + SoftwareProcess.RestartSoftwareParameters.RESTART_CHILDREN.getName());
    }

    public void stop(ConfigBag parameters) {
        this.doStopLatching(parameters, new StopAnyProvisionedMachinesTask(parameters));
    }

    public void suspend(ConfigBag parameters) {
        this.doStopLatching(parameters, new SuspendAnyProvisionedMachinesTask());
    }

    protected void doStopLatching(ConfigBag parameters, Callable<StopMachineDetails<Integer>> stopTask) {
        try (CloseableLatch latch = MachineLifecycleEffectorTasks.waitForCloseableLatch((Entity)this.entity(), SoftwareProcess.STOP_LATCH);){
            this.doStop(parameters, stopTask);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doStop(ConfigBag parameters, Callable<StopMachineDetails<Integer>> stopTask) {
        this.preStopConfirmCustom(parameters);
        log.info("Stopping {} in {}", (Object)this.entity(), (Object)this.entity().getLocations());
        SoftwareProcess.StopSoftwareParameters.StopMode stopMachineMode = MachineLifecycleEffectorTasks.getStopMachineMode(parameters);
        SoftwareProcess.StopSoftwareParameters.StopMode stopProcessMode = (SoftwareProcess.StopSoftwareParameters.StopMode)((Object)parameters.get(SoftwareProcess.StopSoftwareParameters.STOP_PROCESS_MODE));
        DynamicTasks.queue((String)"pre-stop", (Callable)new PreStopCustomTask(parameters));
        Maybe machine = Machines.findUniqueMachineLocation((Iterable)this.entity().getLocations());
        AttributesInternal.ProvisioningTaskState provisioningState = (AttributesInternal.ProvisioningTaskState)this.entity().sensors().get(AttributesInternal.INTERNAL_PROVISIONING_TASK_STATE);
        if (machine.isAbsent() && provisioningState == AttributesInternal.ProvisioningTaskState.RUNNING) {
            Duration maxWait = (Duration)this.entity().config().get(STOP_WAIT_PROVISIONING_TIMEOUT);
            log.info("When stopping {}, waiting for up to {} for the machine to finish provisioning, before terminating it", (Object)this.entity(), (Object)maxWait);
            boolean success = Repeater.create((String)"Wait for a machine to appear").until((Callable)new Callable<Boolean>(){

                @Override
                public Boolean call() throws Exception {
                    AttributesInternal.ProvisioningTaskState state = (AttributesInternal.ProvisioningTaskState)MachineLifecycleEffectorTasks.this.entity().sensors().get(AttributesInternal.INTERNAL_PROVISIONING_TASK_STATE);
                    return state != AttributesInternal.ProvisioningTaskState.RUNNING;
                }
            }).backoffTo(Duration.FIVE_SECONDS).limitTimeTo(maxWait).run();
            if (!success) {
                log.warn("When stopping {}, timed out after {} waiting for the machine to finish provisioning - machine may we left running", (Object)this.entity(), (Object)maxWait);
            }
            machine = Maybe.ofDisallowingNull((Object)this.entity().sensors().get(INTERNAL_PROVISIONED_MACHINE));
        }
        this.entity().sensors().remove(AttributesInternal.INTERNAL_PROVISIONING_TASK_STATE);
        this.entity().sensors().remove(INTERNAL_PROVISIONED_MACHINE);
        Task stoppingProcess = null;
        if (MachineLifecycleEffectorTasks.canStop(stopProcessMode, (Entity)this.entity())) {
            stoppingProcess = Tasks.parallel((String)"stopping", (TaskAdaptable[])new TaskAdaptable[]{Tasks.create((String)"stopping (process)", (Callable)new StopProcessesAtMachineTask(parameters)), Tasks.create((String)"stopping (feeds)", (Callable)new StopFeedsAtMachineTask(parameters))});
            DynamicTasks.queue((TaskAdaptable)stoppingProcess);
        }
        Task stoppingMachine = null;
        if (MachineLifecycleEffectorTasks.canStop(stopMachineMode, machine.isAbsent())) {
            MutableMap stopMachineFlags = MutableMap.of();
            if (Entitlements.getEntitlementContext() != null) {
                stopMachineFlags.put("tags", MutableSet.of((Object)BrooklynTaskTags.tagForEntitlement((EntitlementContext)Entitlements.getEntitlementContext())));
            }
            Task stopMachineTask = Tasks.builder().displayName("stopping (machine)").body(stopTask).flags((Map)stopMachineFlags).build();
            stoppingMachine = (Task)DynamicTasks.queue((TaskAdaptable)stopMachineTask);
            DynamicTasks.drain((Duration)((Duration)this.entity().getConfig(STOP_PROCESS_TIMEOUT)), (boolean)false);
            Task task = stoppingMachine;
            synchronized (task) {
                if (!stoppingMachine.isSubmitted()) {
                    StringBuilder msg = new StringBuilder("Submitting machine stop early in background for ").append(this.entity());
                    if (stoppingProcess == null) {
                        msg.append(". Process stop skipped, pre-stop not finished?");
                    } else {
                        msg.append(" because process stop has ").append(stoppingProcess.isDone() ? "finished abnormally" : "not finished");
                    }
                    log.warn(msg.toString());
                    Entities.submit((Entity)this.entity(), (TaskAdaptable)stoppingMachine);
                }
            }
        }
        try {
            boolean checkStopProcesses;
            boolean bl = checkStopProcesses = stoppingProcess != null && (stoppingMachine == null || (Integer)((StopMachineDetails)stoppingMachine.get()).value == 0);
            if (checkStopProcesses) {
                DynamicTasks.waitForLast();
                if (machine.isPresent()) {
                    stoppingProcess.get();
                }
            }
        }
        catch (Throwable e) {
            ServiceStateLogic.setExpectedState((Entity)this.entity(), (Lifecycle)Lifecycle.ON_FIRE);
            Exceptions.propagate((Throwable)e);
        }
        this.entity().sensors().set(SoftwareProcess.SERVICE_UP, (Object)false);
        ServiceStateLogic.setExpectedState((Entity)this.entity(), (Lifecycle)Lifecycle.STOPPED);
        DynamicTasks.queue((String)"post-stop", (Callable)new PostStopCustomTask());
        if (log.isDebugEnabled()) {
            log.debug("Stopped software process entity " + this.entity());
        }
    }

    public static SoftwareProcess.StopSoftwareParameters.StopMode getStopMachineMode(ConfigBag parameters) {
        SoftwareProcess.StopSoftwareParameters.StopMode stopMachineMode = (SoftwareProcess.StopSoftwareParameters.StopMode)((Object)parameters.get(SoftwareProcess.StopSoftwareParameters.STOP_MACHINE_MODE));
        return stopMachineMode;
    }

    public static boolean canStop(SoftwareProcess.StopSoftwareParameters.StopMode stopMode, Entity entity) {
        boolean isEntityStopped = entity.getAttribute(SoftwareProcess.SERVICE_STATE_ACTUAL) == Lifecycle.STOPPED;
        return MachineLifecycleEffectorTasks.canStop(stopMode, isEntityStopped);
    }

    protected static boolean canStop(SoftwareProcess.StopSoftwareParameters.StopMode stopMode, boolean isStopped) {
        return stopMode == SoftwareProcess.StopSoftwareParameters.StopMode.ALWAYS || stopMode == SoftwareProcess.StopSoftwareParameters.StopMode.IF_NOT_STOPPED && !isStopped;
    }

    @Deprecated
    protected void preStopConfirmCustom(ConfigBag parameters) {
    }

    protected void preStopCustom(ConfigBag parameters) {
    }

    protected void postStopCustom(ConfigBag parameters) {
    }

    protected void preRestartCustom(ConfigBag parameters) {
    }

    protected void postRestartCustom(ConfigBag parameters) {
    }

    protected abstract String stopProcessesAtMachine(ConfigBag var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected StopMachineDetails<Integer> stopAnyProvisionedMachines(ConfigBag parameters) {
        MachineProvisioningLocation provisioner = (MachineProvisioningLocation)this.entity().getAttribute(SoftwareProcess.PROVISIONING_LOCATION);
        if (Iterables.isEmpty((Iterable)this.entity().getLocations())) {
            log.debug("No machine decommissioning necessary for " + this.entity() + " - no locations");
            return new StopMachineDetails<Integer>("No machine decommissioning necessary - no locations", 0);
        }
        if (provisioner == null) {
            log.debug("No machine decommissioning necessary for " + this.entity() + " - did not provision");
            return new StopMachineDetails<Integer>("No machine decommissioning necessary - did not provision", 0);
        }
        Location machine = this.getLocation(null);
        if (!(machine instanceof MachineLocation)) {
            log.debug("No decommissioning necessary for " + this.entity() + " - not a machine location (" + machine + ")");
            return new StopMachineDetails<Integer>("No machine decommissioning necessary - not a machine (" + machine + ")", 0);
        }
        this.entity().sensors().set(AttributesInternal.INTERNAL_TERMINATION_TASK_STATE, (Object)AttributesInternal.ProvisioningTaskState.RUNNING);
        try {
            StopMachineDetails<Integer> stopMachineDetails = this.stopProvisionedMachine((MachineProvisioningLocation<MachineLocation>)provisioner, machine, parameters);
            return stopMachineDetails;
        }
        finally {
            this.entity().sensors().remove(AttributesInternal.INTERNAL_TERMINATION_TASK_STATE);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected StopMachineDetails<Integer> stopProvisionedMachine(MachineProvisioningLocation<MachineLocation> provisioner, Location machine, ConfigBag parameters) {
        boolean succeeded = false;
        try {
            provisioner.release((MachineLocation)machine);
            this.clearEntityLocationAttributes(machine, true);
            succeeded = true;
        }
        finally {
            if (!succeeded) {
                if (!Locations.isManaged((Location)machine)) {
                    log.warn("Stopping " + machine + " failed, will rethrow exception shortly, but as the location is no longer managed it is being cleared on any entities");
                    this.clearEntityLocationAttributes(machine, true);
                } else {
                    log.debug("Stopping " + machine + " failed; previously attributes would have been cleared but now they are being kept to facilitate deletion in future");
                }
            }
        }
        return new StopMachineDetails<Integer>("Decommissioned " + machine, Integer.valueOf(1)){};
    }

    protected StopMachineDetails<Integer> suspendAnyProvisionedMachines(ConfigBag parameters) {
        MachineProvisioningLocation provisioner = (MachineProvisioningLocation)this.entity().getAttribute(SoftwareProcess.PROVISIONING_LOCATION);
        if (Iterables.isEmpty((Iterable)this.entity().getLocations())) {
            log.debug("No machine decommissioning necessary for " + this.entity() + " - no locations");
            return new StopMachineDetails<Integer>("No machine suspend necessary - no locations", 0);
        }
        if (provisioner == null) {
            log.debug("No machine decommissioning necessary for " + this.entity() + " - did not provision");
            return new StopMachineDetails<Integer>("No machine suspend necessary - did not provision", 0);
        }
        Location machine = this.getLocation(null);
        if (!(machine instanceof MachineLocation)) {
            log.debug("No decommissioning necessary for " + this.entity() + " - not a machine location (" + machine + ")");
            return new StopMachineDetails<Integer>("No machine suspend necessary - not a machine (" + machine + ")", 0);
        }
        if (!(provisioner instanceof MachineManagementMixins.SuspendsMachines)) {
            log.debug("Location provisioner ({}) cannot suspend machines", (Object)provisioner);
            throw new UnsupportedOperationException("Location provisioner cannot suspend machines: " + provisioner);
        }
        this.clearEntityLocationAttributes(machine, false);
        ((MachineManagementMixins.SuspendsMachines)MachineManagementMixins.SuspendsMachines.class.cast(provisioner)).suspendMachine((MachineLocation)MachineLocation.class.cast(machine));
        return new StopMachineDetails<Integer>("Suspended " + machine, 1);
    }

    protected void clearEntityLocationAttributes(Location machine) {
        this.clearEntityLocationAttributes(machine, true);
    }

    protected void clearEntityLocationAttributes(Location machine, boolean removeLocation) {
        MachineProvisioningLocation oldProvisioningLocation;
        if (removeLocation) {
            this.entity().removeLocations((Collection)ImmutableList.of((Object)machine));
        }
        if ((oldProvisioningLocation = (MachineProvisioningLocation)this.entity().sensors().get(SoftwareProcess.PROVISIONING_LOCATION)) != null && !Locations.isManaged((Location)oldProvisioningLocation)) {
            this.entity().sensors().set(SoftwareProcess.PROVISIONING_LOCATION, null);
        }
        this.entity().sensors().set(Attributes.HOSTNAME, null);
        this.entity().sensors().set(Attributes.ADDRESS, null);
        this.entity().sensors().set(Attributes.SUBNET_HOSTNAME, null);
        this.entity().sensors().set(Attributes.SUBNET_ADDRESS, null);
    }

    public static CloseableLatch waitForCloseableLatch(Entity entity, ConfigKey<Boolean> configKey) {
        ReleaseableLatch releaseableLatch = MachineLifecycleEffectorTasks.waitForLatch((EntityInternal)entity, configKey);
        return new CloseableLatch(entity, releaseableLatch);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static ReleaseableLatch waitForLatch(EntityInternal entity, ConfigKey<Boolean> configKey) {
        Maybe rawValue = entity.config().getRaw(configKey);
        if (rawValue.isAbsent()) {
            return ReleaseableLatch.NOP;
        }
        ValueResolverIterator<Boolean> iter = MachineLifecycleEffectorTasks.resolveLatchIterator(entity, rawValue.get(), configKey);
        Maybe releasableLatchMaybe = iter.next(ReleaseableLatch.class);
        if (releasableLatchMaybe.isPresent()) {
            ReleaseableLatch latch = (ReleaseableLatch)releasableLatchMaybe.get();
            log.debug("{} finished waiting for {} (value {}); waiting to acquire the latch", new Object[]{entity, configKey, latch});
            Tasks.setBlockingDetails((String)("Acquiring " + configKey + " " + latch));
            try {
                latch.acquire((Entity)entity);
            }
            finally {
                Tasks.resetBlockingDetails();
            }
            log.debug("{} Acquired latch {} (value {}); continuing...", new Object[]{entity, configKey, latch});
            return latch;
        }
        Boolean val = (Boolean)iter.last().get();
        if (rawValue != null) {
            log.debug("{} finished waiting for {} (value {}); continuing...", new Object[]{entity, configKey, val});
        }
        return ReleaseableLatch.NOP;
    }

    protected static ValueResolverIterator<Boolean> resolveLatchIterator(EntityInternal entity, Object val, ConfigKey<Boolean> key) {
        return Tasks.resolving((Object)val, Boolean.class).context(entity.getExecutionContext()).description("config " + key.getName()).iterator();
    }

    public static class CloseableLatch
    implements AutoCloseable {
        private Entity caller;
        private ReleaseableLatch releaseableLatch;

        public CloseableLatch(Entity caller, ReleaseableLatch releaseableLatch) {
            this.caller = caller;
            this.releaseableLatch = releaseableLatch;
        }

        @Override
        public void close() {
            DynamicTasks.drain(null, (boolean)false);
            this.releaseableLatch.release(this.caller);
        }
    }

    public static class StopMachineDetails<T>
    implements Serializable {
        private static final long serialVersionUID = 3256747214315895431L;
        public final String message;
        public final T value;

        public StopMachineDetails(String message, T value) {
            this.message = message;
            this.value = value;
        }

        public String toString() {
            return this.message;
        }
    }

    protected class PostStopCustomTask
    implements Callable<Void> {
        protected final ConfigBag parameters;

        public PostStopCustomTask() {
            this(null);
        }

        public PostStopCustomTask(ConfigBag parameters) {
            this.parameters = parameters;
        }

        @Override
        public Void call() {
            MachineLifecycleEffectorTasks.this.postStopCustom(this.parameters);
            return null;
        }
    }

    protected class PreStopCustomTask
    implements Callable<String> {
        protected final ConfigBag parameters;

        public PreStopCustomTask() {
            this(null);
        }

        public PreStopCustomTask(ConfigBag parameters) {
            this.parameters = parameters;
        }

        @Override
        public String call() {
            if (MachineLifecycleEffectorTasks.this.entity().getAttribute(SoftwareProcess.SERVICE_STATE_ACTUAL) == Lifecycle.STOPPED) {
                log.debug("Skipping stop of entity " + MachineLifecycleEffectorTasks.this.entity() + " when already stopped");
                return "Already stopped";
            }
            ServiceStateLogic.setExpectedState((Entity)MachineLifecycleEffectorTasks.this.entity(), (Lifecycle)Lifecycle.STOPPING);
            MachineLifecycleEffectorTasks.this.entity().sensors().set(SoftwareProcess.SERVICE_UP, (Object)false);
            MachineLifecycleEffectorTasks.this.preStopCustom(this.parameters);
            return null;
        }
    }

    protected class StopMachineTask
    implements Callable<String> {
        protected final ConfigBag parameters;

        public StopMachineTask() {
            this(null);
        }

        public StopMachineTask(ConfigBag parameters) {
            this.parameters = parameters;
        }

        @Override
        public String call() {
            DynamicTasks.markInessential();
            MachineLifecycleEffectorTasks.this.stop(ConfigBag.newInstance().configure(SoftwareProcess.StopSoftwareParameters.STOP_MACHINE_MODE, (Object)SoftwareProcess.StopSoftwareParameters.StopMode.IF_NOT_STOPPED));
            DynamicTasks.waitForLast();
            return "Stop of machine completed with no errors.";
        }
    }

    protected class StopFeedsAtMachineTask
    implements Callable<String> {
        protected final ConfigBag parameters;

        public StopFeedsAtMachineTask() {
            this(null);
        }

        public StopFeedsAtMachineTask(ConfigBag parameters) {
            this.parameters = parameters;
        }

        @Override
        public String call() {
            DynamicTasks.markInessential();
            for (Feed feed : MachineLifecycleEffectorTasks.this.entity().feeds().getFeeds()) {
                if (!feed.isActivated()) continue;
                feed.stop();
            }
            DynamicTasks.waitForLast();
            return "Stop feeds completed with no errors.";
        }
    }

    protected class StopProcessesAtMachineTask
    implements Callable<String> {
        protected final ConfigBag parameters;

        public StopProcessesAtMachineTask() {
            this(null);
        }

        public StopProcessesAtMachineTask(ConfigBag parameters) {
            this.parameters = parameters;
        }

        @Override
        public String call() {
            DynamicTasks.markInessential();
            MachineLifecycleEffectorTasks.this.stopProcessesAtMachine(this.parameters);
            DynamicTasks.waitForLast();
            return "Stop processes completed with no errors.";
        }
    }

    protected class SuspendAnyProvisionedMachinesTask
    implements Callable<StopMachineDetails<Integer>> {
        protected final ConfigBag parameters;

        public SuspendAnyProvisionedMachinesTask() {
            this(null);
        }

        public SuspendAnyProvisionedMachinesTask(ConfigBag parameters) {
            this.parameters = parameters;
        }

        @Override
        public StopMachineDetails<Integer> call() {
            return MachineLifecycleEffectorTasks.this.suspendAnyProvisionedMachines(this.parameters);
        }
    }

    protected class StopAnyProvisionedMachinesTask
    implements Callable<StopMachineDetails<Integer>> {
        private final ConfigBag parameters;

        public StopAnyProvisionedMachinesTask() {
            this(ConfigBag.newInstance());
        }

        public StopAnyProvisionedMachinesTask(ConfigBag parameters) {
            this.parameters = parameters;
        }

        @Override
        public StopMachineDetails<Integer> call() {
            return MachineLifecycleEffectorTasks.this.stopAnyProvisionedMachines(this.parameters);
        }
    }

    protected class StartInLocationsTask
    implements Runnable {
        protected final ConfigBag parameters;

        public StartInLocationsTask() {
            this(null);
        }

        public StartInLocationsTask(ConfigBag parameters) {
            this.parameters = parameters;
        }

        @Override
        public void run() {
            ServiceStateLogic.setExpectedState((Entity)MachineLifecycleEffectorTasks.this.entity(), (Lifecycle)Lifecycle.STARTING);
            MachineLifecycleEffectorTasks.this.startInLocations(null, this.parameters);
        }
    }

    protected class PostRestartTask
    implements Runnable {
        protected final ConfigBag parameters;

        public PostRestartTask() {
            this(null);
        }

        public PostRestartTask(ConfigBag parameters) {
            this.parameters = parameters;
        }

        @Override
        public void run() {
            MachineLifecycleEffectorTasks.this.postRestartCustom(this.parameters);
        }
    }

    protected class PreRestartTask
    implements Runnable {
        protected final ConfigBag parameters;

        public PreRestartTask() {
            this(null);
        }

        public PreRestartTask(ConfigBag parameters) {
            this.parameters = parameters;
        }

        @Override
        public void run() {
            MachineLifecycleEffectorTasks.this.preRestartCustom(this.parameters);
        }
    }

    protected class PostStartTask
    implements Runnable {
        protected final ConfigBag parameters;

        public PostStartTask() {
            this(null);
        }

        public PostStartTask(ConfigBag parameters) {
            this.parameters = parameters;
        }

        @Override
        public void run() {
            MachineLifecycleEffectorTasks.this.postStartCustom(this.parameters);
        }
    }

    protected class PreStartTask
    implements Runnable {
        final MachineLocation machine;
        final ConfigBag parameters;

        protected PreStartTask(MachineLocation machine) {
            this(machine, null);
        }

        protected PreStartTask(MachineLocation machine, ConfigBag parameters) {
            this.machine = machine;
            this.parameters = parameters;
        }

        @Override
        public void run() {
            ImmutableList oldSshLocs;
            log.info("Starting {} on machine {}", (Object)MachineLifecycleEffectorTasks.this.entity(), (Object)this.machine);
            Collection oldLocs = MachineLifecycleEffectorTasks.this.entity().getLocations();
            if (!oldLocs.isEmpty() && !(oldSshLocs = ImmutableList.copyOf((Iterable)Iterables.filter((Iterable)oldLocs, MachineLocation.class))).isEmpty()) {
                log.debug("Entity " + MachineLifecycleEffectorTasks.this.entity() + " had machine locations " + oldSshLocs + " when starting at " + this.machine + "; checking if they are compatible");
                for (MachineLocation oldLoc : oldSshLocs) {
                    if ("localhost".equals(this.machine.getConfig(AbstractLocation.ORIGINAL_SPEC))) continue;
                    MachineLifecycleEffectorTasks.this.checkLocationParametersCompatible(this.machine, oldLoc, "hostname", oldLoc.getAddress().getHostName(), this.machine.getAddress().getHostName());
                    MachineLifecycleEffectorTasks.this.checkLocationParametersCompatible(this.machine, oldLoc, "address", oldLoc.getAddress().getHostAddress(), this.machine.getAddress().getHostAddress());
                }
                log.debug("Entity " + MachineLifecycleEffectorTasks.this.entity() + " old machine locations " + oldSshLocs + " were compatible, removing them to start at " + this.machine);
                MachineLifecycleEffectorTasks.this.entity().removeLocations((Collection)oldSshLocs);
            }
            MachineLifecycleEffectorTasks.this.entity().addLocations((Collection)ImmutableList.of((Object)this.machine));
            Maybe lh = Machines.getSubnetHostname((Location)this.machine);
            Maybe la = Machines.getSubnetIp((Location)this.machine);
            if (lh.isPresent() && MachineLifecycleEffectorTasks.this.entity().sensors().get(Attributes.SUBNET_HOSTNAME) == null) {
                MachineLifecycleEffectorTasks.this.entity().sensors().set(Attributes.SUBNET_HOSTNAME, lh.get());
            }
            if (la.isPresent() && MachineLifecycleEffectorTasks.this.entity().sensors().get(Attributes.SUBNET_ADDRESS) == null) {
                MachineLifecycleEffectorTasks.this.entity().sensors().set(Attributes.SUBNET_ADDRESS, la.get());
            }
            if (MachineLifecycleEffectorTasks.this.entity().sensors().get(Attributes.HOSTNAME) == null) {
                MachineLifecycleEffectorTasks.this.entity().sensors().set(Attributes.HOSTNAME, (Object)this.machine.getAddress().getHostName());
            }
            if (MachineLifecycleEffectorTasks.this.entity().sensors().get(Attributes.ADDRESS) == null) {
                MachineLifecycleEffectorTasks.this.entity().sensors().set(Attributes.ADDRESS, (Object)this.machine.getAddress().getHostAddress());
            }
            if (this.machine instanceof SshMachineLocation) {
                SshMachineLocation sshMachine = (SshMachineLocation)this.machine;
                UserAndHostAndPort sshAddress = UserAndHostAndPort.fromParts((String)sshMachine.getUser(), (String)sshMachine.getAddress().getHostName(), (int)sshMachine.getPort());
                MachineLifecycleEffectorTasks.this.entity().sensors().set(Attributes.SSH_ADDRESS, (Object)sshAddress);
            }
            if (Boolean.TRUE.equals(MachineLifecycleEffectorTasks.this.entity().getConfig(SoftwareProcess.OPEN_IPTABLES))) {
                if (this.machine instanceof SshMachineLocation) {
                    Iterable inboundPorts = (Iterable)this.machine.config().get(CloudLocationConfig.INBOUND_PORTS);
                    MachineLifecycleEffectorTasks.this.machineInitTasks.openIptablesAsync(inboundPorts, (SshMachineLocation)this.machine);
                } else {
                    log.warn("Ignoring flag OPEN_IPTABLES on non-ssh location {}", (Object)this.machine);
                }
            }
            if (Boolean.TRUE.equals(MachineLifecycleEffectorTasks.this.entity().getConfig(SoftwareProcess.STOP_IPTABLES))) {
                if (this.machine instanceof SshMachineLocation) {
                    MachineLifecycleEffectorTasks.this.machineInitTasks.stopIptablesAsync((SshMachineLocation)this.machine);
                } else {
                    log.warn("Ignoring flag STOP_IPTABLES on non-ssh location {}", (Object)this.machine);
                }
            }
            if (Boolean.TRUE.equals(MachineLifecycleEffectorTasks.this.entity().getConfig(SoftwareProcess.DONT_REQUIRE_TTY_FOR_SUDO))) {
                if (this.machine instanceof SshMachineLocation) {
                    MachineLifecycleEffectorTasks.this.machineInitTasks.dontRequireTtyForSudoAsync((SshMachineLocation)this.machine);
                } else {
                    log.warn("Ignoring flag DONT_REQUIRE_TTY_FOR_SUDO on non-ssh location {}", (Object)this.machine);
                }
            }
            MachineLifecycleEffectorTasks.resolveOnBoxDir(MachineLifecycleEffectorTasks.this.entity(), this.machine);
            MachineLifecycleEffectorTasks.this.preStartCustom(this.machine, this.parameters);
        }
    }

    protected static class ObtainLocationTask
    implements Callable<MachineLocation> {
        final MachineProvisioningLocation<?> location;
        final Map<String, Object> flags;

        protected ObtainLocationTask(MachineProvisioningLocation<?> location, Map<String, Object> flags) {
            this.flags = flags;
            this.location = location;
        }

        @Override
        public MachineLocation call() throws NoMachinesAvailableException {
            return this.location.obtain(this.flags);
        }
    }

    protected class ProvisionMachineTask
    implements Callable<MachineLocation> {
        final MachineProvisioningLocation<?> location;

        protected ProvisionMachineTask(MachineProvisioningLocation<?> location) {
            this.location = location;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public MachineLocation call() throws Exception {
            MachineLocation machine;
            MachineLifecycleEffectorTasks.this.entity().getConfig(BrooklynConfigKeys.PROVISION_LATCH);
            Map<String, Object> flags = MachineLifecycleEffectorTasks.this.obtainProvisioningFlags(this.location);
            if (!(this.location instanceof LocalhostMachineProvisioningLocation)) {
                log.info("Starting {}, obtaining a new location instance in {} with ports {}", new Object[]{MachineLifecycleEffectorTasks.this.entity(), this.location, flags.get("inboundPorts")});
            }
            MachineLifecycleEffectorTasks.this.entity().sensors().set(SoftwareProcess.PROVISIONING_LOCATION, this.location);
            Lifecycle.Transition expectedState = (Lifecycle.Transition)MachineLifecycleEffectorTasks.this.entity().sensors().get(Attributes.SERVICE_STATE_EXPECTED);
            if (expectedState != null && (expectedState.getState() == Lifecycle.STOPPING || expectedState.getState() == Lifecycle.STOPPED)) {
                throw new IllegalStateException("Provisioning aborted before even begun for " + MachineLifecycleEffectorTasks.this.entity() + " in " + this.location + " (presumably by a concurrent call to stop");
            }
            MachineLifecycleEffectorTasks.this.entity().sensors().set(AttributesInternal.INTERNAL_PROVISIONING_TASK_STATE, (Object)AttributesInternal.ProvisioningTaskState.RUNNING);
            try {
                machine = (MachineLocation)Tasks.withBlockingDetails((String)("Provisioning machine in " + this.location), (Callable)new ObtainLocationTask(this.location, flags));
                MachineLifecycleEffectorTasks.this.entity().sensors().set(INTERNAL_PROVISIONED_MACHINE, (Object)machine);
            }
            finally {
                MachineLifecycleEffectorTasks.this.entity().sensors().remove(AttributesInternal.INTERNAL_PROVISIONING_TASK_STATE);
            }
            if (machine == null) {
                throw new NoMachinesAvailableException("Failed to obtain machine in " + this.location.toString());
            }
            if (log.isDebugEnabled()) {
                log.debug("While starting {}, obtained new location instance {}", (Object)MachineLifecycleEffectorTasks.this.entity(), (Object)(machine instanceof SshMachineLocation ? machine + ", details " + ((SshMachineLocation)machine).getUser() + ":" + Sanitizer.sanitize((ConfigBag)((SshMachineLocation)machine).config().getLocalBag()) : machine));
            }
            return machine;
        }
    }

    protected class StartProcessesAtMachineTask
    implements Runnable {
        private final Supplier<MachineLocation> machineSupplier;

        protected StartProcessesAtMachineTask(Supplier<MachineLocation> machineSupplier) {
            this.machineSupplier = machineSupplier;
        }

        @Override
        public void run() {
            MachineLifecycleEffectorTasks.this.startProcessesAtMachine(this.machineSupplier);
        }
    }

    protected class SuspendEffectorBody
    extends EffectorBody<Void> {
        protected SuspendEffectorBody() {
        }

        public Void call(ConfigBag parameters) {
            MachineLifecycleEffectorTasks.this.suspend(parameters);
            return null;
        }
    }

    protected class StopEffectorBody
    extends EffectorBody<Void> {
        protected StopEffectorBody() {
        }

        public Void call(ConfigBag parameters) {
            MachineLifecycleEffectorTasks.this.stop(parameters);
            return null;
        }
    }

    protected class RestartEffectorBody
    extends EffectorBody<Void> {
        protected RestartEffectorBody() {
        }

        public Void call(ConfigBag parameters) {
            MachineLifecycleEffectorTasks.this.restart(parameters);
            return null;
        }
    }

    protected class StartEffectorBody
    extends EffectorBody<Void> {
        protected StartEffectorBody() {
        }

        public Void call(ConfigBag parameters) {
            List locations = null;
            Object locationsRaw = parameters.getStringKey(LOCATIONS.getName());
            locations = Locations.coerceToCollectionOfLocationsManaged((ManagementContext)this.entity().getManagementContext(), (Object)locationsRaw);
            if (locations == null) {
                locations = Collections.emptyList();
            }
            MachineLifecycleEffectorTasks.this.start(locations);
            return null;
        }
    }
}

