/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.entity.brooklynnode;

import com.google.common.base.Function;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import org.apache.brooklyn.api.effector.Effector;
import org.apache.brooklyn.core.effector.Effectors;
import org.apache.brooklyn.entity.brooklynnode.BrooklynEntityMirrorImpl;
import org.apache.brooklyn.util.http.HttpToolResponse;

public class RemoteEffectorBuilder {
    public static Collection<Effector<String>> of(Collection<?> cfgEffectors) {
        ArrayList<Effector<String>> effectors = new ArrayList<Effector<String>>();
        for (Object objEff : cfgEffectors) {
            Map cfgEff = (Map)objEff;
            String effName = (String)cfgEff.get("name");
            String description = (String)cfgEff.get("description");
            Effectors.EffectorBuilder eff = Effectors.effector(String.class, (String)effName);
            Collection params = (Collection)cfgEff.get("parameters");
            if (description != null) {
                eff.description(description);
            }
            for (Object objParam : params) {
                RemoteEffectorBuilder.buildParam((Effectors.EffectorBuilder<String>)eff, (Map)objParam);
            }
            eff.impl(new BrooklynEntityMirrorImpl.RemoteEffector<String>(effName, new ResultParser()));
            effectors.add((Effector<String>)eff.build());
        }
        return effectors;
    }

    private static void buildParam(Effectors.EffectorBuilder<String> eff, Map<?, ?> cfgParam) {
        String name = (String)cfgParam.get("name");
        String description = (String)cfgParam.get("description");
        String defaultValue = (String)cfgParam.get("defaultValue");
        eff.parameter(Object.class, name, description, (Object)defaultValue);
    }

    private static class ResultParser
    implements Function<HttpToolResponse, String> {
        private ResultParser() {
        }

        public String apply(HttpToolResponse input) {
            return input.getContentAsString();
        }
    }
}

