/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.digitalocean2.domain.options;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import org.jclouds.digitalocean2.domain.options.AutoValue_CreateDropletOptions_DropletRequest;
import org.jclouds.http.HttpRequest;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.json.SerializedNames;
import org.jclouds.rest.MapBinder;
import org.jclouds.rest.binders.BindToJsonPayload;

public class CreateDropletOptions
implements MapBinder {
    @Inject
    private BindToJsonPayload jsonBinder;
    private final Set<Integer> sshKeys;
    private final boolean backupsEnabled;
    private final boolean ipv6Enabled;
    private final boolean privateNetworking;
    private final String userData;

    private CreateDropletOptions(Set<Integer> sshKeys, boolean backupsEnabled, boolean ipv6Enabled, boolean privateNetworking, @Nullable String userData) {
        this.sshKeys = sshKeys;
        this.backupsEnabled = backupsEnabled;
        this.ipv6Enabled = ipv6Enabled;
        this.privateNetworking = privateNetworking;
        this.userData = userData;
    }

    public <R extends HttpRequest> R bindToRequest(R request, Map<String, Object> postParams) {
        DropletRequest droplet = DropletRequest.create(Preconditions.checkNotNull((Object)postParams.get("name"), (Object)"name parameter not present").toString(), Preconditions.checkNotNull((Object)postParams.get("region"), (Object)"region parameter not present").toString(), Preconditions.checkNotNull((Object)postParams.get("size"), (Object)"size parameter not present").toString(), Preconditions.checkNotNull((Object)postParams.get("image"), (Object)"image parameter not present").toString(), this.sshKeys, this.backupsEnabled, this.ipv6Enabled, this.privateNetworking, this.userData);
        return this.bindToRequest(request, droplet);
    }

    public <R extends HttpRequest> R bindToRequest(R request, Object input) {
        return (R)this.jsonBinder.bindToRequest(request, input);
    }

    public Set<Integer> getSshKeys() {
        return this.sshKeys;
    }

    public Boolean getPrivateNetworking() {
        return this.privateNetworking;
    }

    public Boolean getBackupsEnabled() {
        return this.backupsEnabled;
    }

    public boolean isIpv6Enabled() {
        return this.ipv6Enabled;
    }

    public String getUserData() {
        return this.userData;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private ImmutableSet.Builder<Integer> sshKeyIds = ImmutableSet.builder();
        private boolean backupsEnabled;
        private boolean ipv6Enabled;
        private boolean privateNetworking;
        private String userData;

        public Builder addSshKeyIds(Iterable<Integer> sshKeyIds) {
            this.sshKeyIds.addAll(sshKeyIds);
            return this;
        }

        public Builder addSshKeyId(int sshKeyId) {
            this.sshKeyIds.add((Object)sshKeyId);
            return this;
        }

        public Builder privateNetworking(boolean privateNetworking) {
            this.privateNetworking = privateNetworking;
            return this;
        }

        public Builder backupsEnabled(boolean backupsEnabled) {
            this.backupsEnabled = backupsEnabled;
            return this;
        }

        public Builder userData(String userData) {
            this.userData = userData;
            return this;
        }

        public Builder ipv6Enabled(boolean ipv6Enabled) {
            this.ipv6Enabled = ipv6Enabled;
            return this;
        }

        public CreateDropletOptions build() {
            return new CreateDropletOptions((Set)this.sshKeyIds.build(), this.backupsEnabled, this.ipv6Enabled, this.privateNetworking, this.userData);
        }
    }

    static abstract class DropletRequest {
        abstract String name();

        abstract String region();

        abstract String size();

        abstract String image();

        abstract Set<Integer> sshKeys();

        abstract Boolean backups();

        abstract Boolean ipv6();

        abstract Boolean privateNetworking();

        @Nullable
        abstract String userData();

        @SerializedNames(value={"name", "region", "size", "image", "ssh_keys", "backups", "ipv6", "private_networking", "user_data"})
        static DropletRequest create(String name, String region, String size, String image, Set<Integer> sshKeys, Boolean backups, Boolean ipv6, Boolean privateNetworking, String userData) {
            return new AutoValue_CreateDropletOptions_DropletRequest(name, region, size, image, sshKeys, backups, ipv6, privateNetworking, userData);
        }

        DropletRequest() {
        }
    }
}

