/*
 * Decompiled with CFR 0.152.
 */
package io.cloudsoft.winrm4j.client.retry;

import io.cloudsoft.winrm4j.client.retry.BasicRetryDecision;
import io.cloudsoft.winrm4j.client.retry.RetryDecision;
import io.cloudsoft.winrm4j.client.retry.RetryPolicy;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import javax.xml.ws.WebServiceException;

public class SimpleCounterRetryPolicy
implements RetryPolicy {
    private final int maxRetries;
    private final long pauseTimeMillis;

    public SimpleCounterRetryPolicy(int maxRetries, long pauseTime, TimeUnit pauseUnit) {
        this.maxRetries = maxRetries;
        this.pauseTimeMillis = pauseUnit.toMillis(pauseTime);
    }

    @Override
    public RetryDecision onWebServiceException(WebServiceException exception, int numAttempts) {
        Optional<String> reason = Optional.of("Attempt " + numAttempts + " of " + (this.maxRetries + 1));
        return new BasicRetryDecision(numAttempts <= this.maxRetries, this.pauseTimeMillis, reason);
    }
}

