/*
 * Decompiled with CFR 0.152.
 */
package org.apache.distributedlog.bk;

import java.io.IOException;
import java.util.concurrent.CompletableFuture;
import org.apache.bookkeeper.client.LedgerHandle;
import org.apache.distributedlog.bk.LedgerAllocator;
import org.apache.distributedlog.common.concurrent.FutureUtils;
import org.apache.distributedlog.util.Transaction;

public class LedgerAllocatorDelegator
implements LedgerAllocator {
    private final LedgerAllocator allocator;
    private final boolean ownAllocator;

    public LedgerAllocatorDelegator(LedgerAllocator allocator, boolean ownAllocator) throws IOException {
        this.allocator = allocator;
        this.ownAllocator = ownAllocator;
        if (this.ownAllocator) {
            this.allocator.start();
        }
    }

    @Override
    public void start() throws IOException {
    }

    public CompletableFuture<Void> delete() {
        return FutureUtils.exception((Throwable)new UnsupportedOperationException("Can't delete an allocator by delegator"));
    }

    @Override
    public void allocate() throws IOException {
        this.allocator.allocate();
    }

    @Override
    public CompletableFuture<LedgerHandle> tryObtain(Transaction<Object> txn, Transaction.OpListener<LedgerHandle> listener) {
        return this.allocator.tryObtain(txn, listener);
    }

    public CompletableFuture<Void> asyncClose() {
        if (this.ownAllocator) {
            return this.allocator.asyncClose();
        }
        return FutureUtils.value(null);
    }
}

