/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.stats;

import com.codahale.metrics.health.HealthCheckRegistry;
import org.apache.bookkeeper.stats.CodahaleMetricsProvider;
import org.apache.bookkeeper.stats.ServletReporter;
import org.apache.commons.configuration.Configuration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CodahaleMetricsServletProvider
extends CodahaleMetricsProvider {
    private static final Logger logger = LoggerFactory.getLogger(CodahaleMetricsServletProvider.class);
    ServletReporter servletReporter = null;
    private final HealthCheckRegistry healthCheckRegistry = new HealthCheckRegistry();

    public void start(Configuration conf) {
        super.start(conf);
        Integer httpPort = conf.getInteger("codahaleStatsHttpPort", null);
        if (null != httpPort) {
            this.servletReporter = new ServletReporter(this.getMetrics(), this.healthCheckRegistry, httpPort);
            try {
                this.servletReporter.start();
            }
            catch (Exception e) {
                logger.warn("Encountered error on starting the codahale metrics servlet", (Throwable)e);
            }
        }
    }

    public void stop() {
        if (null != this.servletReporter) {
            try {
                this.servletReporter.stop();
            }
            catch (Exception e) {
                logger.error("Encountered error on stopping the codahale metrics servlet", (Throwable)e);
            }
        }
        super.stop();
    }
}

