/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.common.args.constraints;

import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.base.Preconditions;
import com.twitter.common.args.Verifier;
import com.twitter.common.args.constraints.Range;
import java.lang.annotation.Annotation;
import java.math.BigDecimal;

public class RangeNumberVerifier
implements Verifier<Number> {
    public void verify(Number value, Annotation annotation) {
        Range range = this.getRange(annotation);
        Preconditions.checkArgument((range.lower() < range.upper() ? 1 : 0) != 0, (Object)"Range lower bound must be greater than upper bound.");
        double dblValue = value.doubleValue();
        Preconditions.checkArgument((dblValue >= range.lower() && dblValue <= range.upper() ? 1 : 0) != 0, (Object)String.format("Value must be in range [%f, %f]", range.lower(), range.upper()));
    }

    public String toString(Class<? extends Number> argType, Annotation annotation) {
        Range range = this.getRange(annotation);
        Object converter = Float.class.isAssignableFrom(argType) || Double.class.isAssignableFrom(argType) || BigDecimal.class.isAssignableFrom(argType) ? Functions.identity() : new Function<Number, Number>(){

            public Number apply(Number item) {
                return item.longValue();
            }
        };
        return String.format("must be >= %s and <= %s", converter.apply((Object)range.lower()), converter.apply((Object)range.upper()));
    }

    private Range getRange(Annotation annotation) {
        Preconditions.checkArgument((boolean)(annotation instanceof Range), (Object)("Annotation is not a range: " + annotation));
        return (Range)annotation;
    }
}

