/*
 * Decompiled with CFR 0.152.
 */
package org.apache.distributedlog.service;

import com.google.common.base.Optional;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.twitter.finagle.Service;
import com.twitter.finagle.Stack;
import com.twitter.finagle.ThriftMuxServer$;
import com.twitter.finagle.builder.Server;
import com.twitter.finagle.builder.ServerBuilder;
import com.twitter.finagle.stats.NullStatsReceiver;
import com.twitter.finagle.stats.StatsReceiver;
import com.twitter.finagle.thrift.ClientIdRequiredFilter;
import com.twitter.finagle.thrift.ThriftServerFramedCodec;
import com.twitter.finagle.transport.Transport;
import com.twitter.util.Duration;
import java.io.File;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.SocketAddress;
import java.net.URI;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.bookkeeper.stats.NullStatsLogger;
import org.apache.bookkeeper.stats.StatsLogger;
import org.apache.bookkeeper.stats.StatsProvider;
import org.apache.bookkeeper.util.ReflectionUtils;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.distributedlog.DistributedLogConfiguration;
import org.apache.distributedlog.client.routing.RoutingService;
import org.apache.distributedlog.common.util.SchedulerUtils;
import org.apache.distributedlog.config.DynamicConfigurationFactory;
import org.apache.distributedlog.config.DynamicDistributedLogConfiguration;
import org.apache.distributedlog.service.DistributedLogServiceImpl;
import org.apache.distributedlog.service.StatsFilter;
import org.apache.distributedlog.service.announcer.Announcer;
import org.apache.distributedlog.service.announcer.NOPAnnouncer;
import org.apache.distributedlog.service.announcer.ServerSetAnnouncer;
import org.apache.distributedlog.service.config.DefaultStreamConfigProvider;
import org.apache.distributedlog.service.config.NullStreamConfigProvider;
import org.apache.distributedlog.service.config.ServerConfiguration;
import org.apache.distributedlog.service.config.ServiceStreamConfigProvider;
import org.apache.distributedlog.service.config.StreamConfigProvider;
import org.apache.distributedlog.service.placement.EqualLoadAppraiser;
import org.apache.distributedlog.service.placement.LoadAppraiser;
import org.apache.distributedlog.service.streamset.IdentityStreamPartitionConverter;
import org.apache.distributedlog.service.streamset.StreamPartitionConverter;
import org.apache.distributedlog.thrift.service.DistributedLogService;
import org.apache.distributedlog.util.ConfUtils;
import org.apache.thrift.protocol.TBinaryProtocol;
import org.apache.thrift.protocol.TProtocolFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function1;
import scala.Option;
import scala.Tuple2;

public class DistributedLogServer {
    private static final Logger logger = LoggerFactory.getLogger(DistributedLogServer.class);
    private static final String DEFAULT_LOAD_APPRIASER = EqualLoadAppraiser.class.getCanonicalName();
    private DistributedLogServiceImpl dlService = null;
    private Server server = null;
    private RoutingService routingService;
    private StatsProvider statsProvider;
    private Announcer announcer = null;
    private ScheduledExecutorService configExecutorService;
    private long gracefulShutdownMs = 0L;
    private final StatsReceiver statsReceiver;
    private final CountDownLatch keepAliveLatch = new CountDownLatch(1);
    private final Optional<String> uri;
    private final Optional<String> conf;
    private final Optional<String> streamConf;
    private final Optional<Integer> port;
    private final Optional<Integer> statsPort;
    private final Optional<Integer> shardId;
    private final Optional<Boolean> announceServerSet;
    private final Optional<String> loadAppraiserClassStr;
    private final Optional<Boolean> thriftmux;

    DistributedLogServer(Optional<String> uri, Optional<String> conf, Optional<String> streamConf, Optional<Integer> port, Optional<Integer> statsPort, Optional<Integer> shardId, Optional<Boolean> announceServerSet, Optional<String> loadAppraiserClass, Optional<Boolean> thriftmux, RoutingService routingService, StatsReceiver statsReceiver, StatsProvider statsProvider) {
        this.uri = uri;
        this.conf = conf;
        this.streamConf = streamConf;
        this.port = port;
        this.statsPort = statsPort;
        this.shardId = shardId;
        this.announceServerSet = announceServerSet;
        this.thriftmux = thriftmux;
        this.routingService = routingService;
        this.statsReceiver = statsReceiver;
        this.statsProvider = statsProvider;
        this.loadAppraiserClassStr = loadAppraiserClass;
    }

    public void runServer() throws ConfigurationException, IllegalArgumentException, IOException, ClassNotFoundException {
        StreamPartitionConverter converter;
        if (!this.uri.isPresent()) {
            throw new IllegalArgumentException("No distributedlog uri provided.");
        }
        URI dlUri = URI.create((String)this.uri.get());
        DistributedLogConfiguration dlConf = new DistributedLogConfiguration();
        if (this.conf.isPresent()) {
            String configFile = (String)this.conf.get();
            try {
                dlConf.loadConf(new File(configFile).toURI().toURL());
            }
            catch (ConfigurationException e) {
                throw new IllegalArgumentException("Failed to load distributedlog configuration from " + configFile + ".");
            }
            catch (MalformedURLException e) {
                throw new IllegalArgumentException("Failed to load distributedlog configuration from malformed " + configFile + ".");
            }
        }
        this.configExecutorService = Executors.newScheduledThreadPool(1, new ThreadFactoryBuilder().setNameFormat("DistributedLogService-Dyncfg-%d").setDaemon(true).build());
        ServerConfiguration serverConf = new ServerConfiguration();
        serverConf.loadConf(dlConf);
        if (this.shardId.isPresent()) {
            serverConf.setServerShardId((Integer)this.shardId.get());
        }
        serverConf.validate();
        DynamicDistributedLogConfiguration dynDlConf = this.getServiceDynConf(dlConf);
        logger.info("Starting stats provider : {}", this.statsProvider.getClass());
        this.statsProvider.start((Configuration)dlConf);
        this.announcer = this.announceServerSet.isPresent() && (Boolean)this.announceServerSet.get() != false ? new ServerSetAnnouncer(dlUri, (Integer)this.port.or((Object)0), (Integer)this.statsPort.or((Object)0), (Integer)this.shardId.or((Object)0)) : new NOPAnnouncer();
        try {
            converter = (StreamPartitionConverter)ReflectionUtils.newInstance(serverConf.getStreamPartitionConverterClass());
        }
        catch (ConfigurationException e) {
            logger.warn("Failed to load configured stream-to-partition converter. Fallback to use {}", (Object)IdentityStreamPartitionConverter.class.getName());
            converter = new IdentityStreamPartitionConverter();
        }
        Class<?> loadAppraiserClass = Class.forName((String)this.loadAppraiserClassStr.or((Object)DEFAULT_LOAD_APPRIASER));
        LoadAppraiser loadAppraiser = (LoadAppraiser)ReflectionUtils.newInstance(loadAppraiserClass);
        logger.info("Load appraiser class is " + (String)this.loadAppraiserClassStr.or((Object)"not specified.") + " Instantiated " + loadAppraiser.getClass().getCanonicalName());
        StreamConfigProvider streamConfProvider = this.getStreamConfigProvider(dlConf, converter);
        this.preRun(dlConf, serverConf);
        Pair<DistributedLogServiceImpl, Server> serverPair = DistributedLogServer.runServer(serverConf, dlConf, dynDlConf, dlUri, converter, this.routingService, this.statsProvider, (Integer)this.port.or((Object)0), this.keepAliveLatch, this.statsReceiver, this.thriftmux.isPresent(), streamConfProvider, loadAppraiser);
        this.dlService = (DistributedLogServiceImpl)serverPair.getLeft();
        this.server = (Server)serverPair.getRight();
        this.announcer.announce();
        this.routingService.startService();
        logger.info("Started the routing service.");
        this.dlService.startPlacementPolicy();
        logger.info("Started the placement policy.");
    }

    protected void preRun(DistributedLogConfiguration conf, ServerConfiguration serverConf) {
        this.gracefulShutdownMs = serverConf.getGracefulShutdownPeriodMs();
        if (!serverConf.isDurableWriteEnabled()) {
            conf.setDurableWriteEnabled(false);
        }
    }

    private DynamicDistributedLogConfiguration getServiceDynConf(DistributedLogConfiguration dlConf) throws ConfigurationException {
        Optional dynConf = Optional.absent();
        if (this.conf.isPresent()) {
            DynamicConfigurationFactory configFactory = new DynamicConfigurationFactory(this.configExecutorService, dlConf.getDynamicConfigReloadIntervalSec(), TimeUnit.SECONDS);
            dynConf = configFactory.getDynamicConfiguration((String)this.conf.get());
        }
        if (dynConf.isPresent()) {
            return (DynamicDistributedLogConfiguration)dynConf.get();
        }
        return ConfUtils.getConstDynConf((DistributedLogConfiguration)dlConf);
    }

    private StreamConfigProvider getStreamConfigProvider(DistributedLogConfiguration dlConf, StreamPartitionConverter partitionConverter) throws ConfigurationException {
        StreamConfigProvider streamConfProvider = new NullStreamConfigProvider();
        if (this.streamConf.isPresent() && this.conf.isPresent()) {
            String dynConfigPath = (String)this.streamConf.get();
            String defaultConfigFile = (String)this.conf.get();
            streamConfProvider = new ServiceStreamConfigProvider(dynConfigPath, defaultConfigFile, partitionConverter, this.configExecutorService, dlConf.getDynamicConfigReloadIntervalSec(), TimeUnit.SECONDS);
        } else if (this.conf.isPresent()) {
            String configFile = (String)this.conf.get();
            streamConfProvider = new DefaultStreamConfigProvider(configFile, this.configExecutorService, dlConf.getDynamicConfigReloadIntervalSec(), TimeUnit.SECONDS);
        }
        return streamConfProvider;
    }

    static Pair<DistributedLogServiceImpl, Server> runServer(ServerConfiguration serverConf, DistributedLogConfiguration dlConf, URI dlUri, StreamPartitionConverter converter, RoutingService routingService, StatsProvider provider, int port, boolean thriftmux, LoadAppraiser loadAppraiser) throws IOException {
        return DistributedLogServer.runServer(serverConf, dlConf, ConfUtils.getConstDynConf((DistributedLogConfiguration)dlConf), dlUri, converter, routingService, provider, port, new CountDownLatch(0), (StatsReceiver)new NullStatsReceiver(), thriftmux, new NullStreamConfigProvider(), loadAppraiser);
    }

    static Pair<DistributedLogServiceImpl, Server> runServer(ServerConfiguration serverConf, DistributedLogConfiguration dlConf, DynamicDistributedLogConfiguration dynDlConf, URI dlUri, StreamPartitionConverter partitionConverter, RoutingService routingService, StatsProvider provider, int port, CountDownLatch keepAliveLatch, StatsReceiver statsReceiver, boolean thriftmux, StreamConfigProvider streamConfProvider, LoadAppraiser loadAppraiser) throws IOException {
        logger.info("Running server @ uri {}.", (Object)dlUri);
        boolean perStreamStatsEnabled = serverConf.isPerStreamStatEnabled();
        Object perStreamStatsLogger = perStreamStatsEnabled ? provider.getStatsLogger("stream") : NullStatsLogger.INSTANCE;
        DistributedLogServiceImpl dlService = new DistributedLogServiceImpl(serverConf, dlConf, dynDlConf, streamConfProvider, dlUri, partitionConverter, routingService, provider.getStatsLogger(""), (StatsLogger)perStreamStatsLogger, keepAliveLatch, loadAppraiser);
        StatsReceiver serviceStatsReceiver = statsReceiver.scope("service");
        StatsLogger serviceStatsLogger = provider.getStatsLogger("service");
        ServerBuilder serverBuilder = ServerBuilder.get().name("DistributedLogServer").codec((Function1)ThriftServerFramedCodec.get()).reportTo(statsReceiver).keepAlive(true).bindTo((SocketAddress)new InetSocketAddress(port));
        if (thriftmux) {
            logger.info("Using thriftmux.");
            Tuple2 livenessParam = new Transport.Liveness(Duration.Top(), Duration.Top(), Option.apply((Object)true)).mk();
            serverBuilder = serverBuilder.stack((Function1)ThriftMuxServer$.MODULE$.configured(livenessParam._1(), (Stack.Param)livenessParam._2()));
        }
        logger.info("DistributedLogServer running with the following configuration : \n{}", (Object)dlConf.getPropsAsString());
        Server server = ServerBuilder.safeBuild((Service)new ClientIdRequiredFilter(serviceStatsReceiver).andThen(new StatsFilter(serviceStatsLogger).andThen((Service)new DistributedLogService.Service((DistributedLogService.ServiceIface)dlService, (TProtocolFactory)new TBinaryProtocol.Factory()))), (ServerBuilder)serverBuilder);
        logger.info("Started DistributedLog Server.");
        return Pair.of((Object)dlService, (Object)server);
    }

    static void closeServer(Pair<DistributedLogServiceImpl, Server> pair, long gracefulShutdownPeriod, TimeUnit timeUnit) {
        if (null != pair.getLeft()) {
            ((DistributedLogServiceImpl)pair.getLeft()).shutdown();
            if (gracefulShutdownPeriod > 0L) {
                try {
                    timeUnit.sleep(gracefulShutdownPeriod);
                }
                catch (InterruptedException e) {
                    logger.info("Interrupted on waiting service shutting down state propagated to all clients : ", (Throwable)e);
                }
            }
        }
        if (null != pair.getRight()) {
            logger.info("Closing dl thrift server.");
            ((Server)pair.getRight()).close();
            logger.info("Closed dl thrift server.");
        }
    }

    public void close() {
        if (null != this.announcer) {
            try {
                this.announcer.unannounce();
            }
            catch (IOException e) {
                logger.warn("Error on unannouncing service : ", (Throwable)e);
            }
            this.announcer.close();
        }
        DistributedLogServer.closeServer((Pair<DistributedLogServiceImpl, Server>)Pair.of((Object)this.dlService, (Object)this.server), this.gracefulShutdownMs, TimeUnit.MILLISECONDS);
        this.routingService.stopService();
        if (null != this.statsProvider) {
            this.statsProvider.stop();
        }
        SchedulerUtils.shutdownScheduler((ExecutorService)this.configExecutorService, (long)60L, (TimeUnit)TimeUnit.SECONDS);
        this.keepAliveLatch.countDown();
    }

    public void join() throws InterruptedException {
        this.keepAliveLatch.await();
    }

    public static DistributedLogServer runServer(Optional<String> uri, Optional<String> conf, Optional<String> streamConf, Optional<Integer> port, Optional<Integer> statsPort, Optional<Integer> shardId, Optional<Boolean> announceServerSet, Optional<String> loadAppraiserClass, Optional<Boolean> thriftmux, RoutingService routingService, StatsReceiver statsReceiver, StatsProvider statsProvider) throws ConfigurationException, IllegalArgumentException, IOException, ClassNotFoundException {
        DistributedLogServer server = new DistributedLogServer(uri, conf, streamConf, port, statsPort, shardId, announceServerSet, loadAppraiserClass, thriftmux, routingService, statsReceiver, statsProvider);
        server.runServer();
        return server;
    }
}

