/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.proto;

import io.netty.channel.Channel;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import org.apache.bookkeeper.bookie.BookieException;
import org.apache.bookkeeper.net.BookieSocketAddress;
import org.apache.bookkeeper.proto.BookieProtocol;
import org.apache.bookkeeper.proto.BookieRequestProcessor;
import org.apache.bookkeeper.proto.BookkeeperInternalCallbacks;
import org.apache.bookkeeper.proto.PacketProcessorBase;
import org.apache.bookkeeper.proto.ResponseBuilder;
import org.apache.bookkeeper.util.MathUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class WriteEntryProcessor
extends PacketProcessorBase
implements BookkeeperInternalCallbacks.WriteCallback {
    private static final Logger LOG = LoggerFactory.getLogger(WriteEntryProcessor.class);
    long startTimeNanos;

    public WriteEntryProcessor(BookieProtocol.Request request, Channel channel, BookieRequestProcessor requestProcessor) {
        super(request, channel, requestProcessor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void processPacket() {
        assert (this.request instanceof BookieProtocol.AddRequest);
        BookieProtocol.AddRequest add = (BookieProtocol.AddRequest)this.request;
        if (this.requestProcessor.bookie.isReadOnly()) {
            LOG.warn("BookieServer is running in readonly mode, so rejecting the request from the client!");
            this.sendResponse(105, ResponseBuilder.buildErrorResponse(105, add), this.requestProcessor.addRequestStats);
            return;
        }
        this.startTimeNanos = MathUtils.nowInNano();
        int rc = 0;
        try {
            if (add.isRecoveryAdd()) {
                this.requestProcessor.bookie.recoveryAddEntry(add.getData(), this, this.channel, add.getMasterKey());
            } else {
                this.requestProcessor.bookie.addEntry(add.getData(), this, this.channel, add.getMasterKey());
            }
        }
        catch (IOException e) {
            LOG.error("Error writing " + add, (Throwable)e);
            rc = 101;
        }
        catch (BookieException.LedgerFencedException lfe) {
            LOG.error("Attempt to write to fenced ledger", (Throwable)lfe);
            rc = 104;
        }
        catch (BookieException e) {
            LOG.error("Unauthorized access to ledger " + add.getLedgerId(), (Throwable)e);
            rc = 102;
        }
        finally {
            add.release();
        }
        if (rc != 0) {
            this.requestProcessor.addEntryStats.registerFailedEvent(MathUtils.elapsedNanos(this.startTimeNanos), TimeUnit.NANOSECONDS);
            this.sendResponse(rc, ResponseBuilder.buildErrorResponse(rc, add), this.requestProcessor.addRequestStats);
        }
    }

    @Override
    public void writeComplete(int rc, long ledgerId, long entryId, BookieSocketAddress addr, Object ctx) {
        if (0 == rc) {
            this.requestProcessor.addEntryStats.registerSuccessfulEvent(MathUtils.elapsedNanos(this.startTimeNanos), TimeUnit.NANOSECONDS);
        } else {
            this.requestProcessor.addEntryStats.registerFailedEvent(MathUtils.elapsedNanos(this.startTimeNanos), TimeUnit.NANOSECONDS);
        }
        this.sendResponse(rc, ResponseBuilder.buildAddResponse(this.request), this.requestProcessor.addRequestStats);
    }

    public String toString() {
        return String.format("WriteEntry(%d, %d)", this.request.getLedgerId(), this.request.getEntryId());
    }
}

